/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.clientLibrary;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="RemoteServerClientLibraries", storages={@Storage(value="remote-server-client-libraries.xml", roamingType=RoamingType.DISABLED)})
public class ClientLibraryManagerImpl
extends ClientLibraryManager
implements PersistentStateComponent<State> {
    private Map<String, List<File>> myFiles = new LinkedHashMap<String, List<File>>();

    public State getState() {
        State result = new State();
        for (Map.Entry<String, List<File>> entry : this.myFiles.entrySet()) {
            DownloadedLibraryState libraryState = new DownloadedLibraryState();
            libraryState.myId = entry.getKey();
            for (File file : entry.getValue()) {
                libraryState.myPaths.add(FileUtil.toSystemIndependentName((String)file.getAbsolutePath()));
            }
            result.myLibraries.add(libraryState);
        }
        return result;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(0);
        }
        this.myFiles = new HashMap<String, List<File>>();
        for (DownloadedLibraryState libraryState : state.myLibraries) {
            ArrayList<File> files = new ArrayList<File>();
            for (String path : libraryState.myPaths) {
                files.add(new File(path));
            }
            this.myFiles.put(libraryState.myId, files);
        }
    }

    @NotNull
    private List<File> getExistentFiles(ClientLibraryDescription description) {
        List<File> files = this.myFiles.get(description.getId());
        if (files == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                ClientLibraryManagerImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<File> existentFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.exists()) continue;
            existentFiles.add(file);
        }
        ArrayList<File> arrayList = existentFiles;
        if (arrayList == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static File getStoreDirectory(ClientLibraryDescription description) {
        return new File(PathManager.getSystemPath(), "remote-server-libraries/" + description.getId());
    }

    @NotNull
    public List<File> download(@NotNull ClientLibraryDescription libraryDescription) throws IOException {
        List<File> existentFiles;
        if (libraryDescription == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(3);
        }
        if (!(existentFiles = this.getExistentFiles(libraryDescription)).isEmpty()) {
            List<File> list = existentFiles;
            if (list == null) {
                ClientLibraryManagerImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        DownloadableFileService downloadService = DownloadableFileService.getInstance();
        URL versionsUrl = libraryDescription.getDescriptionUrl();
        DownloadableFileSetVersions versions = downloadService.createFileSetVersions(null, new URL[]{versionsUrl});
        List descriptions = versions.fetchVersions();
        if (descriptions.isEmpty()) {
            throw new IOException("No client library versions loaded");
        }
        FileDownloader downloader = downloadService.createDownloader((DownloadableFileSetDescription)descriptions.get(0));
        List downloaded = downloader.download(ClientLibraryManagerImpl.getStoreDirectory(libraryDescription));
        List<File> files = this.myFiles.get(libraryDescription.getId());
        if (files == null) {
            files = new ArrayList<File>();
            this.myFiles.put(libraryDescription.getId(), files);
        }
        for (Pair pair : downloaded) {
            files.add((File)pair.getFirst());
        }
        List<File> list = files;
        if (list == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistentFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class State {
        @Property(surroundWithTag=false)
        @XCollection
        public List<DownloadedLibraryState> myLibraries = new ArrayList<DownloadedLibraryState>();
    }

    @Tag(value="client-library")
    public static class DownloadedLibraryState {
        @Attribute(value="id")
        public String myId;
        @Property(surroundWithTag=false)
        @XCollection(elementName="file", valueAttributeName="path")
        public List<String> myPaths = new ArrayList<String>();
    }
}

