/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployToServerConfigurationType<C extends ServerConfiguration>
extends ConfigurationTypeBase {
    @NotNull
    private final ServerType<C> myServerType;
    @Nullable
    private final MultiSourcesConfigurationFactory myMultiSourcesFactory;
    private final Map<String, SingletonTypeConfigurationFactory> myPerTypeFactories;

    public DeployToServerConfigurationType(@NotNull ServerType<C> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(0);
        }
        super(serverType.getId() + "-deploy", serverType.getDeploymentConfigurationTypePresentableName(), CloudBundle.message((String)"deploy.to.server.configuration.type.description", (Object[])new Object[]{serverType.getPresentableName()}), (Icon)null);
        this.myPerTypeFactories = new HashMap<String, SingletonTypeConfigurationFactory>();
        this.myServerType = serverType;
        if (serverType.mayHaveProjectSpecificDeploymentSources()) {
            this.myMultiSourcesFactory = new MultiSourcesConfigurationFactory();
            this.addFactory((ConfigurationFactory)this.myMultiSourcesFactory);
        } else {
            this.myMultiSourcesFactory = null;
        }
        for (SingletonDeploymentSourceType next : serverType.getSingletonDeploymentSourceTypes()) {
            SingletonTypeConfigurationFactory nextFactory = new SingletonTypeConfigurationFactory(this, next);
            this.addFactory((ConfigurationFactory)nextFactory);
            this.myPerTypeFactories.put(next.getId(), nextFactory);
        }
    }

    @NotNull
    public ConfigurationFactory getFactoryForType(@Nullable DeploymentSourceType<?> sourceType) {
        MultiSourcesConfigurationFactory result = null;
        if (sourceType instanceof SingletonDeploymentSourceType && this.myServerType.getSingletonDeploymentSourceTypes().contains(sourceType)) {
            result = (ConfigurationFactory)this.myPerTypeFactories.get(sourceType.getId());
        }
        if (result == null) {
            result = this.myMultiSourcesFactory;
        }
        assert (result != null) : "server type: " + this.myServerType.getId() + ", requested source type: " + String.valueOf(sourceType);
        MultiSourcesConfigurationFactory multiSourcesConfigurationFactory = result;
        if (multiSourcesConfigurationFactory == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(1);
        }
        return multiSourcesConfigurationFactory;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myServerType.getIcon();
        if (icon == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        String string = "reference.dialogs.rundebug." + this.getId();
        if (string == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryForType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public final class MultiSourcesConfigurationFactory
    extends DeployToServerConfigurationFactory {
        @NotNull
        @NonNls
        public String getId() {
            String string = DeployToServerConfigurationType.this.myServerType.getDeploymentConfigurationFactoryId();
            if (string == null) {
                MultiSourcesConfigurationFactory.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$MultiSourcesConfigurationFactory", "getId"));
        }
    }

    public final class SingletonTypeConfigurationFactory
    extends DeployToServerConfigurationFactory {
        @NotNull
        @NonNls
        private final String mySourceTypeId;
        @NotNull
        @Nls
        private final String myPresentableName;

        public SingletonTypeConfigurationFactory(@NotNull DeployToServerConfigurationType this$0, SingletonDeploymentSourceType sourceType) {
            if (sourceType == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(0);
            }
            this.mySourceTypeId = sourceType.getId();
            this.myPresentableName = sourceType.getPresentableName();
        }

        @NotNull
        @NonNls
        public String getId() {
            String string = this.mySourceTypeId;
            if (string == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        @Nls
        public String getName() {
            String string = this.myPresentableName;
            if (string == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public DeployToServerRunConfiguration<C, ?> createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(3);
            }
            DeployToServerRunConfiguration result = super.createTemplateConfiguration(project);
            DeploymentSourceType<?> type = this.getSourceTypeImpl();
            if (type instanceof SingletonDeploymentSourceType) {
                result.lockDeploymentSource((SingletonDeploymentSourceType)type);
            }
            DeployToServerRunConfiguration deployToServerRunConfiguration = result;
            if (deployToServerRunConfiguration == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(4);
            }
            return deployToServerRunConfiguration;
        }

        @Nullable
        private DeploymentSourceType<?> getSourceTypeImpl() {
            return (DeploymentSourceType)DeploymentSourceType.EP_NAME.findFirstSafe(next -> this.mySourceTypeId.equals(next.getId()));
        }

        public boolean isEditableInDumbMode() {
            return this.getSourceTypeImpl().isEditableInDumbMode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    public abstract class DeployToServerConfigurationFactory
    extends ConfigurationFactoryEx<DeployToServerRunConfiguration<C, ?>> {
        public DeployToServerConfigurationFactory() {
            super((ConfigurationType)DeployToServerConfigurationType.this);
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(0);
            }
            return DeployToServerConfigurationType.this.myServerType.canAutoDetectConfiguration() || !RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType).isEmpty();
        }

        @NotNull
        public DeployToServerRunConfiguration<C, ?> createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(1);
            }
            DeploymentConfigurator deploymentConfigurator = DeployToServerConfigurationType.this.myServerType.createDeploymentConfigurator(project);
            return new DeployToServerRunConfiguration(project, (ConfigurationFactory)this, "", DeployToServerConfigurationType.this.myServerType, deploymentConfigurator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$DeployToServerConfigurationFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTemplateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

