/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RemoteAgentClassLoaderCache {
    private static final Logger LOG = Logger.getInstance(RemoteAgentClassLoaderCache.class);
    private final Map<Set<URL>, URLClassLoader> myUrls2ClassLoader = new HashMap<Set<URL>, URLClassLoader>();

    public URLClassLoader getOrCreateClassLoader(Set<URL> libraryUrls) {
        URLClassLoader result = this.myUrls2ClassLoader.get(libraryUrls);
        if (result == null) {
            result = RemoteAgentClassLoaderCache.createClassLoaderWithoutApplicationParent(libraryUrls);
            this.myUrls2ClassLoader.put(libraryUrls, result);
        }
        return result;
    }

    public static URLClassLoader createClassLoaderWithoutApplicationParent(Set<URL> libraryUrls) {
        ClassLoader platformOrBootstrap = ClassLoader.getPlatformClassLoader();
        LOG.info("platform class loader: " + String.valueOf(platformOrBootstrap));
        return new URLClassLoader(libraryUrls.toArray(new URL[0]), platformOrBootstrap);
    }
}

