/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.product.impl;

import com.intellij.platform.runtime.product.IncludedRuntimeModule;
import com.intellij.platform.runtime.product.PluginModuleGroup;
import com.intellij.platform.runtime.product.ProductMode;
import com.intellij.platform.runtime.product.RuntimeModuleLoadingRule;
import com.intellij.platform.runtime.product.impl.ProductModeMatcher;
import com.intellij.platform.runtime.product.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.product.serialization.ResourceFileResolver;
import com.intellij.platform.runtime.product.serialization.impl.PluginXmlReader;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PluginModuleGroupImpl
implements PluginModuleGroup {
    private final RuntimeModuleDescriptor myMainModule;
    private final ProductMode myCurrentMode;
    private final RuntimeModuleRepository myRepository;
    private final ResourceFileResolver myResourceFileResolver;
    private volatile List<IncludedRuntimeModule> myIncludedModules;
    private volatile Set<RuntimeModuleId> myOptionalModuleIds;
    private volatile Map<RuntimeModuleId, List<RuntimeModuleId>> myNotLoadedModuleIds;

    public PluginModuleGroupImpl(@NotNull RuntimeModuleDescriptor mainModule, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository, @NotNull ResourceFileResolver resourceFileResolver) {
        if (mainModule == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(0);
        }
        if (currentMode == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(2);
        }
        if (resourceFileResolver == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(3);
        }
        this.myMainModule = mainModule;
        this.myCurrentMode = currentMode;
        this.myRepository = repository;
        this.myResourceFileResolver = resourceFileResolver;
    }

    @Override
    @NotNull
    public RuntimeModuleDescriptor getMainModule() {
        RuntimeModuleDescriptor runtimeModuleDescriptor = this.myMainModule;
        if (runtimeModuleDescriptor == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(4);
        }
        return runtimeModuleDescriptor;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IncludedRuntimeModule> getIncludedModules() {
        if (this.myIncludedModules == null) {
            this.loadIncludedModules();
        }
        List<IncludedRuntimeModule> list = this.myIncludedModules;
        if (list == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull RuntimeModuleId, @NotNull List<@NotNull RuntimeModuleId>> getNotLoadedModuleIds() {
        if (this.myNotLoadedModuleIds == null) {
            this.loadIncludedModules();
        }
        Map<RuntimeModuleId, List<RuntimeModuleId>> map = this.myNotLoadedModuleIds;
        if (map == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(6);
        }
        return map;
    }

    private void loadIncludedModules() {
        List<RawIncludedRuntimeModule> rawIncludedModules = PluginXmlReader.loadPluginModules(this.myMainModule, this.myRepository, this.myResourceFileResolver);
        ArrayList<IncludedRuntimeModule> includedModules = new ArrayList<IncludedRuntimeModule>();
        LinkedHashSet<RuntimeModuleId> optionalModuleIds = new LinkedHashSet<RuntimeModuleId>();
        ProductModeMatcher matcher = new ProductModeMatcher(this.myCurrentMode);
        for (RawIncludedRuntimeModule rawModule : rawIncludedModules) {
            IncludedRuntimeModule included = rawModule.resolve(this.myRepository);
            if (included != null && matcher.matches(included.getModuleDescriptor())) {
                includedModules.add(included);
            }
            if (!rawModule.getLoadingRule().equals((Object)RuntimeModuleLoadingRule.OPTIONAL)) continue;
            optionalModuleIds.add(rawModule.getModuleId());
        }
        this.myOptionalModuleIds = optionalModuleIds;
        this.myIncludedModules = includedModules;
        this.myNotLoadedModuleIds = matcher.getUnmatchedModules();
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull RuntimeModuleId> getOptionalModuleIds() {
        if (this.myOptionalModuleIds == null) {
            this.loadIncludedModules();
        }
        Set<RuntimeModuleId> set = this.myOptionalModuleIds;
        if (set == null) {
            PluginModuleGroupImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    public String toString() {
        return "PluginModuleGroup{mainModule=" + this.myMainModule.getModuleId().getStringId() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFileResolver";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/product/impl/PluginModuleGroupImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/product/impl/PluginModuleGroupImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotLoadedModuleIds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalModuleIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

