/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.serviceContainer.HolderAdapter;
import com.intellij.serviceContainer.LightServiceInstanceSupportKt;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a7\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u001a]\u0010\u0019\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u001b0\u001a2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001d\u001a#\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002\u00a2\u0006\u0002\u0010 \u001aF\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a2\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001aD\u0010&\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001aF\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"&\u0010\u0000\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"8\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"constructorComparator", "Ljava/util/Comparator;", "Ljava/lang/reflect/Constructor;", "Lkotlin/Comparator;", "badAppLevelClasses", "", "", "kotlin.jvm.PlatformType", "", "getBadAppLevelClasses$annotations", "()V", "instantiateUsingPicoContainer", "T", "aClass", "Ljava/lang/Class;", "requestorKey", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "(Ljava/lang/Class;Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginId;Lcom/intellij/serviceContainer/ComponentManagerImpl;)Ljava/lang/Object;", "isApplicableClass", "", "type", "getGreediestSatisfiableConstructor", "Lkotlin/Pair;", "", "sortedMatchingConstructors", "(Ljava/lang/Class;[Ljava/lang/reflect/Constructor;Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginId;Lcom/intellij/serviceContainer/ComponentManagerImpl;)Lkotlin/Pair;", "getSortedMatchingConstructors", "componentImplementation", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", "resolveInstance", "requestorClass", "requestorConstructor", "expectedType", "handleUnsatisfiedDependency", "isResolvable", "findTargetAdapter", "Lorg/picocontainer/ComponentAdapter;", "intellij.platform.serviceContainer"})
@SourceDebugExtension(value={"SMAP\nconstructorInjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constructorInjection.kt\ncom/intellij/serviceContainer/ConstructorInjectionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,321:1\n13022#2,2:322\n*S KotlinDebug\n*F\n+ 1 constructorInjection.kt\ncom/intellij/serviceContainer/ConstructorInjectionKt\n*L\n151#1:322,2\n*E\n"})
public final class ConstructorInjectionKt {
    @NotNull
    private static final Comparator<Constructor<?>> constructorComparator = ConstructorInjectionKt::constructorComparator$lambda$0;
    private static final Set<String> badAppLevelClasses = Set.of("com.intellij.execution.executors.DefaultDebugExecutor", "org.apache.http.client.HttpClient", "org.apache.http.impl.client.CloseableHttpClient", "com.intellij.openapi.project.Project");

    private static /* synthetic */ void getBadAppLevelClasses$annotations() {
    }

    public static final <T> T instantiateUsingPicoContainer(@NotNull Class<?> aClass, @NotNull Object requestorKey, @NotNull PluginId pluginId, @NotNull ComponentManagerImpl componentManager) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)((Object)componentManager), (String)"componentManager");
        Object[] sortedMatchingConstructors = ConstructorInjectionKt.getSortedMatchingConstructors(aClass);
        Class<?>[] parameterTypes = null;
        Constructor constructor = null;
        if (sortedMatchingConstructors.length == 1) {
            constructor = (Constructor)ArraysKt.first((Object[])sortedMatchingConstructors);
            Class<?>[] classArray = constructor.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            parameterTypes = classArray;
        } else {
            Pair<Constructor<?>, Class<?>[]> result = ConstructorInjectionKt.getGreediestSatisfiableConstructor(aClass, sortedMatchingConstructors, requestorKey, pluginId, componentManager);
            constructor = (Constructor)result.getFirst();
            parameterTypes = (Class[])result.getSecond();
        }
        try {
            constructor.setAccessible(true);
            if (parameterTypes.length == 0) {
                return constructor.newInstance(new Object[0]);
            }
            boolean isErrorLogged = false;
            int n = parameterTypes.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2 = i;
                Class<?> parameterType = parameterTypes[n2];
                if (ComponentManager.class == parameterType) {
                    object = componentManager;
                } else if (parameterType == MessageBus.class) {
                    object = componentManager.getMessageBus();
                } else if (parameterType == CoroutineScope.class) {
                    object = componentManager.instanceCoroutineScope(aClass);
                } else {
                    if (!isErrorLogged && !ComponentManager.class.isAssignableFrom(parameterType)) {
                        isErrorLogged = true;
                        String message = ContainerUtilKt.doNotUseConstructorInjectionsMessage("requestorClass=" + aClass.getName() + ")");
                        if (componentManager.getApplication() == null) {
                            ComponentManagerImplKt.getLOG().warn(message);
                        } else {
                            PluginException.logPluginError((Logger)ComponentManagerImplKt.getLOG(), (String)message, null, aClass);
                        }
                    }
                    object = ConstructorInjectionKt.resolveInstance(componentManager, requestorKey, aClass, constructor, parameterType, pluginId);
                }
                objectArray[n2] = object;
            }
            Object[] params = objectArray;
            return constructor.newInstance(Arrays.copyOf(params, params.length));
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot create class " + aClass, e);
        }
    }

    public static final boolean isApplicableClass(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return !type.isPrimitive() && !type.isAnnotation() && !type.isSynthetic() && !type.isEnum() && !type.isArray() && type != String.class && type != Class.class && type != File.class && type != Path.class && !Number.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    private static final Pair<Constructor<?>, Class<?>[]> getGreediestSatisfiableConstructor(Class<?> aClass, Constructor<?>[] sortedMatchingConstructors, Object requestorKey, PluginId pluginId, ComponentManagerImpl componentManager) {
        Collection collection;
        HashSet conflicts = null;
        Set unsatisfiableDependencyTypes = null;
        Constructor<?> greediestConstructor = null;
        Class<?>[] greediestConstructorParameterTypes = null;
        int lastSatisfiableConstructorSize = -1;
        Class<?> unsatisfiedDependencyType = null;
        int lastIndex = sortedMatchingConstructors.length - 1;
        boolean someConstructorWasChecked = false;
        int index = 0;
        if (index <= lastIndex) {
            while (true) {
                Constructor<?> constructor;
                if (!(constructor = sortedMatchingConstructors[index]).isSynthetic()) {
                    boolean failedDependency = false;
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (lastIndex <= 0 || !constructor.isAnnotationPresent(NonInjectable.class) && !constructor.isAnnotationPresent(Deprecated.class)) {
                        boolean bl;
                        int n;
                        block20: {
                            Intrinsics.checkNotNull(parameterTypes);
                            Class<?>[] $this$all$iv = parameterTypes;
                            boolean $i$f$all = false;
                            int n2 = $this$all$iv.length;
                            for (n = 0; n < n2; ++n) {
                                Class<?> element$iv;
                                Class<?> p0 = element$iv = $this$all$iv[n];
                                boolean bl2 = false;
                                if (ConstructorInjectionKt.isApplicableClass(p0)) continue;
                                bl = false;
                                break block20;
                            }
                            bl = true;
                        }
                        if (bl) {
                            if (!someConstructorWasChecked && index == lastIndex) {
                                return new Pair(constructor, parameterTypes);
                            }
                            someConstructorWasChecked = true;
                            Object object = parameterTypes;
                            n = ((Class<?>[])object).length;
                            for (int i = 0; i < n; ++i) {
                                Class<?> expectedType = object[i];
                                Intrinsics.checkNotNull(expectedType);
                                if (ConstructorInjectionKt.isResolvable(componentManager, requestorKey, aClass, constructor, expectedType, pluginId)) continue;
                                if (unsatisfiableDependencyTypes == null) {
                                    unsatisfiableDependencyTypes = new HashSet();
                                }
                                unsatisfiableDependencyTypes.add(parameterTypes);
                                unsatisfiedDependencyType = expectedType;
                                failedDependency = true;
                                break;
                            }
                            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                                object = conflicts;
                                if (object == null || object.isEmpty()) {
                                    Intrinsics.checkNotNull(greediestConstructorParameterTypes);
                                    return new Pair(greediestConstructor, greediestConstructorParameterTypes);
                                }
                                ((Set)conflicts).add(constructor);
                            } else if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                                if (conflicts == null) {
                                    conflicts = new HashSet();
                                }
                                ((Set)conflicts).add(constructor);
                                if (greediestConstructor != null) {
                                    Constructor<?> it;
                                    boolean bl3 = false;
                                    ((Set)conflicts).add(it);
                                }
                            } else if (!failedDependency) {
                                greediestConstructor = constructor;
                                greediestConstructorParameterTypes = parameterTypes;
                                lastSatisfiableConstructorSize = parameterTypes.length;
                            }
                        }
                    }
                }
                if (index == lastIndex) break;
                ++index;
            }
        }
        if (!((collection = (Collection)conflicts) == null || collection.isEmpty())) {
            throw new PluginException("Too many satisfiable constructors: " + ArraysKt.joinToString$default((Object[])sortedMatchingConstructors, null, null, null, (int)0, null, null, (int)63, null), pluginId);
        }
        if (greediestConstructor != null) {
            Intrinsics.checkNotNull(greediestConstructorParameterTypes);
            return new Pair(greediestConstructor, greediestConstructorParameterTypes);
        }
        collection = unsatisfiableDependencyTypes;
        if (!(collection == null || collection.isEmpty())) {
            throw new PluginException(aClass.getName() + " has unsatisfied dependency: " + unsatisfiedDependencyType + " among unsatisfiable dependencies: " + unsatisfiableDependencyTypes + " where " + componentManager + " was the leaf container being asked for dependencies.", pluginId);
        }
        Constructor<?>[] constructorArray = aClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        throw new PluginException("The specified parameters not match any of the following constructors: " + ArraysKt.joinToString$default((Object[])constructorArray, (CharSequence)"\n", null, null, (int)0, null, ConstructorInjectionKt::getGreediestSatisfiableConstructor$lambda$1, (int)30, null) + "\nfor " + aClass, pluginId);
    }

    private static final Constructor<?>[] getSortedMatchingConstructors(Class<?> componentImplementation) {
        Object[] declaredConstructors = componentImplementation.getDeclaredConstructors();
        Intrinsics.checkNotNull(declaredConstructors);
        ArraysKt.sortWith((Object[])declaredConstructors, constructorComparator);
        return declaredConstructors;
    }

    private static final Object resolveInstance(ComponentManagerImpl componentManager, Object requestorKey, Class<?> requestorClass, Constructor<?> requestorConstructor, Class<?> expectedType, PluginId pluginId) {
        Object object;
        if (LightServiceInstanceSupportKt.isLightService(expectedType)) {
            throw new PluginException("Constructor injection for light services is not supported (requestorClass=" + requestorClass + ", requestedService=" + expectedType + ")", pluginId);
        }
        ComponentAdapter componentAdapter = ConstructorInjectionKt.findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId);
        if (componentAdapter == null) {
            return ConstructorInjectionKt.handleUnsatisfiedDependency(componentManager, requestorClass, expectedType, pluginId);
        }
        ComponentAdapter adapter = componentAdapter;
        if (adapter instanceof HolderAdapter) {
            object = ((HolderAdapter)adapter).getComponentInstance();
        } else if (componentManager.parent == null) {
            object = adapter.getComponentInstance();
        } else {
            Object object2 = adapter.getComponentKey();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getComponentKey(...)");
            object = componentManager.getComponentInstance$intellij_platform_serviceContainer(object2);
        }
        return object;
    }

    private static final Object handleUnsatisfiedDependency(ComponentManagerImpl componentManager, Class<?> requestorClass, Class<?> expectedType, PluginId pluginId) {
        if (Intrinsics.areEqual((Object)requestorClass.getName(), (Object)"com.intellij.execution.executors.DefaultDebugExecutor")) {
            ExtensionPointImpl extensionPointImpl = componentManager.getExtensionArea().getExtensionPointIfRegistered("com.intellij.executor");
            return extensionPointImpl != null ? extensionPointImpl.findExtension(requestorClass, false, ThreeState.YES) : null;
        }
        throw new PluginException(ContainerUtilKt.doNotUseConstructorInjectionsMessage("requestorClass=" + requestorClass.getName() + ", extensionClass=" + expectedType.getName()), pluginId);
    }

    private static final boolean isResolvable(ComponentManagerImpl componentManager, Object requestorKey, Class<?> requestorClass, Constructor<?> requestorConstructor, Class<?> expectedType, PluginId pluginId) {
        return expectedType == ComponentManager.class || expectedType == CoroutineScope.class || ConstructorInjectionKt.findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId) != null;
    }

    private static final ComponentAdapter findTargetAdapter(ComponentManagerImpl componentManager, Class<?> expectedType, Object requestorKey, Class<?> requestorClass, Constructor<?> requestorConstructor, PluginId pluginId) {
        Object object;
        HolderAdapter byKey = componentManager.getComponentOrServiceAdapter$intellij_platform_serviceContainer(expectedType, true);
        if (byKey != null && !Intrinsics.areEqual((Object)requestorKey, (Object)byKey.getComponentKey())) {
            return byKey;
        }
        String className = expectedType.getName();
        if (componentManager.parent == null ? badAppLevelClasses.contains(className) : Intrinsics.areEqual((Object)className, (Object)"com.intellij.configurationStore.StreamProvider") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.impl.CompilerModuleExtensionImpl") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.impl.JavaModuleExternalPathsImpl")) {
            return null;
        }
        if (componentManager.isGetComponentAdapterOfTypeCheckEnabled$intellij_platform_serviceContainer()) {
            ComponentManagerImplKt.getLOG().error((Throwable)new PluginException("getComponentAdapterOfType is used to get " + expectedType.getName() + " (requestorClass=" + requestorClass.getName() + ", requestorConstructor=" + requestorConstructor + ").\n\nProbably constructor should be marked as NonInjectable.", pluginId));
        }
        if ((object = componentManager.getComponentAdapterOfType$intellij_platform_serviceContainer(expectedType)) == null) {
            ComponentManagerImpl componentManagerImpl = componentManager.parent;
            object = componentManagerImpl != null ? componentManagerImpl.getComponentAdapterOfType$intellij_platform_serviceContainer(expectedType) : null;
        }
        return object;
    }

    private static final int constructorComparator$lambda$0(Constructor c0, Constructor c1) {
        return c1.getParameterCount() - c0.getParameterCount();
    }

    private static final CharSequence getGreediestSatisfiableConstructor$lambda$1(Constructor it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

