/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.platform.settings.SettingSerializerDescriptor;
import com.intellij.platform.settings.SettingTag;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u001eB5\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010\u001b\u001a\u00020\u0004H\u0096\u0080\u0004J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/settings/SettingDescriptor;", "T", "", "key", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "tags", "", "Lcom/intellij/platform/settings/SettingTag;", "serializer", "Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginId;Ljava/util/Collection;Lcom/intellij/platform/settings/SettingSerializerDescriptor;)V", "getKey", "()Ljava/lang/String;", "getPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "getTags", "()Ljava/util/Collection;", "getSerializer", "()Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "equals", "", "other", "hashCode", "", "toString", "withSubName", "name", "Builder", "intellij.platform.settings"})
public final class SettingDescriptor<T> {
    @NotNull
    private final String key;
    @NotNull
    private final PluginId pluginId;
    @NotNull
    private final Collection<SettingTag> tags;
    @NotNull
    private final SettingSerializerDescriptor<T> serializer;

    @IntellijInternalApi
    @ApiStatus.Internal
    public SettingDescriptor(@NotNull String key, @NotNull PluginId pluginId, @NotNull Collection<? extends SettingTag> tags, @NotNull SettingSerializerDescriptor<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.key = key;
        this.pluginId = pluginId;
        this.tags = tags;
        this.serializer = serializer;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final PluginId getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public final Collection<SettingTag> getTags() {
        return this.tags;
    }

    @NotNull
    public final SettingSerializerDescriptor<T> getSerializer() {
        return this.serializer;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SettingDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)((SettingDescriptor)other).key)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pluginId, (Object)((SettingDescriptor)other).pluginId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, ((SettingDescriptor)other).tags)) {
            return false;
        }
        return Intrinsics.areEqual(this.serializer, ((SettingDescriptor)other).serializer);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.pluginId.hashCode();
        result = 31 * result + ((Object)this.tags).hashCode();
        result = 31 * result + this.serializer.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "SettingDescriptor(key=" + this.key + ", pluginId=" + this.pluginId + ", tags=" + this.tags + ", serializer=" + this.serializer + ")";
    }

    @ApiStatus.Internal
    @NotNull
    public final SettingDescriptor<T> withSubName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SettingDescriptor<T>(this.key + "." + name, this.pluginId, this.tags, this.serializer);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0001\u0010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u0013H\u0001R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/settings/SettingDescriptor$Builder;", "", "<init>", "()V", "tags", "", "Lcom/intellij/platform/settings/SettingTag;", "getTags", "()Ljava/util/Collection;", "setTags", "(Ljava/util/Collection;)V", "build", "Lcom/intellij/platform/settings/SettingDescriptor;", "T", "key", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "serializer", "Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "intellij.platform.settings"})
    public static final class Builder {
        @NotNull
        private Collection<? extends SettingTag> tags;

        @PublishedApi
        public Builder() {
            List list = List.of();
            Intrinsics.checkNotNullExpressionValue(list, (String)"of(...)");
            this.tags = list;
        }

        @NotNull
        public final Collection<SettingTag> getTags() {
            return this.tags;
        }

        public final void setTags(@NotNull Collection<? extends SettingTag> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.tags = collection;
        }

        @PublishedApi
        @NotNull
        public final <T> SettingDescriptor<T> build(@NotNull String key, @NotNull PluginId pluginId, @NotNull SettingSerializerDescriptor<T> serializer) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            Collection<? extends SettingTag> collection = this.tags;
            return new SettingDescriptor<T>(key, pluginId, collection, serializer);
        }
    }
}

