/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.settings;

import com.intellij.platform.settings.SettingDescriptor;
import com.jetbrains.rd.platform.codeWithMe.settings.LazySerializedValue;
import com.jetbrains.rd.platform.codeWithMe.settings.LazySettingsStorageKt;
import com.jetbrains.rd.platform.codeWithMe.settings.RdSettingsStorageService;
import com.jetbrains.rd.platform.codeWithMe.settings.SettingsLogsUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u000f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\u00020\u00142\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0000\u00a2\u0006\u0002\b\u0015J#\u0010\u0016\u001a\u0004\u0018\u00010\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0017\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001cJ!\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nH\u0000\u00a2\u0006\u0002\b\u001fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/settings/LazySettingsStorage;", "", "<init>", "()V", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/rd/platform/codeWithMe/settings/LazySerializedValue;", "pluginIdMap", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getRemotePluginId", "localPluginId", "key", "componentName", "getRemoteEffectiveKey", "Lcom/intellij/platform/settings/SettingDescriptor;", "get", "get$intellij_platform_split", "contains", "", "contains$intellij_platform_split", "put", "value", "put$intellij_platform_split", "putRemote", "", "effectiveKey", "putRemote$intellij_platform_split", "updatePluginIdMap", "newMap", "updatePluginIdMap$intellij_platform_split", "intellij.platform.split"})
public final class LazySettingsStorage {
    @NotNull
    private final ConcurrentHashMap<String, LazySerializedValue> storage = new ConcurrentHashMap();
    @NotNull
    private final AtomicReference<Map<String, String>> pluginIdMap = new AtomicReference<Map>(MapsKt.emptyMap());

    private final String getRemotePluginId(String localPluginId, String key, String componentName) {
        if (componentName == null) {
            SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(LazySettingsStorageKt.access$getLogger$p(), key, (Function0<String>)((Function0)() -> LazySettingsStorage.getRemotePluginId$lambda$0(localPluginId, key)));
            return localPluginId;
        }
        String string = this.pluginIdMap.get().get(localPluginId + "." + componentName);
        if (string == null) {
            string = localPluginId;
        }
        return string;
    }

    private final String getRemoteEffectiveKey(SettingDescriptor<?> key) {
        String componentName = RdSettingsStorageService.Companion.getComponentName(key);
        String remotePluginId = this.getRemotePluginId(key.getPluginId().getIdString(), key.getKey(), componentName);
        return RdSettingsStorageService.Companion.getEffectiveKey(key.getKey(), remotePluginId);
    }

    @Nullable
    public final LazySerializedValue get$intellij_platform_split(@NotNull SettingDescriptor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String effectiveKey = this.getRemoteEffectiveKey(key);
        return this.storage.get(effectiveKey);
    }

    public final boolean contains$intellij_platform_split(@NotNull SettingDescriptor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String effectiveKey = this.getRemoteEffectiveKey(key);
        return this.storage.containsKey(effectiveKey);
    }

    @Nullable
    public final LazySerializedValue put$intellij_platform_split(@NotNull SettingDescriptor<?> key, @NotNull LazySerializedValue value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String effectiveKey = this.getRemoteEffectiveKey(key);
        return this.storage.put(effectiveKey, value);
    }

    public final void putRemote$intellij_platform_split(@NotNull String effectiveKey, @NotNull LazySerializedValue value) {
        Intrinsics.checkNotNullParameter((Object)effectiveKey, (String)"effectiveKey");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.storage).put(effectiveKey, value);
    }

    public final void updatePluginIdMap$intellij_platform_split(@NotNull Map<String, String> newMap) {
        Intrinsics.checkNotNullParameter(newMap, (String)"newMap");
        this.pluginIdMap.set(newMap);
    }

    private static final String getRemotePluginId$lambda$0(String $localPluginId, String $key) {
        return "Can't replace pluginId because `componentName` is null for " + $localPluginId + "." + $key;
    }
}

