/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.externalProcessAuthHelper.SshPrompts;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.ssh.rsync.RsyncService;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RSyncUtil {
    private static final Logger LOG = Logger.getInstance(RSyncUtil.class);
    @NlsSafe
    public static final String RSYNC = "rsync";
    @NlsSafe
    public static final String SSH = "ssh";
    public static final String RSYNC_OPTIONS = "-zar";
    private static final String RSYNC_VERBOSE = "-v";
    private static final String RSYNC_SSH_PORT_OPTION = "-e";
    private static final String RSYNC_PORT_OPTION = "-p %s";
    private static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    private static final String RSYNC_SSH_OPTIONS = "%s %s %s";
    private static final String RSYNC_LOG_FILE_OPTION = "--log-file=%s";
    private static final String RSYNC_RELATIVE_OPTION = "-R";
    private static final String RSYNC_COPY_UNSAFE_LINKS_OPTION = "--copy-unsafe-links";
    private static final String RSYNC_COPY_LINKS_OPTION = "--copy-links";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Remote Transfer", (String)SshBundle.message((String)"notification.group.name", (Object[])new Object[0]));
    public static final String USE_RSYNC_REGISTRY_KEY = "ide.remote.interpreters.use.rsync";

    public static boolean checkRsyncInstalled() {
        return RsyncStatusService.getInstance().checkIfRSyncCommandExists();
    }

    public static boolean shouldInstallRSync() {
        if (!Registry.is((String)USE_RSYNC_REGISTRY_KEY)) {
            return false;
        }
        if (!PlatformUtils.isRubyMine()) {
            return false;
        }
        return !RSyncUtil.checkRsyncInstalled();
    }

    public static boolean canUseRSync() {
        if (!Registry.is((String)USE_RSYNC_REGISTRY_KEY) || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled();
    }

    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(0);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(1);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(3);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator));
    }

    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(4);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(5);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(6);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(7);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, true, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, boolean omitRemoteLastDirectoryNameIfNeeded, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(8);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(9);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(10);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(11);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, Collections.emptyList(), omitRemoteLastDirectoryNameIfNeeded, false, indicatorWrapper, true);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean omitRemoteLastDirectoryNameIfNeeded, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper, boolean verbose) throws ExecutionException {
        String remoteLastDirectoryName;
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(12);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(13);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(14);
        }
        if (excludeElements == null) {
            RSyncUtil.$$$reportNull$$$0(15);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(16);
        }
        if (omitRemoteLastDirectoryNameIfNeeded && (remoteLastDirectoryName = PathUtilRt.getFileName((String)remotePath)).equals(PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - remoteLastDirectoryName.length());
        }
        RSyncOptions rsyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withVerbose(verbose);
        RsyncCommandData data = RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, rsyncOptions, true);
        if (deleteFilesWithoutLocalPrototype) {
            data.parameters.add("--delete");
        }
        RSyncUtil.runAndListenBashCommand(data, indicatorWrapper, credentials);
    }

    @ApiStatus.Experimental
    public static void uploadInBatchWithRSync(@NotNull String sharedLocalPath, @NotNull String sharedRemotePath, @NotNull Collection<String> relativePaths, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (sharedLocalPath == null) {
            RSyncUtil.$$$reportNull$$$0(17);
        }
        if (sharedRemotePath == null) {
            RSyncUtil.$$$reportNull$$$0(18);
        }
        if (relativePaths == null) {
            RSyncUtil.$$$reportNull$$$0(19);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(20);
        }
        if (excludeElements == null) {
            RSyncUtil.$$$reportNull$$$0(21);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(22);
        }
        try (FilesFromOption filesFromOption = RSyncUtil.prepareFilesFromOption(sharedLocalPath, relativePaths);){
            RSyncOptions rsyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withVerbose(true).withFilesFrom(filesFromOption.getOptionValue());
            RsyncCommandData data = RSyncUtil.getRSyncCommandParameters(sharedLocalPath, sharedRemotePath, credentials, rsyncOptions, true);
            if (deleteFilesWithoutLocalPrototype) {
                data.parameters.add(data.parameters.size() - 2, "--delete");
            }
            RSyncUtil.runAndListenBashCommand(data, indicatorWrapper, credentials);
        }
        catch (IOException e) {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.rsync.failed.to.create.file.with.paths.to.upload", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @ApiStatus.Experimental
    public static void downloadInBatchWithRSync(@NotNull String sharedLocalPath, @NotNull String sharedRemotePath, @NotNull Collection<String> relativePaths, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (sharedLocalPath == null) {
            RSyncUtil.$$$reportNull$$$0(23);
        }
        if (sharedRemotePath == null) {
            RSyncUtil.$$$reportNull$$$0(24);
        }
        if (relativePaths == null) {
            RSyncUtil.$$$reportNull$$$0(25);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(26);
        }
        if (excludeElements == null) {
            RSyncUtil.$$$reportNull$$$0(27);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(28);
        }
        try (FilesFromOption filesFromParameter = RSyncUtil.prepareFilesFromOption(sharedLocalPath, relativePaths);){
            RSyncOptions rsyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withFilesFrom(filesFromParameter.getOptionValue()).withVerbose(true);
            RsyncCommandData data = RSyncUtil.getRSyncCommandParameters(sharedLocalPath, sharedRemotePath, credentials, rsyncOptions, false);
            if (deleteFilesWithoutLocalPrototype) {
                data.parameters.add(data.parameters.size() - 2, "--delete");
            }
            RSyncUtil.runAndListenBashCommand(data, indicatorWrapper, credentials);
        }
        catch (IOException e) {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.rsync.failed.to.create.file.with.paths.to.upload", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static void writePaths(@NotNull Collection<String> paths, @NotNull File file) throws ExecutionException {
        if (paths == null) {
            RSyncUtil.$$$reportNull$$$0(29);
        }
        if (file == null) {
            RSyncUtil.$$$reportNull$$$0(30);
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            boolean first = true;
            for (String path : paths) {
                if (first) {
                    first = false;
                } else {
                    ((OutputStream)stream).write("\n".getBytes(StandardCharsets.UTF_8));
                }
                ((OutputStream)stream).write(path.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            throw new ExecutionException(SshBundle.message((String)"dialog.message.rsync.failed.to.write.paths.to.upload.to.file", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static void testConnection(@NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(31);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(32);
        }
        String host = Ssh.wrapIPv6Address((String)credentials.getHost());
        String key = RSyncUtil.getKey(credentials);
        String port = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String sshOptions = String.format(RSYNC_SSH_OPTIONS, RsyncService.getInstance().getShellPath(), port, key);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-n");
        options.add(RSYNC_SSH_PORT_OPTION);
        options.add(sshOptions);
        options.add(String.format("%s@%s:%s", credentials.getUserName(), host, ""));
        RSyncUtil.runAndListenBashCommand(new RsyncCommandData(options, new File(".")), indicatorWrapper, credentials);
    }

    @NotNull
    private static String getKey(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(33);
        }
        return !StringUtil.isEmpty((String)credentials.getPrivateKeyFile()) ? String.format(RSYNC_PUBLIC_KEY_OPTION, credentials.getPrivateKeyFile()) : "";
    }

    public static boolean downloadFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(34);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(35);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(36);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(37);
        }
        if (options == null) {
            RSyncUtil.$$$reportNull$$$0(38);
        }
        if (!((String)remotePath).endsWith("/")) {
            remotePath = (String)remotePath + "/";
        }
        RsyncCommandData data = RSyncUtil.getRSyncCommandParameters(localPath, (String)remotePath, credentials, options, false);
        return RSyncUtil.runAndListenBashCommand(data, indicatorWrapper, credentials);
    }

    public static boolean downloadFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(39);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(40);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(41);
        }
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(42);
        }
        if (options == null) {
            RSyncUtil.$$$reportNull$$$0(43);
        }
        return RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator), options);
    }

    public static void downloadFileOrFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(44);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(45);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(46);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(47);
        }
        if (options == null) {
            RSyncUtil.$$$reportNull$$$0(48);
        }
        if (remotePath.endsWith("/")) {
            RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, indicatorWrapper, options);
            return;
        }
        RsyncCommandData data = RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, options, false);
        RSyncUtil.runAndListenBashCommand(data, indicatorWrapper, credentials);
    }

    public static void downloadFileOrFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(49);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(50);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(51);
        }
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(52);
        }
        RSyncUtil.downloadFileOrFolderWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator), new RSyncOptions().withVerbose(true));
    }

    public static void download(@NotNull List<? extends PathMappingSettings.PathMapping> pathMappings, @NotNull List<String> excludeElements, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (pathMappings == null) {
            RSyncUtil.$$$reportNull$$$0(53);
        }
        if (excludeElements == null) {
            RSyncUtil.$$$reportNull$$$0(54);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(55);
        }
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(56);
        }
        Notification notification = null;
        File logfile = null;
        try {
            logfile = FileUtil.createTempFile((String)"rsync_download", (String)".log");
            RSyncOptions rsyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withLogfilePath(logfile.getPath()).withCopyLinks(true).withVerbose(true);
            for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
                String localRoot = new File(pathMapping.getLocalRoot()).getParent() + "/";
                String remoteRoot = pathMapping.getRemoteRoot();
                RSyncUtil.downloadFileOrFolderWithRSync(localRoot, remoteRoot, credentials, RSyncUtil.wrap(progressIndicator), rsyncOptions);
            }
        }
        catch (IOException rsyncOptions) {
        }
        catch (SshRemoteHostIdentificationHasChangedException e) {
            String message = e.getMessage() + "\n" + SshBundle.message((String)"rsync.ssh.remote.host.identification.has.changed.message", (Object[])new Object[0]);
            notification = NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR);
        }
        if (notification == null) {
            notification = NOTIFICATION_GROUP.createNotification(SshBundle.message((String)"rsync.download.complete.title", (Object[])new Object[0]), NotificationType.INFORMATION);
            if (logfile != null) {
                final String logfilePath = logfile.getPath();
                LOG.debug(SshBundle.message((String)"rsync.download.complete.message", (Object[])new Object[]{logfilePath}));
                notification.addAction((AnAction)new DumbAwareAction(SshBundle.messagePointer((String)"action.Anonymous.text.log.file", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RevealFileAction.openFile((Path)Path.of(logfilePath, new String[0]));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/RSyncUtil$1", "actionPerformed"));
                    }
                });
            }
        }
        notification.notify(null);
    }

    private static boolean runAndListenBashCommand(@NotNull RsyncCommandData data, final @NotNull IndicatorWrapper indicatorWrapper, final @NotNull RemoteCredentials credentials) throws ExecutionException {
        String command;
        File executablePath;
        if (data == null) {
            RSyncUtil.$$$reportNull$$$0(57);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.$$$reportNull$$$0(58);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(59);
        }
        if (!(executablePath = new File(command = RSyncUtil.getRsyncCommand())).exists() && (executablePath = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)command)) == null) {
            throw new ExecutionException(SshBundle.message((String)"rsync.missing.command", (Object[])new Object[]{command}));
        }
        boolean consoleMode = SystemInfo.isWindows;
        PtyCommandLine commandLine = new PtyCommandLine().withConsoleMode(consoleMode);
        commandLine.setExePath(executablePath.getPath());
        commandLine.addParameters(data.parameters);
        commandLine.setWorkDirectory(data.workingDir);
        RSyncUtil.updateCommandLineIfWSL(commandLine, executablePath);
        LOG.debug("Running " + commandLine.getCommandLineString());
        final OSProcessHandler osProcessHandler = new OSProcessHandler((GeneralCommandLine)commandLine);
        final Ref hostIdentificationChanged = new Ref();
        final PrintWriter writer = new PrintWriter(osProcessHandler.getProcessInput(), false, StandardCharsets.UTF_8);
        osProcessHandler.addProcessListener(new ProcessListener(){
            private final AnsiEscapeDecoder myAnsiDecoder = new AnsiEscapeDecoder();
            private final AnsiEscapeDecoder.ColoredTextAcceptor myAcceptor = (text, attributes) -> {
                indicatorWrapper.addText(text, attributes);
                if (SshPrompts.PASSPHRASE_PROMPT.matcher(text).matches()) {
                    this.sendToTerminal(credentials.getPassphrase());
                } else if (text.toLowerCase(Locale.getDefault()).contains("remote host identification has changed")) {
                    hostIdentificationChanged.set((Object)true);
                    osProcessHandler.destroyProcess();
                } else if (RSyncUtil.isPasswordRequired(text)) {
                    String password = credentials.getPassword() != null ? credentials.getPassword() : credentials.getUserName();
                    this.sendToTerminal(password);
                } else if (text.contains("Are you sure you want to continue connecting")) {
                    this.sendToTerminal("yes");
                }
            };

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                try {
                    indicatorWrapper.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    osProcessHandler.destroyProcess();
                }
                String text = event.getText();
                if (text == null) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && !text.contains("No such file or directory")) {
                    LOG.info(text);
                }
                LOG.debug(outputType.toString(), new Object[]{": ", text});
                this.myAnsiDecoder.escapeText(text, outputType, this.myAcceptor);
            }

            private void sendToTerminal(String text) {
                writer.print(StringUtil.notNullize((String)text) + "\r");
                writer.flush();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                indicatorWrapper.finished(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ssh/RSyncUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        osProcessHandler.startNotify();
        while (!osProcessHandler.waitFor(200L)) {
            if (indicatorWrapper.isCanceled()) {
                osProcessHandler.destroyProcess();
            }
            indicatorWrapper.checkCanceled();
        }
        osProcessHandler.waitFor();
        if (!indicatorWrapper.isCanceled() && osProcessHandler.getExitCode() != null && osProcessHandler.getExitCode() != 0) {
            LOG.warn("RSync exited with code: " + osProcessHandler.getExitCode() + "\n\t" + commandLine.getCommandLineString());
        }
        if (hostIdentificationChanged.get() == Boolean.TRUE) {
            throw new SshRemoteHostIdentificationHasChangedException();
        }
        return osProcessHandler.getExitCode() != null && osProcessHandler.getExitCode() == 0;
    }

    public static IndicatorWrapper wrap(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RSyncUtil.$$$reportNull$$$0(60);
        }
        return new IndicatorWrapper(){

            @Override
            public boolean isCanceled() {
                return indicator.isCanceled();
            }

            @Override
            public void checkCanceled() throws ProcessCanceledException {
                indicator.checkCanceled();
            }

            @Override
            public void addText(@NotNull @Nls String text, @NotNull Key<?> key) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (key == ProcessOutputType.STDOUT && (text.contains("/") || text.contains("\\"))) {
                    indicator.setText(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$3";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static boolean isPasswordRequired(String text) {
        String prompt = text.trim().toLowerCase(Locale.getDefault());
        return prompt.startsWith("password for") || prompt.endsWith("password:");
    }

    @NotNull
    static String getRsyncCommand() {
        String string = RsyncService.getInstance().getRsyncPath();
        if (string == null) {
            RSyncUtil.$$$reportNull$$$0(61);
        }
        return string;
    }

    static RsyncCommandData getRSyncCommandParameters(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull RSyncOptions options, boolean isServerSideModification) {
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(62);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(63);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(64);
        }
        if (options == null) {
            RSyncUtil.$$$reportNull$$$0(65);
        }
        return RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, options, isServerSideModification, RsyncService.getInstance().getShellPath());
    }

    static RsyncCommandData getRSyncCommandParameters(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull RSyncOptions rSyncOptions, boolean isServerSideModification, String shellPath) {
        Object to;
        Object from;
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(66);
        }
        if (remotePath == null) {
            RSyncUtil.$$$reportNull$$$0(67);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(68);
        }
        if (rSyncOptions == null) {
            RSyncUtil.$$$reportNull$$$0(69);
        }
        remotePath = StringUtil.escapeChars((String)remotePath, (char[])new char[]{' ', '$'});
        Object localFileName = PathUtil.getFileName((String)localPath);
        if (localPath.endsWith("/") || localPath.endsWith("\\")) {
            localFileName = (String)localFileName + localPath.charAt(localPath.length() - 1);
        }
        String host = Ssh.wrapIPv6Address((String)credentials.getHost());
        String fullRemotePath = String.format("%s@%s:%s", credentials.getUserName(), host, remotePath);
        if (isServerSideModification) {
            from = localFileName;
            to = fullRemotePath;
        } else {
            from = fullRemotePath;
            to = localFileName;
        }
        String key = RSyncUtil.getKey(credentials);
        String port = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String sshOptions = String.format(RSYNC_SSH_OPTIONS, shellPath, port, key);
        ArrayList<String> options = new ArrayList<String>();
        String userOptions = RsyncService.getInstance().getOptions();
        if (userOptions.equals(RSYNC_OPTIONS)) {
            options.add(RSYNC_OPTIONS);
        } else {
            options.addAll(StringUtil.split((String)userOptions, (String)","));
        }
        if (rSyncOptions.getRelative()) {
            options.add(RSYNC_RELATIVE_OPTION);
        }
        if (rSyncOptions.getCopyUnsafeLinks()) {
            options.add(RSYNC_COPY_UNSAFE_LINKS_OPTION);
        }
        if (rSyncOptions.getCopyLinks()) {
            options.add(RSYNC_COPY_LINKS_OPTION);
        }
        if (rSyncOptions.getVerbose()) {
            options.add(RSYNC_VERBOSE);
        }
        options.add(RSYNC_SSH_PORT_OPTION);
        options.add(sshOptions);
        if (rSyncOptions.getLogfilePath() != null) {
            options.add(String.format(RSYNC_LOG_FILE_OPTION, rSyncOptions.getLogfilePath()));
        }
        if (rSyncOptions.getFilesFrom() != null) {
            options.add("--files-from=" + FileUtil.toSystemIndependentName((String)rSyncOptions.getFilesFrom()));
        }
        for (String element : rSyncOptions.getExcludeElements()) {
            options.add("--exclude=" + element);
        }
        options.add((String)from);
        options.add((String)to);
        return new RsyncCommandData(options, RSyncUtil.getWorkingDirectory(localPath));
    }

    @NotNull
    private static FilesFromOption prepareFilesFromOption(@NotNull String localPath, @NotNull Collection<String> relativePaths) throws ExecutionException, IOException {
        FilesFromOption result;
        if (localPath == null) {
            RSyncUtil.$$$reportNull$$$0(70);
        }
        if (relativePaths == null) {
            RSyncUtil.$$$reportNull$$$0(71);
        }
        if (SystemInfo.isWindows) {
            File wd = RSyncUtil.getWorkingDirectory(localPath);
            File file = FileUtil.createTempFile((File)wd, (String)"fileList", (String)".txt");
            result = new FilesFromOption(file, file.getName());
        } else {
            File file = FileUtil.createTempFile((String)"fileList", (String)".txt");
            result = new FilesFromOption(file, file.getPath());
        }
        RSyncUtil.writePaths(relativePaths, result.getFile());
        FilesFromOption filesFromOption = result;
        if (filesFromOption == null) {
            RSyncUtil.$$$reportNull$$$0(72);
        }
        return filesFromOption;
    }

    public static void updateCommandLineIfWSL(PtyCommandLine commandLine, File executablePath) throws ExecutionException {
        WSLDistribution wslDistribution;
        WslPath wslPath = WslPath.parseWindowsUncPath((String)executablePath.getPath());
        if (wslPath != null && (wslDistribution = WslPath.getDistributionByWindowsUncPath((String)executablePath.getPath())) != null) {
            commandLine.setExePath(RSyncUtil.updateCommandIfWSL(commandLine.getExePath(), wslDistribution));
            ParametersList parametersList = commandLine.getParametersList();
            List list = parametersList.getList();
            parametersList.clearAll();
            for (String parameter : list) {
                parametersList.add(RSyncUtil.updateCommandIfWSL(parameter, wslDistribution));
            }
            wslDistribution.patchCommandLine((GeneralCommandLine)commandLine, null, new WSLCommandLineOptions());
        }
    }

    @NotNull
    public static String updateCommandIfWSL(String path, WSLDistribution distribution) {
        String distributionWslPath = distribution.getWslPath(path);
        String string = distributionWslPath != null ? distributionWslPath : path;
        if (string == null) {
            RSyncUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull String path) {
        if (path == null) {
            RSyncUtil.$$$reportNull$$$0(74);
        }
        File wd = new File(path).getParentFile();
        FileUtil.createDirectory((File)wd);
        File file = wd;
        if (file == null) {
            RSyncUtil.$$$reportNull$$$0(75);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 61, 72, 73, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 26: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 46: 
            case 51: 
            case 55: 
            case 59: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: 
            case 42: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 22: 
            case 28: 
            case 32: 
            case 37: 
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorWrapper";
                break;
            }
            case 15: 
            case 21: 
            case 27: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeElements";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedLocalPath";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedRemotePath";
                break;
            }
            case 19: 
            case 25: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: 
            case 43: 
            case 48: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 61: 
            case 72: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSyncOptions";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRsyncCommand";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareFilesFromOption";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCommandIfWSL";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadWithRSync";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "uploadInBatchWithRSync";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "downloadInBatchWithRSync";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writePaths";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "downloadFolderWithRSync";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileOrFolderWithRSync";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runAndListenBashCommand";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 61: 
            case 72: 
            case 73: 
            case 75: {
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getRSyncCommandParameters";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "prepareFilesFromOption";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 61, 72, 73, 75 -> new IllegalStateException(string);
        };
    }

    public static interface IndicatorWrapper {
        public boolean isCanceled();

        public void checkCanceled() throws ProcessCanceledException;

        public void addText(@NotNull @Nls String var1, @NotNull Key<?> var2);

        default public void finished(int exitCode) {
        }
    }

    static class RsyncCommandData {
        @NotNull
        public final List<String> parameters;
        @NotNull
        public final File workingDir;

        private RsyncCommandData(@NotNull List<String> parameters, @NotNull File workingDir) {
            if (parameters == null) {
                RsyncCommandData.$$$reportNull$$$0(0);
            }
            if (workingDir == null) {
                RsyncCommandData.$$$reportNull$$$0(1);
            }
            this.parameters = parameters;
            this.workingDir = workingDir;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ssh/RSyncUtil$RsyncCommandData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilesFromOption
    implements Closeable {
        @NotNull
        private final File myFile;
        @NotNull
        private final String myOptionValue;

        private FilesFromOption(@NotNull File file, @NotNull String optionValue) {
            if (file == null) {
                FilesFromOption.$$$reportNull$$$0(0);
            }
            if (optionValue == null) {
                FilesFromOption.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myOptionValue = optionValue;
        }

        @NotNull
        private File getFile() {
            File file = this.myFile;
            if (file == null) {
                FilesFromOption.$$$reportNull$$$0(2);
            }
            return file;
        }

        @NotNull
        private String getOptionValue() {
            String string = this.myOptionValue;
            if (string == null) {
                FilesFromOption.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void close() {
            FileUtil.delete((File)this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/RSyncUtil$FilesFromOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/RSyncUtil$FilesFromOption";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

