/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.sftpBrowser;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ui.sftpBrowser.RemoteBrowser;
import com.intellij.ssh.ui.sftpBrowser.RemoteBrowserProvider;
import com.intellij.ssh.ui.sftpBrowser.RemoteBrowserTreeModel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\tJ\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowser;", "Ljavax/swing/JTree;", "connectionProvider", "Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowserProvider;", "foldersOnly", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "pathToExpand", "", "border", "Ljavax/swing/border/Border;", "<init>", "(Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowserProvider;ZLcom/intellij/openapi/Disposable;Ljava/lang/String;Ljavax/swing/border/Border;)V", "getFoldersOnly", "()Z", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "myModel", "Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowserTreeModel;", "getMyModel", "()Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowserTreeModel;", "myCellRenderer", "Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowser$Companion$NodeRenderer;", "getFullPath", "asNodes", "", "Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowserTreeModel$Companion$Node;", "Ljavax/swing/tree/TreePath;", "createDirectory", "", "name", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleTreeExpansion", "Companion", "intellij.platform.ssh.ui"})
@SourceDebugExtension(value={"SMAP\nRemoteBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteBrowser.kt\ncom/intellij/ssh/ui/sftpBrowser/RemoteBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,267:1\n1#2:268\n11705#3:269\n12052#3,3:270\n23#4:273\n37#5,2:274\n*S KotlinDebug\n*F\n+ 1 RemoteBrowser.kt\ncom/intellij/ssh/ui/sftpBrowser/RemoteBrowser\n*L\n68#1:269\n68#1:270,3\n100#1:273\n112#1:274,2\n*E\n"})
public class RemoteBrowser
extends JTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteBrowserProvider connectionProvider;
    private final boolean foldersOnly;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final RemoteBrowserTreeModel myModel;
    @NotNull
    private final Companion.NodeRenderer myCellRenderer;

    public RemoteBrowser(@NotNull RemoteBrowserProvider connectionProvider, boolean foldersOnly, @NotNull Disposable parentDisposable, @Nullable String pathToExpand, @Nullable Border border) {
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.connectionProvider = connectionProvider;
        this.foldersOnly = foldersOnly;
        this.parentDisposable = parentDisposable;
        this.myModel = new RemoteBrowserTreeModel(this.connectionProvider, this.parentDisposable, this.foldersOnly);
        this.myCellRenderer = new Companion.NodeRenderer();
        this.editable = false;
        if (border != null) {
            this.setBorder(border);
        }
        this.setRootVisible(this.connectionProvider.isRootVisible());
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setModel((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myModel), true, this.parentDisposable));
        if (pathToExpand != null) {
            this.scheduleTreeExpansion(pathToExpand);
        }
        this.setCellRenderer((TreeCellRenderer)((Object)this.myCellRenderer));
    }

    public /* synthetic */ RemoteBrowser(RemoteBrowserProvider remoteBrowserProvider, boolean bl, Disposable disposable, String string, Border border, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            border = null;
        }
        this(remoteBrowserProvider, bl, disposable, string, border);
    }

    public final boolean getFoldersOnly() {
        return this.foldersOnly;
    }

    @NotNull
    public final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    public final RemoteBrowserTreeModel getMyModel() {
        return this.myModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getFullPath() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) return "";
        TreePath it = treePath;
        boolean bl = false;
        String string = this.connectionProvider.pathToString(this.asNodes(it));
        if (string == null) return "";
        String string2 = string;
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RemoteBrowserTreeModel.Companion.Node> asNodes(TreePath $this$asNodes) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = $this$asNodes.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RemoteBrowserTreeModel.Companion.Node node = it instanceof RemoteBrowserTreeModel.Companion.Node ? (RemoteBrowserTreeModel.Companion.Node)it : null;
            if (node == null) {
                throw new IllegalStateException(("Expected RemoteBrowserTreeModel.Node but found " + it.getClass().getName()).toString());
            }
            collection.add(node);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createDirectory(@NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createDirectory.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteBrowser this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createDirectory(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getSelectionPath();
                if (v0 == null) {
                    var5_6 = "Required value was null.";
                    throw new IllegalArgumentException(var5_6.toString());
                }
                selectionPathBeforeCreation = v0;
                $continuation.L$0 = name;
                $continuation.L$1 = selectionPathBeforeCreation;
                $continuation.label = 1;
                v1 = this.connectionProvider.newDirectory(this.asNodes(selectionPathBeforeCreation), name, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var9_5) goto lbl25
lbl24:
                // 1 sources

                return var9_5;
lbl25:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                selectionPathBeforeCreation = (TreePath)$continuation.L$1;
                name = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if (!((lastPathComponent = selectionPathBeforeCreation.getLastPathComponent()) instanceof RemoteBrowserTreeModel.Companion.Node)) ** GOTO lbl64
                ((RemoteBrowserTreeModel.Companion.Node)lastPathComponent).clearCachedData();
                this.myModel.reload(selectionPathBeforeCreation);
                if (!this.isExpanded(selectionPathBeforeCreation)) ** GOTO lbl64
                $continuation.L$0 = name;
                $continuation.L$1 = selectionPathBeforeCreation;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)lastPathComponent);
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lastPathComponent, selectionPathBeforeCreation, name, null){
                    int label;
                    final /* synthetic */ RemoteBrowser this$0;
                    final /* synthetic */ Object $lastPathComponent;
                    final /* synthetic */ TreePath $selectionPathBeforeCreation;
                    final /* synthetic */ String $name;
                    {
                        this.this$0 = $receiver;
                        this.$lastPathComponent = $lastPathComponent;
                        this.$selectionPathBeforeCreation = $selectionPathBeforeCreation;
                        this.$name = $name;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                ListenerUiUtil.onceWhenTreeChanged$default((JTree)this.this$0, null, arg_0 -> createDirectory.2.invokeSuspend$lambda$0(this.this$0, this.$lastPathComponent, this.$selectionPathBeforeCreation, this.$name, arg_0), (int)1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final Unit invokeSuspend$lambda$0(RemoteBrowser this$0, Object $lastPathComponent, TreePath $selectionPathBeforeCreation, String $name, TreeModelEvent it) {
                        Object createdChild;
                        block3: {
                            Object v0;
                            void $this$firstOrNull$iv;
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv;
                            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this$0.getModel().getChildCount($lastPathComponent));
                            boolean $i$f$map = false;
                            Iterator<T> iterator = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                void idx;
                                int item$iv$iv;
                                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(this$0.getModel().getChild($lastPathComponent, (int)idx));
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$firstOrNull = false;
                            iterator = $this$firstOrNull$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv;
                                T node = element$iv = iterator.next();
                                boolean bl = false;
                                if (!(node instanceof RemoteBrowserTreeModel.Companion.Node && Intrinsics.areEqual((Object)((RemoteBrowserTreeModel.Companion.Node)node).getState().getName(), (Object)$name))) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = createdChild = null;
                        }
                        if (createdChild != null && Intrinsics.areEqual((Object)this$0.getSelectionPath(), (Object)$selectionPathBeforeCreation)) {
                            this$0.setSelectionPath($selectionPathBeforeCreation.pathByAddingChild(createdChild));
                            this$0.scrollPathToVisible(this$0.getSelectionPath());
                        }
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var9_5) goto lbl44
lbl43:
                // 1 sources

                return var9_5;
lbl44:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                lastPathComponent = $continuation.L$2;
                selectionPathBeforeCreation = (TreePath)$continuation.L$1;
                name = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (Throwable t) {
                    if (this.connectionProvider.isUnexpectedException(t)) {
                        throw t;
                    }
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v3 = Logger.getInstance(RemoteBrowser.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                    v3.warn("Failed to create directory '" + name + "' in  " + this.connectionProvider.pathToString(this.asNodes(selectionPathBeforeCreation)), t);
                    var5_7 = new Object[]{name, this.connectionProvider.pathToString(this.asNodes(selectionPathBeforeCreation))};
                    Messages.showWarningDialog((String)t.getLocalizedMessage(), (String)SshBundle.message((String)"failed.to.create.directory", (Object[])var5_7));
                }
lbl64:
                // 5 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void scheduleTreeExpansion(String pathToExpand) {
        List<String> pathElemsToExpand = this.connectionProvider.pathStringToNames(pathToExpand);
        Collection $this$toTypedArray$iv = pathElemsToExpand;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        TreePath treePath = TreePathUtil.convertArrayToTreePath((Object[])Arrays.copyOf(stringArray, stringArray.length));
        TreeUtil.promiseExpand((JTree)this, (TreeVisitor)((TreeVisitor)new TreeVisitor.ByTreePath(true, treePath, RemoteBrowser::scheduleTreeExpansion$lambda$0)));
    }

    private static final String scheduleTreeExpansion$lambda$0(Object node) {
        Object object = node instanceof RemoteBrowserTreeModel.Companion.Node ? (RemoteBrowserTreeModel.Companion.Node)node : null;
        return object != null && (object = ((RemoteBrowserTreeModel.Companion.Node)object).getState()) != null ? object.getName() : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowser$Companion;", "", "<init>", "()V", "NodeRenderer", "intellij.platform.ssh.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ssh/ui/sftpBrowser/RemoteBrowser$Companion$NodeRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.ssh.ui"})
        private static final class NodeRenderer
        extends ColoredTreeCellRenderer {
            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Object object = value;
                if (object instanceof LoadingNode) {
                    this.setIcon(null);
                    SimpleColoredComponent simpleColoredComponent = this.append(LoadingNode.Companion.getText());
                    Intrinsics.checkNotNull((Object)simpleColoredComponent);
                } else if (object instanceof RemoteBrowserTreeModel.Companion.Node) {
                    if (((RemoteBrowserTreeModel.Companion.Node)value).getState().getNameOverride() != null) {
                        String string = ((RemoteBrowserTreeModel.Companion.Node)value).getState().getNameOverride();
                        Intrinsics.checkNotNull((Object)string);
                        v1 = this.append(string);
                    } else {
                        v1 = this.append(((RemoteBrowserTreeModel.Companion.Node)value).getState().getName());
                    }
                    if (((RemoteBrowserTreeModel.Companion.Node)value).getState().permissionDenied()) {
                        this.append(SshBundle.message((String)"sftpBrowser.permissionDenied", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                        this.setIcon(AllIcons.FileTypes.Unknown);
                    } else if (((RemoteBrowserTreeModel.Companion.Node)value).getState().failedToLoad()) {
                        this.append(SshBundle.message((String)"sftpBrowser.failedToLoad", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                        this.setIcon(AllIcons.FileTypes.Unknown);
                    } else if (((RemoteBrowserTreeModel.Companion.Node)value).getState().isDir()) {
                        this.setIcon(AllIcons.Nodes.Folder);
                    } else {
                        this.setIcon(AllIcons.FileTypes.Any_type);
                    }
                } else {
                    throw new IllegalStateException("value is not an RemoteBrowserTreeModel.Node".toString());
                }
            }
        }
    }
}

