/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.SshCredentialsEditorBase;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class SshCredentialsEditorEx
extends SshCredentialsEditorBase<MutableRemoteCredentials> {
    private static final Logger LOG = Logger.getInstance(SshCredentialsEditorEx.class);

    public SshCredentialsEditorEx(@NotNull Disposable parent) {
        if (parent == null) {
            SshCredentialsEditorEx.$$$reportNull$$$0(0);
        }
        super(true, false, parent);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SshUiData uiData = new SshUiData(new SshConfig(true), false);
                SshCredentialsEditorEx.this.applyEditorTo(uiData);
                ErrorMessageAndField validate = SshCredentialsEditorEx.validate(uiData, SshCredentialsVerifier.ValidationMode.WITHOUT_STRICT_CREDENTIALS);
                if (validate != null) {
                    Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message((String)"ssh.editor.invalid.setting.0", (Object[])new Object[]{StringUtil.decapitalize((String)validate.errorMessage())}), (String)SshBundle.message((String)"ssh.editor.message.title.unable.to.connect", (Object[])new Object[0]));
                    return;
                }
                AtomicBoolean success = new AtomicBoolean(false);
                Ref exceptionRef = new Ref(null);
                Runnable runnable = () -> {
                    ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                    Semaphore done = new Semaphore();
                    done.down();
                    EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            pi.setText(IdeCoreBundle.message((String)"progress.message.connecting.to", (Object[])new Object[]{uiData.getConfig().getPresentableFullName()}));
                            success.set(RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)uiData, null).withDisconnectTrigger(forceDisconnectDispatcher).withProgressIndicator(pi).withConnectionTimeout(10L, TimeUnit.SECONDS).checkCanAuthenticate(true));
                        }
                        catch (SshException e) {
                            LOG.warn((Throwable)e);
                            exceptionRef.set((Object)e);
                            success.set(false);
                        }
                        finally {
                            done.up();
                        }
                    });
                    while (!done.waitFor(10000L)) {
                        if (!pi.isCanceled()) continue;
                        ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                        break;
                    }
                };
                String title = SshBundle.message((String)"ssh.editor.title.connection.to.0", (Object[])new Object[]{uiData.getConfig().getPresentableFullName()});
                boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, SshCredentialsEditorEx.this.getComponent());
                if (!complete) {
                    throw new ProcessCanceledException();
                }
                if (success.get()) {
                    Messages.showInfoMessage((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message((String)"ssh.editor.successfully.connected", (Object[])new Object[0]), (String)title);
                } else {
                    String message;
                    String string = message = !exceptionRef.isNull() ? SshConnectionUtil.getMessage((Throwable)((Throwable)exceptionRef.get()), (boolean)false) : null;
                    if (message == null) {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message((String)"ssh.editor.can.t.connect.to.remote.host", (Object[])new Object[0]), (String)title);
                    } else {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message((String)"ssh.editor.can.t.connect.to.remote.host.0", (Object[])new Object[]{message}), (String)title);
                    }
                }
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SshCredentialsEditorEx.this.updateNeedsPassphrase();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$2", "textChanged"));
            }
        });
    }

    @Override
    public void resetEditorFrom(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.$$$reportNull$$$0(1);
        }
        super.resetEditorFrom(credentials);
        this.updateNeedsPassphrase();
    }

    @Override
    public boolean isModified(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.$$$reportNull$$$0(2);
        }
        return super.isModified(credentials);
    }

    public void addListenerForNameDefiningFields(final @NotNull Runnable updater) {
        if (updater == null) {
            SshCredentialsEditorEx.$$$reportNull$$$0(3);
        }
        DocumentAdapter documentAdapter = new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                updater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$3", "textChanged"));
            }
        };
        this.myUsernameField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                updater.run();
            }
        });
    }

    @NotNull
    private static ErrorMessageAndField wrapTimeout(TimeoutException e) {
        Object message = SshBundle.message((String)"ssh.verifier.message.connection.timeout", (Object[])new Object[0]);
        if (e.getMessage() != null) {
            message = (String)message + ":" + e.getMessage();
        }
        return new ErrorMessageAndField((String)message, null);
    }

    public static ErrorMessageAndField validate(SshUiData data, SshCredentialsVerifier.ValidationMode mode) {
        try {
            return SshCredentialsVerifier.validate((SshCredentialsVerifier.ValidationMode)mode, (RemoteCredentials)data, (long)500L, (SshBackendLibrary)SshBackendLibrary.get());
        }
        catch (TimeoutException e) {
            return SshCredentialsEditorEx.wrapTimeout(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/ui/unified/SshCredentialsEditorEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListenerForNameDefiningFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

