/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.execution.process.UnixSignal;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.SshjSshChannel;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.transport.TransportException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J(\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjExecChannel;", "Lcom/intellij/ssh/channels/ExecChannel;", "Lcom/intellij/ssh/impl/sshj/channels/SshjSshChannel;", "sshConnection", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "command", "Lnet/schmizz/sshj/connection/channel/direct/Session$Command;", "hasPty", "", "<init>", "(Lcom/intellij/ssh/impl/sshj/SshjSshConnection;Lnet/schmizz/sshj/connection/channel/direct/Session$Command;Z)V", "getHasPty", "()Z", "failedToTerminate", "exitStatus", "", "getExitStatus", "()I", "getErrorStream", "Ljava/io/InputStream;", "terminate", "", "force", "setPtySize", "col", "row", "wp", "hp", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjExecChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjExecChannel.kt\ncom/intellij/ssh/impl/sshj/channels/SshjExecChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class SshjExecChannel
extends SshjSshChannel
implements ExecChannel {
    @NotNull
    private final Session.Command command;
    private final boolean hasPty;
    private volatile boolean failedToTerminate;

    public SshjExecChannel(@NotNull SshjSshConnection sshConnection, @NotNull Session.Command command, boolean hasPty) {
        Intrinsics.checkNotNullParameter((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        super(sshConnection, (Channel)command);
        this.command = command;
        this.hasPty = hasPty;
    }

    @Override
    public boolean getHasPty() {
        return this.hasPty;
    }

    @Override
    public int getExitStatus() {
        Integer n = this.command.getExitStatus();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        n = this.command.getExitSignal();
        if (n != null) {
            Integer it = n;
            boolean bl = false;
            UnixSignal unixSignal = UnixSignal.Companion.fromString(it.name());
            return unixSignal != null ? unixSignal.asExitCode(false) : 127;
        }
        if (this.failedToTerminate) {
            return UnixSignal.SIGKILL.asExitCode(false);
        }
        return -1;
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        InputStream inputStream2 = this.command.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        return inputStream2;
    }

    @Override
    public void terminate(boolean force) {
        Signal signalToSend = force ? Signal.KILL : Signal.TERM;
        UtilKt.getSSHJ_LOG().debug("Sending SIG" + signalToSend + " for command `" + this.command + "` inside " + this);
        try {
            this.command.signal(signalToSend);
        }
        catch (TransportException ignored) {
            this.failedToTerminate = true;
        }
    }

    @Override
    public void setPtySize(int col, int row, int wp, int hp) {
        block0: {
            Session.Command command = this.command;
            SessionChannel sessionChannel = command instanceof SessionChannel ? (SessionChannel)command : null;
            if (sessionChannel == null) break block0;
            sessionChannel.changeWindowDimensions(col, row, wp, hp);
        }
    }
}

