/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DigestUtil;
import com.sun.security.auth.module.UnixSystem;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00130\u0012J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService;", "", "<init>", "()V", "kind", "Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "getKind", "()Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "customOpenSshExecutable", "", "getCustomOpenSshExecutable", "()Ljava/lang/String;", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "useOpenSshConfig", "", "modifiers", "", "Lkotlin/Function1;", "substituteConfig", "source", "initialHostName", "Kind", "Substitutor", "Delegate", "Modifier", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/SshConnectionConfigService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,317:1\n42#2,3:318\n18#3:321\n1#4:322\n1586#5:323\n1661#5,3:324\n60#6,5:327\n13#6:332\n*S KotlinDebug\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/SshConnectionConfigService\n*L\n52#1:318,3\n88#1:321\n96#1:323\n96#1:324,3\n122#1:327,5\n211#1:332\n*E\n"})
public final class SshConnectionConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final Kind getKind() {
        return (Kind)AdvancedSettings.Companion.getEnum("ssh.config.backend", Kind.class);
    }

    @NotNull
    public final String getCustomOpenSshExecutable() {
        return AdvancedSettings.Companion.getString("ssh.tool.custom.path");
    }

    @NotNull
    public final SshConnectionConfig get(@NotNull String host, boolean useOpenSshConfig, @NotNull List<? extends Function1<? super SshConnectionConfig, SshConnectionConfig>> modifiers) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        boolean $i$f$service = false;
        Class<Delegate> serviceClass$iv = Delegate.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Delegate delegate = (Delegate)object;
        SshConnectionConfig connectionConfig = delegate.get(host, useOpenSshConfig);
        Iterator<Object> iterator = Modifier.Companion.getEP_NAME().getExtensionList().iterator();
        while (iterator.hasNext()) {
            SshConnectionConfig previousConfig = connectionConfig;
            Modifier modifier = (Modifier)iterator.next();
            String diff = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(previousConfig, connectionConfig = modifier.modify(host, connectionConfig)), (CharSequence)"\n", null, null, (int)0, null, SshConnectionConfigService::get$lambda$0, (int)30, null);
            LOG.debug(((CharSequence)diff).length() > 0 ? "SSH connection configuration was modified by " + modifier + ":\n" + diff : "SSH connection configuration wasn't modified by " + modifier);
        }
        for (Function1 function1 : modifiers) {
            connectionConfig = (SshConnectionConfig)function1.invoke((Object)connectionConfig);
        }
        if (useOpenSshConfig) {
            connectionConfig = this.substituteConfig(connectionConfig, host);
        }
        return connectionConfig;
    }

    /*
     * Unable to fully structure code
     */
    private final SshConnectionConfig substituteConfig(SshConnectionConfig source, String initialHostName) {
        substitutor = new Substitutor(source, initialHostName);
        substitutedHost = substitutor.substitute(Substitutor.What.HOST, source.getHost());
        $this$asSafely$iv = source.getProxyConfig();
        $i$f$asSafely = false;
        v0 = $this$asSafely$iv;
        if (!(v0 instanceof SshProxyConfig.Command)) {
            v0 = null;
        }
        if ((var6_9 = (SshProxyConfig.Command)v0) == null || ($this$asSafely$iv = var6_9.getCommand()) == null) ** GOTO lbl-1000
        proxyCommandStr = $this$asSafely$iv;
        $i$a$-let-SshConnectionConfigService$substituteConfig$substitutedProxy$1 = false;
        $i$f$asSafely = substitutor.substitute(Substitutor.What.PROXY, (String)proxyCommandStr);
        if ($i$f$asSafely != null) {
            p0 = $i$f$asSafely;
            $i$a$-let-SshConnectionConfigService$substituteConfig$substitutedProxy$2 = false;
            v1 = new SshProxyConfig.Command(p0);
        } else lbl-1000:
        // 2 sources

        {
            v1 = source.getProxyConfig();
        }
        substitutedProxy = v1;
        $this$substituteConfig_u24lambda_u241 = this;
        $i$a$-run-SshConnectionConfigService$substituteConfig$substitutedAuthMethods$1 = false;
        v2 = SshConnectionConfigKt.findPublicKeyWithIndex(source.getAuthMethods());
        if (v2 == null) {
            v3 = source.getAuthMethods();
        } else {
            proxyCommandStr = v2;
            index = ((Number)proxyCommandStr.component1()).intValue();
            publicKey = (AuthMethod.PublicKey)proxyCommandStr.component2();
            $this$map$iv = publicKey.getPrivateKeys();
            $i$f$map = false;
            var15_25 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var20_30 = (Path)item$iv$iv;
                var21_31 = destination$iv$iv;
                $i$a$-map-SshConnectionConfigService$substituteConfig$substitutedAuthMethods$1$newPrivateKeys$1 = false;
                var21_31.add(Path.of(OSAgnosticPathUtil.expandUserHome((String)substitutor.substitute(Substitutor.What.IDENTITY_FILE, path.toString())), new String[0]));
            }
            newPrivateKeys = (List)destination$iv$iv;
            result = CollectionsKt.toMutableList((Collection)source.getAuthMethods());
            result.set(index, AuthMethod.PublicKey.copy$default(publicKey, newPrivateKeys, null, 2, null));
            v3 = AuthMethods.Companion.create(result);
        }
        substitutedAuthMethods = v3;
        $this$substituteConfig_u24lambda_u242 = this;
        $i$a$-run-SshConnectionConfigService$substituteConfig$substitutedIdentityAgent$1 = false;
        v4 = identityAgent = source.getIdentityAgent();
        if ((v4 != null ? v4.getType() : null) == IdentityAgent.Type.PATH) {
            v5 = OSAgnosticPathUtil.expandUserHome((String)substitutor.substitute(Substitutor.What.IDENTITY_AGENT, identityAgent.getArgument()));
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"expandUserHome(...)");
            v6 = new IdentityAgent(IdentityAgent.Type.PATH, v5);
        } else {
            v6 = identityAgent;
        }
        substitutedIdentityAgent = v6;
        substitutedConfig = SshConnectionConfig.copy$default(source, substitutedAuthMethods, null, false, null, false, null, substitutedHost, null, null, substitutedIdentityAgent, null, null, null, null, 0, substitutedProxy, null, null, null, 490942, null);
        diff = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(source, substitutedConfig), (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, substituteConfig$lambda$3(kotlin.Triple ), (Lkotlin/Triple;)Ljava/lang/CharSequence;)(), (int)30, null);
        $this$debug_u24default$iv = SshConnectionConfigService.LOG;
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            var24_34 = $this$debug_u24default$iv;
            $i$a$-debug$default-SshConnectionConfigService$substituteConfig$1 = false;
            var24_34.debug(((CharSequence)diff).length() > 0 != false ? "Change after replacing %-tokens for host " + source.getHost() + ":\n" + diff : "No changes after replacing %-tokens for host " + source.getHost() + ".", t$iv);
        }
        return substitutedConfig;
    }

    private static final CharSequence get$lambda$0(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String key = (String)triple.component1();
        Object oldValue = triple.component2();
        Object newValue = triple.component3();
        return "  " + key + ": " + oldValue + "\n" + StringsKt.repeat((CharSequence)" ", (int)(key.length() + 1)) + "-> " + newValue;
    }

    private static final CharSequence substituteConfig$lambda$3(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String key = (String)triple.component1();
        Object oldValue = triple.component2();
        Object newValue = triple.component3();
        return "  " + key + ": " + oldValue + "\n" + StringsKt.repeat((CharSequence)" ", (int)(key.length() + 1)) + "-> " + newValue;
    }

    @JvmStatic
    @NotNull
    public static final SshConnectionConfigService getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionConfigService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ssh/config/SshConnectionConfigService;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/SshConnectionConfigService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,317:1\n42#2,3:318\n*S KotlinDebug\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/SshConnectionConfigService$Companion\n*L\n214#1:318,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SshConnectionConfigService getInstance() {
            boolean $i$f$service = false;
            Class<SshConnectionConfigService> serviceClass$iv = SshConnectionConfigService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SshConnectionConfigService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Delegate;", "", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "useOpenSshConfig", "", "intellij.platform.ssh"})
    public static interface Delegate {
        @NotNull
        public SshConnectionConfig get(@NotNull String var1, boolean var2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "LEGACY", "OPENSSH", "intellij.platform.ssh"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind LEGACY = new LEGACY("LEGACY", 0);
        public static final /* enum */ Kind OPENSSH = new OPENSSH("OPENSSH", 1);
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind() {
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Kind(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.LEGACY, Kind.OPENSSH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Kind.LEGACY", "Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "toString", "", "intellij.platform.ssh"})
        static final class LEGACY
        extends Kind {
            /*
             * WARNING - void declaration
             */
            LEGACY() {
                void var1_1;
            }

            @NotNull
            public String toString() {
                String string = SshBundle.message("ssh.config.parser.kind.legacy", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Kind.OPENSSH", "Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "toString", "", "intellij.platform.ssh"})
        static final class OPENSSH
        extends Kind {
            /*
             * WARNING - void declaration
             */
            OPENSSH() {
                void var1_1;
            }

            @NotNull
            public String toString() {
                String string = SshBundle.message("ssh.config.parser.kind.openssh", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Modifier;", "", "modify", "Lcom/intellij/ssh/config/SshConnectionConfig;", "initialHost", "", "connectionConfig", "Companion", "intellij.platform.ssh"})
    public static interface Modifier {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public SshConnectionConfig modify(@NotNull String var1, @NotNull SshConnectionConfig var2);

        @NotNull
        public static ExtensionPointName<Modifier> getEP_NAME() {
            return Companion.getEP_NAME();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Modifier$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ssh/config/SshConnectionConfigService$Modifier;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.ssh"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ExtensionPointName<Modifier> EP_NAME;

            private Companion() {
            }

            @NotNull
            public final ExtensionPointName<Modifier> getEP_NAME() {
                return EP_NAME;
            }

            @JvmStatic
            public static /* synthetic */ void getEP_NAME$annotations() {
            }

            static {
                $$INSTANCE = new Companion();
                EP_NAME = ExtensionPointName.Companion.create("com.intellij.ssh.config.sshConnectionConfigService.modifier");
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor;", "", "source", "Lcom/intellij/ssh/config/SshConnectionConfig;", "initialHostName", "", "<init>", "(Lcom/intellij/ssh/config/SshConnectionConfig;Ljava/lang/String;)V", "substitutedHost", "substitute", "what", "Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "str", "What", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/SshConnectionConfigService$Substitutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
    private static final class Substitutor {
        @NotNull
        private final SshConnectionConfig source;
        @NotNull
        private final String initialHostName;
        @NotNull
        private String substitutedHost;

        public Substitutor(@NotNull SshConnectionConfig source, @NotNull String initialHostName) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)initialHostName, (String)"initialHostName");
            this.source = source;
            this.substitutedHost = this.initialHostName = initialHostName;
        }

        @NotNull
        public final String substitute(@NotNull What what, @NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)((Object)what), (String)"what");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CharSequence charSequence = str;
            Regex regex = new Regex("%.");
            Function1 function1 = arg_0 -> Substitutor.substitute$lambda$0(this, what, arg_0);
            String result = regex.replace(charSequence, function1);
            if (what == What.HOST) {
                this.substitutedHost = result;
            }
            return result;
        }

        private static final CharSequence substitute$lambda$0(Substitutor this$0, What $what, MatchResult match) {
            CharSequence charSequence;
            Character c;
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            Character c2 = Character.valueOf(StringsKt.last((CharSequence)match.getValue()));
            char token = c2.charValue();
            boolean bl = false;
            Character c3 = c = StringsKt.contains$default((CharSequence)$what.getSupported(), (char)token, (boolean)false, (int)2, null) ? c2 : null;
            char c4 = '%';
            if (c3 != null && c3.charValue() == c4) {
                charSequence = "%";
            } else {
                Character c5 = c;
                c4 = 'C';
                if (c5 != null && c5.charValue() == c4) {
                    MessageDigest messageDigest;
                    MessageDigest digest = messageDigest = DigestUtil.sha1();
                    boolean bl2 = false;
                    String string = InetAddress.getLocalHost().getHostName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
                    digest.update(StringsKt.encodeToByteArray((String)string));
                    digest.update(StringsKt.encodeToByteArray((String)this$0.substitutedHost));
                    digest.update(StringsKt.encodeToByteArray((String)String.valueOf(this$0.source.getPort())));
                    digest.update(StringsKt.encodeToByteArray((String)this$0.source.getUser()));
                    charSequence = DigestUtil.digestToHash((MessageDigest)messageDigest);
                } else {
                    Character c6 = c;
                    c4 = 'L';
                    if (c6 != null && c6.charValue() == c4) {
                        String string = InetAddress.getLocalHost().getCanonicalHostName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalHostName(...)");
                        charSequence = string;
                    } else {
                        Character c7 = c;
                        c4 = 'd';
                        if (c7 != null && c7.charValue() == c4) {
                            String string = SystemProperties.getUserHome();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                            charSequence = string;
                        } else {
                            Character c8 = c;
                            c4 = 'h';
                            if (c8 != null && c8.charValue() == c4) {
                                charSequence = this$0.substitutedHost;
                            } else {
                                Character c9 = c;
                                c4 = 'k';
                                if (c9 != null && c9.charValue() == c4) {
                                    charSequence = this$0.substitutedHost;
                                } else {
                                    Character c10 = c;
                                    c4 = 'l';
                                    if (c10 != null && c10.charValue() == c4) {
                                        String string = InetAddress.getLocalHost().getHostName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
                                        charSequence = string;
                                    } else {
                                        Character c11 = c;
                                        c4 = 'n';
                                        if (c11 != null && c11.charValue() == c4) {
                                            charSequence = this$0.initialHostName;
                                        } else {
                                            Character c12 = c;
                                            c4 = 'p';
                                            if (c12 != null && c12.charValue() == c4) {
                                                charSequence = String.valueOf(this$0.source.getPort());
                                            } else {
                                                Character c13 = c;
                                                c4 = 'r';
                                                if (c13 != null && c13.charValue() == c4) {
                                                    charSequence = this$0.source.getUser();
                                                } else {
                                                    Character c14 = c;
                                                    c4 = 'u';
                                                    if (c14 != null && c14.charValue() == c4) {
                                                        String string = SystemProperties.getUserName();
                                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserName(...)");
                                                        charSequence = string;
                                                    } else {
                                                        Character c15 = c;
                                                        c4 = 'i';
                                                        if (c15 != null && c15.charValue() == c4) {
                                                            charSequence = SystemInfo.isWindows ? "1" : String.valueOf(new UnixSystem().getUid());
                                                        } else {
                                                            UtilKt.getSSHJ_LOG().warn("Incorrect token " + match.getValue() + " in " + $what + " " + this$0.source.getProxyConfig() + ". OpenSSH would exit with an error, but the IDE will keep the token as is.");
                                                            charSequence = match.getValue();
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return charSequence;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "", "supported", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSupported", "()Ljava/lang/String;", "HOST", "PROXY", "IDENTITY_FILE", "IDENTITY_AGENT", "intellij.platform.ssh"})
        public static final class What
        extends Enum<What> {
            @NotNull
            private final String supported;
            public static final /* enum */ What HOST = new HOST("HOST", 0);
            public static final /* enum */ What PROXY = new PROXY("PROXY", 1);
            public static final /* enum */ What IDENTITY_FILE = new IDENTITY_FILE("IDENTITY_FILE", 2);
            public static final /* enum */ What IDENTITY_AGENT = new IDENTITY_AGENT("IDENTITY_AGENT", 3);
            private static final /* synthetic */ What[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private What(String supported) {
                this.supported = supported;
            }

            @NotNull
            public final String getSupported() {
                return this.supported;
            }

            public static What[] values() {
                return (What[])$VALUES.clone();
            }

            public static What valueOf(String value) {
                return Enum.valueOf(What.class, value);
            }

            @NotNull
            public static EnumEntries<What> getEntries() {
                return $ENTRIES;
            }

            public /* synthetic */ What(String $enum$name, int $enum$ordinal, String supported, DefaultConstructorMarker $constructor_marker) {
                this(supported);
            }

            static {
                $VALUES = whatArray = new What[]{What.HOST, What.PROXY, What.IDENTITY_FILE, What.IDENTITY_AGENT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Substitutor.What.HOST", "Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "toString", "", "intellij.platform.ssh"})
            static final class HOST
            extends What {
                /*
                 * WARNING - void declaration
                 */
                HOST() {
                    void var1_1;
                }

                @NotNull
                public String toString() {
                    return "host name";
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Substitutor.What.IDENTITY_AGENT", "Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "toString", "", "intellij.platform.ssh"})
            static final class IDENTITY_AGENT
            extends What {
                /*
                 * WARNING - void declaration
                 */
                IDENTITY_AGENT() {
                    void var1_1;
                }

                @NotNull
                public String toString() {
                    return "identity agent";
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Substitutor.What.IDENTITY_FILE", "Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "toString", "", "intellij.platform.ssh"})
            static final class IDENTITY_FILE
            extends What {
                /*
                 * WARNING - void declaration
                 */
                IDENTITY_FILE() {
                    void var1_1;
                }

                @NotNull
                public String toString() {
                    return "identity file";
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u00020\u0003H\u0096\u0080\u0004\u00a8\u0006\u0004"}, d2={"com/intellij/ssh/config/SshConnectionConfigService.Substitutor.What.PROXY", "Lcom/intellij/ssh/config/SshConnectionConfigService$Substitutor$What;", "toString", "", "intellij.platform.ssh"})
            static final class PROXY
            extends What {
                /*
                 * WARNING - void declaration
                 */
                PROXY() {
                    void var1_1;
                }

                @NotNull
                public String toString() {
                    return "proxy command";
                }
            }
        }
    }
}

