/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.ChannelInputStream;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/PatchedExecChannel;", "Lnet/schmizz/sshj/connection/channel/direct/SessionChannel;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "<init>", "(Lnet/schmizz/sshj/SSHClient;)V", "redirectingStderr", "", "getRedirectingStderr$intellij_platform_ssh", "()Z", "setRedirectingStderr$intellij_platform_ssh", "(Z)V", "gotExtendedData", "", "buf", "Lnet/schmizz/sshj/common/SSHPacket;", "receiveInto", "stream", "Lnet/schmizz/sshj/connection/channel/ChannelInputStream;", "sendAgentForwardingRequest", "intellij.platform.ssh"})
public final class PatchedExecChannel
extends SessionChannel {
    private boolean redirectingStderr;

    public PatchedExecChannel(@NotNull SSHClient sshClient) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        super(sshClient.getConnection(), sshClient.getRemoteCharset());
    }

    public final boolean getRedirectingStderr$intellij_platform_ssh() {
        return this.redirectingStderr;
    }

    public final void setRedirectingStderr$intellij_platform_ssh(boolean bl) {
        this.redirectingStderr = bl;
    }

    protected void gotExtendedData(@NotNull SSHPacket buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        InputStream inputStream2 = this.redirectingStderr ? this.getInputStream() : this.getErrorStream();
        Intrinsics.checkNotNull((Object)inputStream2, (String)"null cannot be cast to non-null type net.schmizz.sshj.connection.channel.ChannelInputStream");
        ChannelInputStream destination = (ChannelInputStream)inputStream2;
        try {
            int dataTypeCode = buf.readUInt32AsInt();
            if (dataTypeCode != 1) {
                throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Bad extended data type = " + dataTypeCode);
            }
            this.receiveInto(destination, buf);
        }
        catch (Buffer.BufferException bufferException) {
            throw new ConnectionException((Throwable)bufferException);
        }
    }

    protected void receiveInto(@Nullable ChannelInputStream stream, @Nullable SSHPacket buf) {
        block2: {
            try {
                super.receiveInto(stream, buf);
            }
            catch (ConnectionException e) {
                if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Getting data on EOF'ed stream")) break block2;
                throw e;
            }
        }
    }

    public final void sendAgentForwardingRequest() {
        this.sendChannelRequest("auth-agent-req@openssh.com", false, new Buffer.PlainBuffer());
    }
}

