/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ssh.SshTunnelListener;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.tunnels.LocalTunnelServer;
import com.intellij.ssh.impl.sshj.tunnels.SingleTunnelBrokerKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.transport.Transport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ssh/impl/sshj/tunnels/LocalTunnelServer;", "", "conn", "Lnet/schmizz/sshj/connection/Connection;", "params", "Lnet/schmizz/sshj/connection/channel/direct/Parameters;", "serverSocket", "Ljava/net/ServerSocket;", "ownerName", "", "<init>", "(Lnet/schmizz/sshj/connection/Connection;Lnet/schmizz/sshj/connection/channel/direct/Parameters;Ljava/net/ServerSocket;Ljava/lang/String;)V", "getParams", "()Lnet/schmizz/sshj/connection/channel/direct/Parameters;", "activeLocalTunnels", "Ljava/util/ArrayList;", "Ljava/lang/Thread;", "Lkotlin/collections/ArrayList;", "serverSocketLogName", "thread", "serve", "", "start", "stop", "await", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nLocalForwarderCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalTunnelServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1#2:271\n1915#3,2:272\n1915#3,2:274\n*S KotlinDebug\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalTunnelServer\n*L\n256#1:272,2\n258#1:274,2\n*E\n"})
final class LocalTunnelServer {
    @NotNull
    private final Connection conn;
    @NotNull
    private final Parameters params;
    @NotNull
    private final ServerSocket serverSocket;
    @NotNull
    private final String ownerName;
    @NotNull
    private final ArrayList<Thread> activeLocalTunnels;
    @NotNull
    private final String serverSocketLogName;
    @NotNull
    private final Thread thread;

    /*
     * WARNING - void declaration
     */
    public LocalTunnelServer(@NotNull Connection conn, @NotNull Parameters params, @NotNull ServerSocket serverSocket, @NotNull String ownerName) {
        void $this$thread_u24lambda_u241;
        Thread thread;
        Thread $this$serverSocketLogName_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this.conn = conn;
        this.params = params;
        this.serverSocket = serverSocket;
        this.ownerName = ownerName;
        this.activeLocalTunnels = new ArrayList();
        Parameters parameters = this.params;
        LocalTunnelServer localTunnelServer = this;
        boolean bl = false;
        localTunnelServer.serverSocketLogName = "for " + this.ownerName + ": Local " + $this$serverSocketLogName_u24lambda_u240.getLocalHost() + ":" + $this$serverSocketLogName_u24lambda_u240.getLocalPort() + " ==> Remote " + $this$serverSocketLogName_u24lambda_u240.getRemoteHost() + ":" + $this$serverSocketLogName_u24lambda_u240.getRemotePort();
        $this$serverSocketLogName_u24lambda_u240 = thread = new Thread(() -> LocalTunnelServer.thread$lambda$0(this));
        localTunnelServer = this;
        boolean bl2 = false;
        $this$thread_u24lambda_u241.setDaemon(true);
        $this$thread_u24lambda_u241.setName("SSHJ local tunnel server " + this.serverSocketLogName);
        $this$thread_u24lambda_u241.setUncaughtExceptionHandler(SingleTunnelBrokerKt.getThreadSocketExceptionHandler());
        localTunnelServer.thread = thread;
    }

    @NotNull
    public final Parameters getParams() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void serve() {
        boolean $i$f$forEach;
        try {
            while (!this.thread.isInterrupted() && !this.serverSocket.isClosed()) {
                Object threadName;
                Closeable channel2;
                Socket socket;
                try {
                    socket = this.serverSocket.accept();
                    Intrinsics.checkNotNull((Object)socket);
                }
                catch (SocketException e) {
                    if (this.thread.isInterrupted() && this.serverSocket.isClosed()) return;
                    UtilKt.getSSHJ_LOG().warn("Error from " + this.thread.getName() + " while accepting new local tunnel connection", (Throwable)e);
                    return;
                }
                Socket socket2 = socket;
                try {
                    Thread thread;
                    Iterator<Thread> iterator;
                    Parameters $this$serve_u24lambda_u240 = this.params;
                    boolean $i$a$-with-LocalTunnelServer$serve$socketLogName$22 = false;
                    String socketLogName = "for " + this.ownerName + ": Local client " + socket2.getRemoteSocketAddress() + " ==> Local server " + $this$serve_u24lambda_u240.getLocalHost() + ":" + $this$serve_u24lambda_u240.getLocalPort() + " ==> Remote server " + $this$serve_u24lambda_u240.getRemoteHost() + ":" + $this$serve_u24lambda_u240.getRemotePort();
                    UtilKt.getSSHJ_LOG().debug("Got connection in " + socketLogName);
                    Intrinsics.checkNotNullExpressionValue(this.activeLocalTunnels.iterator(), (String)"iterator(...)");
                    while (iterator.hasNext()) {
                        if (iterator.next().isAlive()) continue;
                        iterator.remove();
                    }
                    Connection $i$a$-with-LocalTunnelServer$serve$socketLogName$22 = this.conn;
                    channel2 = new AbstractDirectChannel(this, $i$a$-with-LocalTunnelServer$serve$socketLogName$22){
                        final /* synthetic */ LocalTunnelServer this$0;
                        {
                            this.this$0 = $receiver;
                            super($super_call_param$1, "direct-tcpip");
                        }

                        protected SSHPacket buildOpenReq() {
                            Buffer buffer = ((SSHPacket)((SSHPacket)((SSHPacket)super.buildOpenReq().putString(this.this$0.getParams().getRemoteHost())).putUInt32((long)this.this$0.getParams().getRemotePort())).putString(this.this$0.getParams().getLocalHost())).putUInt32((long)this.this$0.getParams().getLocalPort());
                            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"putUInt32(...)");
                            return (SSHPacket)buffer;
                        }
                    };
                    threadName = "SSHJ local tunnel " + socketLogName;
                    Thread tunnel = new Thread(() -> LocalTunnelServer.serve$lambda$1((String)threadName, this, socket2, (Object)channel2));
                    this.activeLocalTunnels.add(tunnel);
                    Thread $this$serve_u24lambda_u242 = thread = tunnel;
                    boolean bl = false;
                    $this$serve_u24lambda_u242.setDaemon(true);
                    $this$serve_u24lambda_u242.setName((String)threadName);
                    $this$serve_u24lambda_u242.setUncaughtExceptionHandler((arg_0, arg_1) -> LocalTunnelServer.serve$lambda$2$0(this, arg_0, arg_1));
                    $this$serve_u24lambda_u242.start();
                }
                catch (Exception e2) {
                    channel2 = socket2;
                    threadName = null;
                    try {
                        try {
                            Socket it = (Socket)channel2;
                            boolean bl = false;
                            throw e2;
                        }
                        catch (Throwable bl) {
                            threadName = bl;
                            throw bl;
                        }
                    }
                    catch (Throwable bl) {
                        CloseableKt.closeFinally((Closeable)channel2, (Throwable)threadName);
                        throw bl;
                        return;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            boolean bl = $i$f$forEach = !this.thread.isInterrupted();
            if (!_Assertions.ENABLED || $i$f$forEach) return;
            String e2 = "Assertion failed";
            throw new AssertionError((Object)e2);
        }
        finally {
            Thread it;
            try {
                this.serverSocket.close();
            }
            catch (SocketException e) {
                UtilKt.getSSHJ_LOG().warn("Error from " + this.thread.getName() + " while was closing " + this.serverSocket, (Throwable)e);
            }
            Iterable $this$forEach$iv = this.activeLocalTunnels;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Thread)element$iv;
                boolean bl = false;
                it.interrupt();
            }
            try {
                $this$forEach$iv = this.activeLocalTunnels;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Thread)element$iv;
                    boolean bl = false;
                    it.join();
                }
            }
            catch (InterruptedException interruptedException) {}
            UtilKt.getSSHJ_LOG().debug("Finished " + this.thread.getName());
        }
    }

    public final void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Closeable closeable = this.serverSocket;
        Throwable throwable = null;
        try {
            ServerSocket it = (ServerSocket)closeable;
            boolean bl = false;
            this.thread.interrupt();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void await() {
        this.thread.join();
    }

    private static final void thread$lambda$0(LocalTunnelServer this$0) {
        this$0.serve();
    }

    private static final Socket serve$lambda$1$0(Socket $socket) {
        return $socket;
    }

    private static final Channel serve$lambda$1$1(serve.channel.1 $channel) {
        serve.channel.1 var1_1;
        serve.channel.1 $this$serve_u24lambda_u241_u241_u240 = var1_1 = $channel;
        boolean bl = false;
        $this$serve_u24lambda_u241_u241_u240.open();
        return (Channel)var1_1;
    }

    private static final void serve$lambda$2$0(LocalTunnelServer this$0, Thread thread, Throwable th) {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<SshTunnelListener> topic = SshTunnelListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((SshTunnelListener)messageBus.syncPublisher(topic)).onError(this$0.params.getLocalPort(), th);
        SingleTunnelBrokerKt.getThreadSocketExceptionHandler().uncaughtException(thread, th);
    }

    private static final void serve$lambda$1(String $threadName, LocalTunnelServer this$0, Socket $socket, serve.channel.1 $channel) {
        Transport transport = this$0.conn.getTransport();
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"getTransport(...)");
        SingleTunnelBrokerKt.singleTunnelBroker$default($threadName, transport, () -> LocalTunnelServer.serve$lambda$1$0($socket), () -> LocalTunnelServer.serve$lambda$1$1($channel), 0, 16, null);
    }
}

