/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ValidKeyPair;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshCredentialsVerifier {
    private static final Logger LOG = Logger.getInstance(SshCredentialsVerifier.class);
    public static final int SLOW_VALIDATION_TIMEOUT_MS = Math.max(10, Integer.getInteger("com.jetbrains.ssh.validation.timeout.ms", 400));

    private SshCredentialsVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField verify(boolean checkSsh, @NonNls String accessTypeName, boolean fast, long msTimeout, boolean checkUserName, String host, int port, String username, AuthType authType, String privateKeyFile, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        ErrorMessageAndField withoutAuth;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(0);
        }
        if ((withoutAuth = SshCredentialsVerifier.validateWithoutAuth(accessTypeName, host, port)) != null) {
            return withoutAuth;
        }
        if (checkUserName && StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        if (checkSsh && authType == AuthType.KEY_PAIR) {
            if (StringUtil.isEmpty((String)privateKeyFile)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE");
            }
            if (!fast) {
                void backendLibrary;
                return (ErrorMessageAndField)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.lambda$verify$0(privateKeyFile, (SshBackendLibrary)backendLibrary));
            }
        }
        return null;
    }

    @Nullable
    public static ErrorMessageAndField validateWithoutAuth(@NonNls String accessTypeName, String host, int port) {
        URI uri;
        if (StringUtil.isEmpty((String)host)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.empty", accessTypeName), "HOST");
        }
        String patchedHost = host.replaceAll("_", "a");
        if (!patchedHost.startsWith("[")) {
            uri = SshCredentialsVerifier.tryURI(patchedHost);
            if (uri == null || uri.getScheme() == null) {
                uri = SshCredentialsVerifier.tryURI("ftp://" + patchedHost);
            }
        } else {
            uri = SshCredentialsVerifier.tryURI("ftp://" + patchedHost);
            if (uri == null || uri.getScheme() == null) {
                uri = SshCredentialsVerifier.tryURI(patchedHost);
            }
        }
        if (uri == null || uri.getHost() == null) {
            if (host.contains(":")) {
                boolean ipv6 = true;
                for (int i = 0; i < host.length(); ++i) {
                    char ch = host.charAt(i);
                    if (ch >= '0' && ch <= '9' || ch == ':' || ch == '[' || ch == ']') continue;
                    ipv6 = false;
                    break;
                }
                if (ipv6) {
                    return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.ip6", accessTypeName), "HOST");
                }
            }
            if (!SshCredentialsVerifier.isAsciiPrintable(host)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.type", accessTypeName), "HOST");
            }
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid", accessTypeName), "HOST");
        }
        if (port <= 0) {
            return new ErrorMessageAndField(SshBundle.message("credentials.port.is.invalid", accessTypeName), "PORT");
        }
        return null;
    }

    private static boolean isAsciiPrintable(@Nullable String cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            char ch = cs.charAt(i);
            if (ch >= ' ' && ch < '\u007f') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validate(ValidationMode mode, RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        ErrorMessageAndField validation;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(1);
        }
        if ((validation = SshCredentialsVerifier.validateWithoutAuth("SSH", credentials.getHost(), credentials.getPort())) != null) {
            return validation;
        }
        return SshCredentialsVerifier.validateAuthDataProvided(mode, credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(2);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (authType == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(3);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(4);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(ValidationMode.FULL, username, authType, password, keyPath, passphrase, msTimeout, (SshBackendLibrary)backendLibrary);
    }

    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(ValidationMode mode, String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        if (authType == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(5);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        return switch (authType) {
            default -> throw new MatchException(null, null);
            case AuthType.OPEN_SSH -> null;
            case AuthType.PASSWORD -> {
                if (mode == ValidationMode.FULL && StringUtil.isEmpty((String)password)) {
                    yield new ErrorMessageAndField(SshBundle.message("credentials.password.is.not.specified", new Object[0]), "PASSWORD");
                }
                yield null;
            }
            case AuthType.KEY_PAIR -> {
                void backendLibrary;
                yield mode == ValidationMode.FULL && StringUtil.isEmpty((String)keyPath) ? new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE") : (mode == ValidationMode.WITHOUT_SLOW_KEY_CHECKS ? null : (ErrorMessageAndField)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.lambda$validateAuthDataProvided$1(keyPath, (SshBackendLibrary)backendLibrary, passphrase)));
            }
        };
    }

    @Nullable
    private static ErrorMessageAndField doSshSlowCheck(String privateKeyFile, @NotNull SshBackendLibrary backendLibrary) {
        File privateKey;
        if (backendLibrary == null) {
            SshCredentialsVerifier.$$$reportNull$$$0(7);
        }
        if (!(privateKey = new File(privateKeyFile)).isFile() || !privateKey.canRead()) {
            return new ErrorMessageAndField(SshBundle.message("credentials.private.key.file.not.found", privateKeyFile), "PRIVATE_KEY_FILE");
        }
        AnalyzeKeyPairResult checkResult = Ssh.analyzeKeyPair(privateKey, backendLibrary);
        if (checkResult instanceof ValidKeyPair) {
            return null;
        }
        String message = ((InvalidKeyPair)checkResult).getErrorMessage();
        if (message != null) {
            return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair.massage", privateKeyFile, message), "PRIVATE_KEY_FILE");
        }
        return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair", privateKeyFile), "PRIVATE_KEY_FILE");
    }

    private static URI tryURI(@NonNls String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.info("Invalid URI " + uri + ": " + e.getMessage());
            return null;
        }
    }

    public static <T> T runWithTimeout(long timeout, Computable<T> computable) throws TimeoutException {
        if (timeout <= 0L) {
            return (T)computable.compute();
        }
        Ref result = new Ref();
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                result.set(computable.compute());
            }
            finally {
                s.up();
            }
        });
        if (!s.waitFor(timeout)) {
            throw new TimeoutException();
        }
        return (T)result.get();
    }

    @Nullable
    public static ValidationInfo wrapValidation(@NotNull ThrowableComputable<@Nls String, ? extends TimeoutException> validate) {
        Object validation;
        block4: {
            if (validate == null) {
                SshCredentialsVerifier.$$$reportNull$$$0(8);
            }
            try {
                validation = (String)validate.compute();
            }
            catch (TimeoutException e) {
                validation = SshBundle.message("ssh.verifier.message.connection.timeout", new Object[0]);
                if (e.getMessage() == null) break block4;
                validation = (String)validation + ":" + e.getMessage();
            }
        }
        if (validation != null) {
            return new ValidationInfo((String)validation);
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField lambda$validateAuthDataProvided$1(String keyPath, SshBackendLibrary backendLibrary, String passphrase) {
        boolean required;
        ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.doSshSlowCheck(keyPath, backendLibrary);
        if (errorMessageAndField != null) {
            return errorMessageAndField;
        }
        if (StringUtil.isEmpty((String)passphrase) && (required = Ssh.isPassphraseMayBeRequired(keyPath, backendLibrary))) {
            return new ErrorMessageAndField(SshBundle.message("credentials.provided.private.key.requires.a.passphrase", new Object[0]), "PASSPHRASE");
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField lambda$verify$0(String privateKeyFile, SshBackendLibrary backendLibrary) {
        return SshCredentialsVerifier.doSshSlowCheck(privateKeyFile, backendLibrary);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendLibrary";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshCredentialsVerifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "verify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAuthDataProvided";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doSshSlowCheck";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapValidation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ValidationMode {
        WITHOUT_SLOW_KEY_CHECKS,
        WITHOUT_STRICT_CREDENTIALS,
        FULL;

    }
}

