/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.ValidKeyPair;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.SftpChannelKt;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.impl.sshj.AnalyzeKeyPairPassphraseRequested;
import com.intellij.ssh.impl.sshj.KeyCheckingSshClientConfig;
import com.intellij.ssh.impl.sshj.channels.JschAgentProxyBuffer;
import com.intellij.ssh.impl.sshj.channels.JschAgentProxyBufferKt;
import com.intellij.util.EnvironmentUtil;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001aA\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aM\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u00122\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n\u001a\u001c\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\fH\u0002\u001a\u0017\u0010\u0019\u001a\u00020\n\"\u0004\b\u0000\u0010\b*\u0002H\bH\u0000\u00a2\u0006\u0002\u0010\u001a\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0007\u001a \u0010)\u001a\u00020\n*\u00020*2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020,H\u0007\u001a\u0018\u0010.\u001a\b\u0012\u0004\u0012\u0002000/*\b\u0012\u0004\u0012\u0002010/H\u0000\u001a\u0018\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0007\u001a \u00105\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010/2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\fH\u0007\"\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u001c\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00068\u00b2\u0006R\u00109\u001aJ\u0012\f\u0012\n &*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n &*\u0004\u0018\u00010\n0\n &*#\u0012\f\u0012\n &*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n &*\u0004\u0018\u00010\n0\n0<\u00a2\u0006\u0002\b;0:\u00a2\u0006\u0002\b;X\u008a\u0084\u0002"}, d2={"forwardOneQuery", "", "Lcom/jcraft/jsch/agentproxy/Connector;", "inputStream", "Ljava/io/DataInputStream;", "outputStream", "Ljava/io/DataOutputStream;", "wrapSshjSftpException", "T", "file", "", "logNoSuchFileError", "", "log", "block", "Lkotlin/Function0;", "(Ljava/lang/String;ZZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "msgCreator", "Lkotlin/Function1;", "Ljava/io/IOException;", "(Lkotlin/jvm/functions/Function1;ZZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createDirectories", "Lcom/intellij/ssh/channels/SftpChannel;", "path", "handleNotExisting", "hexId", "(Ljava/lang/Object;)Ljava/lang/String;", "SSHJ_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getSSHJ_LOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "analyzeKeyPairSshj", "Lcom/intellij/ssh/AnalyzeKeyPairResult;", "privateKeyFile", "Ljava/io/File;", "posixBasename", "utf8ReplacingDecoder", "Ljava/nio/charset/CharsetDecoder;", "kotlin.jvm.PlatformType", "getUtf8ReplacingDecoder", "()Ljava/nio/charset/CharsetDecoder;", "escapeLikeStrace", "", "offset", "", "length", "certainVariables", "", "Lcom/intellij/ssh/config/EnvironmentVariable$Certain;", "Lcom/intellij/ssh/config/EnvironmentVariable;", "matchPattern", "s", "pattern", "argvSplit", "source", "terminateOnComment", "intellij.platform.ssh", "systemEnvVars", "", "Lorg/jetbrains/annotations/NotNull;", ""})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n45#1,31:417\n1#2:448\n1586#3:449\n1661#3,3:450\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n*L\n42#1:417,31\n243#1:449\n243#1:450,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Logger SSHJ_LOG;
    private static final CharsetDecoder utf8ReplacingDecoder;

    public static final void forwardOneQuery(@NotNull Connector $this$forwardOneQuery, @NotNull DataInputStream inputStream2, @NotNull DataOutputStream outputStream2) {
        JschAgentProxyBuffer jschAgentProxyBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$forwardOneQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream2, (String)"outputStream");
        try {
            jschAgentProxyBuffer = JschAgentProxyBufferKt.query($this$forwardOneQuery, inputStream2);
        }
        catch (AgentProxyException e) {
            JschAgentProxyBufferKt.writeErrorResponse(outputStream2);
            throw e;
        }
        JschAgentProxyBuffer buffer = jschAgentProxyBuffer;
        JschAgentProxyBufferKt.writeTo(buffer, outputStream2);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T wrapSshjSftpException(@NotNull String file, boolean logNoSuchFileError, boolean log, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError;
        boolean log$iv = log;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            object = block.invoke();
        }
        catch (SFTPException e$iv) {
            IOException it = (IOException)((Object)e$iv);
            boolean bl2 = false;
            String message$iv = "File " + file + ": " + it.getMessage();
            if (log$iv) {
                Response.StatusCode statusCode = e$iv.getStatusCode();
                switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                        }
                        UtilKt.getSSHJ_LOG().info(message$iv);
                        break;
                    }
                    case 2: {
                        void logNoSuchFileError$iv;
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                        }
                        if (logNoSuchFileError$iv == false) break;
                        UtilKt.getSSHJ_LOG().warn(message$iv);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
                    }
                }
            }
            throw SftpChannelException.Companion.create(e$iv.getStatusCode().getCode(), message$iv, e$iv);
        }
        catch (IOException e$iv) {
            IOException it = e$iv;
            boolean bl3 = false;
            String message$iv = "File " + file + ": " + it.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
            throw SftpChannelException.Companion.create(-1, message$iv, e$iv);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object wrapSshjSftpException$default(String file, boolean logNoSuchFileError, boolean log, Function0 block, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            logNoSuchFileError = true;
        }
        if ((n & 4) != 0) {
            log = true;
        }
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError;
        boolean log$iv = log;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            object2 = block.invoke();
        }
        catch (SFTPException e$iv) {
            IOException it = (IOException)((Object)e$iv);
            boolean bl2 = false;
            String message$iv = "File " + file + ": " + it.getMessage();
            if (log$iv) {
                Response.StatusCode statusCode = e$iv.getStatusCode();
                switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                        }
                        UtilKt.getSSHJ_LOG().info(message$iv);
                        break;
                    }
                    case 2: {
                        void logNoSuchFileError$iv;
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                        }
                        if (logNoSuchFileError$iv == false) break;
                        UtilKt.getSSHJ_LOG().warn(message$iv);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
                    }
                }
            }
            throw SftpChannelException.Companion.create(e$iv.getStatusCode().getCode(), message$iv, e$iv);
        }
        catch (IOException e$iv) {
            IOException it = e$iv;
            boolean bl3 = false;
            String message$iv = "File " + file + ": " + it.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
            throw SftpChannelException.Companion.create(-1, message$iv, e$iv);
        }
        return object2;
    }

    public static final <T> T wrapSshjSftpException(@NotNull Function1<? super IOException, String> msgCreator, boolean logNoSuchFileError, boolean log, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(msgCreator, (String)"msgCreator");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$wrapSshjSftpException = false;
        try {
            object = block.invoke();
        }
        catch (SFTPException e) {
            String message = (String)msgCreator.invoke((Object)e);
            if (log) {
                Response.StatusCode statusCode = e.getStatusCode();
                switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message, (Throwable)e);
                        }
                        UtilKt.getSSHJ_LOG().info(message);
                        break;
                    }
                    case 2: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message, (Throwable)e);
                        }
                        if (!logNoSuchFileError) break;
                        UtilKt.getSSHJ_LOG().warn(message);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn(message, (Throwable)e);
                    }
                }
            }
            throw SftpChannelException.Companion.create(e.getStatusCode().getCode(), message, e);
        }
        catch (IOException e) {
            String message = (String)msgCreator.invoke((Object)e);
            UtilKt.getSSHJ_LOG().warn(message, (Throwable)e);
            throw SftpChannelException.Companion.create(-1, message, e);
        }
        return (T)object;
    }

    public static /* synthetic */ Object wrapSshjSftpException$default(Function1 msgCreator, boolean logNoSuchFileError, boolean log, Function0 block, int n, Object object) {
        if ((n & 2) != 0) {
            logNoSuchFileError = true;
        }
        if ((n & 4) != 0) {
            log = true;
        }
        Intrinsics.checkNotNullParameter((Object)msgCreator, (String)"msgCreator");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$wrapSshjSftpException = false;
        try {
            object = block.invoke();
        }
        catch (SFTPException e) {
            String message = (String)msgCreator.invoke((Object)e);
            if (log) {
                Response.StatusCode statusCode = e.getStatusCode();
                switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message, (Throwable)e);
                        }
                        UtilKt.getSSHJ_LOG().info(message);
                        break;
                    }
                    case 2: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message, (Throwable)e);
                        }
                        if (!logNoSuchFileError) break;
                        UtilKt.getSSHJ_LOG().warn(message);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn(message, (Throwable)e);
                    }
                }
            }
            throw SftpChannelException.Companion.create(e.getStatusCode().getCode(), message, e);
        }
        catch (IOException e) {
            String message = (String)msgCreator.invoke((Object)e);
            UtilKt.getSSHJ_LOG().warn(message, (Throwable)e);
            throw SftpChannelException.Companion.create(-1, message, e);
        }
        return object;
    }

    public static final void createDirectories(@NotNull SftpChannel $this$createDirectories, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectories, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        UtilKt.createDirectories($this$createDirectories, path, true);
    }

    private static final void createDirectories(SftpChannel $this$createDirectories, String path, boolean handleNotExisting) {
        block6: {
            try {
                $this$createDirectories.mkdir(path);
            }
            catch (SftpChannelException err) {
                int n = err.getCode();
                if (n == Response.StatusCode.NO_SUCH_FILE.getCode()) {
                    if (handleNotExisting) {
                        UtilKt.createDirectories($this$createDirectories, StringsKt.substringBeforeLast$default((String)path, (char)'/', null, (int)2, null), true);
                        UtilKt.createDirectories($this$createDirectories, path, false);
                    }
                    throw err;
                }
                if (n == Response.StatusCode.FILE_ALREADY_EXISTS.getCode()) break block6;
                if (n == Response.StatusCode.FAILURE.getCode()) {
                    if (!SftpChannelKt.isDir($this$createDirectories.stat(path))) {
                        throw err;
                    }
                }
                throw err;
            }
        }
    }

    @NotNull
    public static final <T> String hexId(T $this$hexId) {
        String string = Integer.toHexString(System.identityHashCode($this$hexId));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    @NotNull
    public static final Logger getSSHJ_LOG() {
        return SSHJ_LOG;
    }

    @NotNull
    public static final AnalyzeKeyPairResult analyzeKeyPairSshj(@NotNull File privateKeyFile) throws IOException {
        AnalyzeKeyPairResult analyzeKeyPairResult;
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        try {
            KeyProvider keyProvider2 = new SSHClient((Config)new KeyCheckingSshClientConfig()).loadKeys(privateKeyFile.getPath(), new PasswordFinder(){

                public char[] reqPassword(Resource<?> resource) {
                    throw new AnalyzeKeyPairPassphraseRequested();
                }

                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            });
            keyProvider2.getPrivate();
            analyzeKeyPairResult = new ValidKeyPair(false);
        }
        catch (AnalyzeKeyPairPassphraseRequested ignored) {
            analyzeKeyPairResult = new ValidKeyPair(true);
        }
        catch (IOException e) {
            String string;
            if (privateKeyFile.canRead()) {
                String string2 = e.getMessage();
                if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl = false;
                    string = ((CharSequence)it).length() > 0 ? string3 : null;
                } else {
                    string = null;
                }
            } else {
                throw e;
            }
            String string4 = string;
            analyzeKeyPairResult = new InvalidKeyPair(string4);
        }
        catch (SSHRuntimeException e) {
            String string;
            String string5 = e.getMessage();
            if (string5 != null && (string5 = ((Object)StringsKt.trim((CharSequence)string5)).toString()) != null) {
                String string6;
                String it = string6 = string5;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string6 : null;
            } else {
                string = null;
            }
            String string7 = string;
            analyzeKeyPairResult = new InvalidKeyPair(string7);
        }
        catch (UnsupportedOperationException err) {
            analyzeKeyPairResult = new InvalidKeyPair(err.getMessage());
        }
        return analyzeKeyPairResult;
    }

    @VisibleForTesting
    @NotNull
    public static final String posixBasename(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String $this$posixBasename_u24lambda_u240 = path;
        boolean bl = false;
        if (StringsKt.endsWith$default((CharSequence)$this$posixBasename_u24lambda_u240, (char)'/', (boolean)false, (int)2, null)) {
            String string2 = $this$posixBasename_u24lambda_u240.substring(0, $this$posixBasename_u24lambda_u240.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$posixBasename_u24lambda_u240;
        }
        String $this$posixBasename_u24lambda_u241 = string;
        boolean bl2 = false;
        String string3 = $this$posixBasename_u24lambda_u241.substring(StringsKt.lastIndexOf$default((CharSequence)$this$posixBasename_u24lambda_u241, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    public static final CharsetDecoder getUtf8ReplacingDecoder() {
        return utf8ReplacingDecoder;
    }

    @VisibleForTesting
    @NotNull
    public static final String escapeLikeStrace(@NotNull byte[] $this$escapeLikeStrace, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeLikeStrace, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)offset, (int)length)), (CharSequence)"", null, null, (int)0, null, arg_0 -> UtilKt.escapeLikeStrace$lambda$0($this$escapeLikeStrace, arg_0), (int)30, null);
    }

    public static /* synthetic */ String escapeLikeStrace$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length - n;
        }
        return UtilKt.escapeLikeStrace(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<EnvironmentVariable.Certain> certainVariables(@NotNull List<? extends EnvironmentVariable> $this$certainVariables) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter($this$certainVariables, (String)"<this>");
        Set globs = new LinkedHashSet();
        for (EnvironmentVariable environmentVariable : $this$certainVariables) {
            EnvironmentVariable environmentVariable2 = environmentVariable;
            if (environmentVariable2 instanceof EnvironmentVariable.Certain) continue;
            if (environmentVariable2 instanceof EnvironmentVariable.Inherit) {
                if (StringsKt.startsWith$default((String)((EnvironmentVariable.Inherit)environmentVariable).getGlob(), (String)"-", (boolean)false, (int)2, null)) {
                    Collection collection = globs;
                    String string = ((EnvironmentVariable.Inherit)environmentVariable).getGlob().substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.remove(string);
                    continue;
                }
                ((Collection)globs).add(((EnvironmentVariable.Inherit)environmentVariable).getGlob());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        LinkedHashMap varsToSend = new LinkedHashMap();
        Lazy lazy = LazyKt.lazy(UtilKt::certainVariables$lambda$0);
        for (String string : globs) {
            for (Map.Entry entry : UtilKt.certainVariables$lambda$1((Lazy<? extends Map<String, String>>)lazy).entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)name);
                if (!UtilKt.matchPattern(name, string)) continue;
                ((Map)varsToSend).put(name, value);
            }
        }
        for (EnvironmentVariable environmentVariable : $this$certainVariables) {
            object = environmentVariable;
            if (object instanceof EnvironmentVariable.Certain) {
                ((Map)varsToSend).put(((EnvironmentVariable.Certain)environmentVariable).getName(), ((EnvironmentVariable.Certain)environmentVariable).getValue());
                continue;
            }
            if (object instanceof EnvironmentVariable.Inherit) continue;
            throw new NoWhenBranchMatchedException();
        }
        Set set = varsToSend.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$map$iv = set;
        boolean bl = false;
        object = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection2 = collection;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String name = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            String value = (String)v;
            collection2.add(new EnvironmentVariable.Certain(name, value));
        }
        return (List)collection;
    }

    @VisibleForTesting
    public static final boolean matchPattern(@NotNull String s, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int i = 0;
        for (int j = 0; j < pattern.length(); ++j) {
            if (j == pattern.length()) {
                return i == s.length();
            }
            if (pattern.charAt(j) == '*') {
                while (j < pattern.length() && pattern.charAt(j) == '*') {
                    ++j;
                }
                if (j == pattern.length()) {
                    return true;
                }
                if (pattern.charAt(j) != '?' && pattern.charAt(j) != '*') {
                    while (i < s.length()) {
                        if (s.charAt(i) == pattern.charAt(j)) {
                            String string = s.substring(i + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            String string2 = pattern.substring(j + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            if (UtilKt.matchPattern(string, string2)) {
                                return true;
                            }
                        }
                        ++i;
                    }
                    return false;
                }
                while (i < s.length()) {
                    String string = s.substring(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string3 = pattern.substring(j);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    if (UtilKt.matchPattern(string, string3)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            if (i == s.length()) {
                return false;
            }
            if (pattern.charAt(j) != '?' && pattern.charAt(j) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return i == s.length();
    }

    @VisibleForTesting
    @Nullable
    public static final List<String> argvSplit(@NotNull String source, boolean terminateOnComment) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List result = new ArrayList();
        Character insideQuotes = null;
        boolean currentIsEscaped = false;
        char[] cArray = new char[]{' ', '\t'};
        String string = StringsKt.trimEnd((String)source, (char[])cArray);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char current = string.charAt(i);
            boolean appendBackslashBeforeCurrent = false;
            boolean appendCurrent = false;
            char c = current;
            if (c == '#') {
                if (terminateOnComment && insideQuotes == null && !currentIsEscaped && ((var12_15 = (CharSequence)CollectionsKt.lastOrNull((List)result)) == null || var12_15.length() == 0)) break;
                appendBackslashBeforeCurrent = false;
                appendCurrent = true;
            } else if (c == '\\') {
                appendBackslashBeforeCurrent = currentIsEscaped;
                appendCurrent = false;
            } else if (StringsKt.contains$default((CharSequence)"\"'", (char)c, (boolean)false, (int)2, null)) {
                boolean bl;
                appendBackslashBeforeCurrent = false;
                if (currentIsEscaped) {
                    bl = true;
                } else if (insideQuotes == null) {
                    insideQuotes = Character.valueOf(current);
                    bl = false;
                } else {
                    char c2 = current;
                    if (insideQuotes.charValue() == c2) {
                        insideQuotes = null;
                        bl = false;
                    } else {
                        bl = true;
                    }
                }
                appendCurrent = bl;
            } else if (StringsKt.contains$default((CharSequence)" \t", (char)c, (boolean)false, (int)2, null)) {
                boolean bl;
                appendBackslashBeforeCurrent = insideQuotes != null && currentIsEscaped;
                if (currentIsEscaped) {
                    bl = true;
                } else if (insideQuotes != null) {
                    bl = true;
                } else {
                    var12_15 = (CharSequence)CollectionsKt.lastOrNull((List)result);
                    if (var12_15 == null || var12_15.length() == 0) {
                        bl = false;
                    } else {
                        ((Collection)result).add("");
                        bl = false;
                    }
                }
                appendCurrent = bl;
            } else {
                appendBackslashBeforeCurrent = currentIsEscaped;
                appendCurrent = true;
            }
            if (appendBackslashBeforeCurrent) {
                Collection collection = result;
                String string2 = (String)CollectionsKt.removeLastOrNull((List)result);
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(string2 + "\\");
            }
            if (appendCurrent) {
                Collection collection = result;
                String string3 = (String)CollectionsKt.removeLastOrNull((List)result);
                if (string3 == null) {
                    string3 = "";
                }
                collection.add(string3 + current);
            }
            currentIsEscaped = current == '\\' && !currentIsEscaped;
        }
        return insideQuotes != null ? null : result;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence escapeLikeStrace$lambda$0(byte[] $this_escapeLikeStrace, int it) {
        CharSequence charSequence;
        void var3_2;
        byte i = $this_escapeLikeStrace[it];
        boolean bl = false;
        int b = i < 0 ? 256 + i : var3_2;
        if (b == 39) {
            charSequence = "'";
        } else if (b == 34) {
            charSequence = "\\\"";
        } else if (b == 92) {
            charSequence = "\\\\";
        } else if (b == 12) {
            charSequence = "\\f";
        } else if (b == 10) {
            charSequence = "\\n";
        } else if (b == 13) {
            charSequence = "\\r";
        } else if (b == 9) {
            charSequence = "\\t";
        } else if (b == 11) {
            charSequence = "\\v";
        } else if (b == 0) {
            charSequence = "\\0";
        } else {
            boolean bl2 = 32 <= b ? b < 127 : false;
            if (bl2) {
                charSequence = String.valueOf((char)$this_escapeLikeStrace[it]);
            } else {
                String string = Integer.toString(b, CharsKt.checkRadix((int)8));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                charSequence = "\\" + string;
            }
        }
        return charSequence;
    }

    private static final Map<String, String> certainVariables$lambda$1(Lazy<? extends Map<String, String>> $systemEnvVars$delegate) {
        Lazy<? extends Map<String, String>> lazy = $systemEnvVars$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map certainVariables$lambda$0() {
        return EnvironmentUtil.getEnvironmentMap();
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.ssh.impl.sshj.sshj");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SSHJ_LOG = logger;
        utf8ReplacingDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=176)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Response.StatusCode.values().length];
            try {
                nArray[Response.StatusCode.PERMISSION_DENIED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Response.StatusCode.NO_SUCH_FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

