/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.google.common.net.HostAndPort;
import com.intellij.ssh.SshTunnelAlreadyRegisteredException;
import com.intellij.ssh.SshTunnelCreationException;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.tunnels.LocalTunnelServer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0015J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0015J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010(\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\b\u001a6\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tj\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection;", "Ljava/io/Closeable;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "ownerName", "", "<init>", "(Lnet/schmizz/sshj/SSHClient;Ljava/lang/String;)V", "forwardersByLocalAddress", "Ljava/util/HashMap;", "Ljava/net/InetSocketAddress;", "Lkotlin/Pair;", "Lnet/schmizz/sshj/connection/channel/direct/Parameters;", "Lcom/intellij/ssh/impl/sshj/tunnels/LocalTunnelServer;", "Lkotlin/collections/HashMap;", "forwardersLock", "Ljava/util/concurrent/locks/ReentrantLock;", "create", "", "localHost", "localPort", "", "remoteHost", "remotePort", "Ljava/net/InetAddress;", "createForFreePort", "wrapIntoTunnelCreationException", "Lcom/intellij/ssh/SshTunnelCreationException;", "Ljava/io/IOException;", "logLabel", "initializeForwarder", "params", "serverSocket", "Ljava/net/ServerSocket;", "key", "get", "", "remove", "getLocalAddressForRemotePort", "Lcom/google/common/net/HostAndPort;", "close", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nLocalForwarderCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1915#2,2:271\n1915#2,2:273\n*S KotlinDebug\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection\n*L\n148#1:271,2\n151#1:273,2\n*E\n"})
public final class LocalForwarderCollection
implements Closeable {
    @NotNull
    private final SSHClient sshClient;
    @NotNull
    private final String ownerName;
    @NotNull
    private final HashMap<InetSocketAddress, Pair<Parameters, LocalTunnelServer>> forwardersByLocalAddress;
    @NotNull
    private final ReentrantLock forwardersLock;

    public LocalForwarderCollection(@NotNull SSHClient sshClient, @NotNull String ownerName) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this.sshClient = sshClient;
        this.ownerName = ownerName;
        this.forwardersByLocalAddress = new HashMap();
        this.forwardersLock = new ReentrantLock();
    }

    public final void create(@NotNull String localHost, int localPort, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.create(inetAddress, localPort, remoteHost, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(@NotNull InetAddress localHost, int localPort, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " ==> " + remoteHost + ":" + remotePort;
            UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
            Parameters params = new Parameters(localHost.getHostAddress(), localPort, remoteHost, remotePort);
            InetSocketAddress key = new InetSocketAddress(localHost, localPort);
            if (((Map)this.forwardersByLocalAddress).containsKey(key)) {
                throw new SshTunnelAlreadyRegisteredException("Already registered: " + logLabel);
            }
            ServerSocket serverSocket = new ServerSocket();
            try {
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(params.getLocalHost(), params.getLocalPort()));
                this.initializeForwarder(params, serverSocket, key);
            }
            catch (IOException error) {
                Closeable closeable = serverSocket;
                Throwable throwable = null;
                try {
                    try {
                        ServerSocket it = (ServerSocket)closeable;
                        boolean bl2 = false;
                        throw this.wrapIntoTunnelCreationException(error, logLabel);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    throw throwable3;
                }
            }
            UtilKt.getSSHJ_LOG().debug("Created " + logLabel);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final int createForFreePort(@NotNull String localHost, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        return this.createForFreePort(inetAddress, remoteHost, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createForFreePort(@NotNull InetAddress localHost, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardersLock;
        lock.lock();
        boolean bl = false;
        String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":<any free port> ==> " + remoteHost + ":" + remotePort;
        UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
        SshTunnelCreationException lastError = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            ServerSocket serverSocket = new ServerSocket();
            try {
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(localHost, 0));
                InetSocketAddress key = new InetSocketAddress(localHost, serverSocket.getLocalPort());
                if (this.forwardersByLocalAddress.containsKey(key)) {
                    serverSocket.close();
                    continue;
                }
                Parameters params = new Parameters(key.getHostString(), key.getPort(), remoteHost, remotePort);
                this.initializeForwarder(params, serverSocket, key);
                UtilKt.getSSHJ_LOG().debug("Created " + logLabel + ", chosen port is " + key.getPort());
                int n = key.getPort();
                return n;
            }
            catch (IOException error) {
                Closeable closeable = serverSocket;
                Throwable throwable = null;
                try {
                    ServerSocket it = (ServerSocket)closeable;
                    boolean bl2 = false;
                    lastError = this.wrapIntoTunnelCreationException(error, logLabel);
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        SshTunnelCreationException sshTunnelCreationException = lastError;
        Intrinsics.checkNotNull(sshTunnelCreationException);
        throw (Throwable)((Object)sshTunnelCreationException);
        finally {
            lock.unlock();
        }
    }

    private final SshTunnelCreationException wrapIntoTunnelCreationException(IOException $this$wrapIntoTunnelCreationException, String logLabel) {
        String message = "Failed to create " + logLabel + ": " + $this$wrapIntoTunnelCreationException.getMessage();
        UtilKt.getSSHJ_LOG().warn(message, (Throwable)$this$wrapIntoTunnelCreationException);
        return new SshTunnelCreationException(message, $this$wrapIntoTunnelCreationException);
    }

    private final void initializeForwarder(Parameters params, ServerSocket serverSocket, InetSocketAddress key) {
        Connection connection = this.sshClient.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        LocalTunnelServer forwarder = new LocalTunnelServer(connection, params, serverSocket, this.ownerName);
        ((Map)this.forwardersByLocalAddress).put(key, new Pair((Object)params, (Object)forwarder));
        forwarder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> get() {
        List list;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            list = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), LocalForwarderCollection::get$lambda$0$0), LocalForwarderCollection::get$lambda$0$1));
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    public final void remove(@NotNull String localHost, int localPort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.remove(inetAddress, localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull InetAddress localHost, int localPort) {
        LocalTunnelServer localTunnelServer;
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        InetSocketAddress localAddress = new InetSocketAddress(localHost, localPort);
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Pair<Parameters, LocalTunnelServer> pair = this.forwardersByLocalAddress.remove(localAddress);
            localTunnelServer = pair != null ? (LocalTunnelServer)pair.getSecond() : null;
        }
        finally {
            lock.unlock();
        }
        LocalTunnelServer forwarder = localTunnelServer;
        String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " ==>";
        if (forwarder != null) {
            forwarder.stop();
            forwarder.await();
            Parameters $this$remove_u24lambda_u241 = forwarder.getParams();
            boolean bl = false;
            UtilKt.getSSHJ_LOG().debug("Removed " + logLabel + " " + $this$remove_u24lambda_u241.getRemoteHost() + ":" + $this$remove_u24lambda_u241.getRemotePort());
        } else {
            UtilKt.getSSHJ_LOG().debug("Tried to remove non-existing " + logLabel + " <host>:<port>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HostAndPort getLocalAddressForRemotePort(int remotePort) {
        HostAndPort hostAndPort;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            hostAndPort = (HostAndPort)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), LocalForwarderCollection::getLocalAddressForRemotePort$lambda$0$0), arg_0 -> LocalForwarderCollection.getLocalAddressForRemotePort$lambda$0$1(remotePort, arg_0)), LocalForwarderCollection::getLocalAddressForRemotePort$lambda$0$2));
        }
        finally {
            lock.unlock();
        }
        return hostAndPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22 = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List servers = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), LocalForwarderCollection::close$lambda$0$0));
            this.forwardersByLocalAddress.clear();
            Iterable $this$forEach$iv = servers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalTunnelServer it = (LocalTunnelServer)element$iv;
                boolean bl = false;
                it.stop();
            }
            $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22 = servers;
        }
        finally {
            lock.unlock();
        }
        List stoppedServers = $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22;
        Iterable $this$forEach$iv = stoppedServers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalTunnelServer it = (LocalTunnelServer)element$iv;
            boolean bl = false;
            it.await();
        }
    }

    private static final Parameters get$lambda$0$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Parameters)it.getFirst();
    }

    /*
     * Unable to fully structure code
     */
    private static final String get$lambda$0$1(Parameters it) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                var2_1 = it.getLocalHost();
                if (var2_1 == null) break block7;
                switch (var2_1.hashCode()) {
                    case 0: {
                        if (!var2_1.equals("")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case -1204607085: {
                        if (!var2_1.equals("localhost")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case 1505998205: {
                        if (!var2_1.equals("127.0.0.1")) break;
lbl15:
                        // 3 sources

                        v0 = "";
                        break block8;
                    }
                }
            }
            v0 = it.getLocalHost() + ":";
        }
        fromHost = v0;
        return fromHost + it.getLocalPort() + ":" + it.getRemoteHost() + ":" + it.getRemotePort();
    }

    private static final Parameters getLocalAddressForRemotePort$lambda$0$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Parameters)it.getFirst();
    }

    private static final boolean getLocalAddressForRemotePort$lambda$0$1(int $remotePort, Parameters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRemotePort() == $remotePort;
    }

    private static final HostAndPort getLocalAddressForRemotePort$lambda$0$2(Parameters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HostAndPort.fromParts((String)it.getLocalHost(), (int)it.getLocalPort());
    }

    private static final LocalTunnelServer close$lambda$0$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LocalTunnelServer)it.getSecond();
    }
}

