/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.interaction.SshPasswordProvider;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\b\u0005\u0018\u00002\u00020\u0001Bg\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B'\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0013J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016JI\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u00032\b\b\u0001\u0010#\u001a\u00020\u0003H\u0002J&\u0010$\u001a\u00020\u00032\b\b\u0001\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u00032\b\b\u0001\u0010#\u001a\u00020\u0003H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ssh/interaction/PlatformSshPasswordProvider;", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "host", "", "port", "", "user", "keyPathGetter", "Lkotlin/Function0;", "keyPassphraseGetter", "unixPasswordGetter", "allowDialogs", "", "passwordPrompt", "Lcom/intellij/ssh/ui/SshPasswordPrompt;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ZLcom/intellij/ssh/ui/SshPasswordPrompt;)V", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;ZLcom/intellij/ssh/ui/SshPasswordPrompt;)V", "getKeyPassphrase", "privateKeyPath", "Ljava/nio/file/Path;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getUnixPassword", "getKeyboardInteractive", "", "name", "instruction", "prompt", "echo", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[ZLcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "showPasswordDialog", "question", "buildMessage", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nPlatformSshPasswordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformSshPasswordProvider.kt\ncom/intellij/ssh/interaction/PlatformSshPasswordProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,133:1\n1#2:134\n37#3,2:135\n*S KotlinDebug\n*F\n+ 1 PlatformSshPasswordProvider.kt\ncom/intellij/ssh/interaction/PlatformSshPasswordProvider\n*L\n98#1:135,2\n*E\n"})
public final class PlatformSshPasswordProvider
implements SshPasswordProvider {
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String user;
    @NotNull
    private final Function0<String> keyPathGetter;
    @NotNull
    private final Function0<String> keyPassphraseGetter;
    @NotNull
    private final Function0<String> unixPasswordGetter;
    private final boolean allowDialogs;
    @Nullable
    private final SshPasswordPrompt passwordPrompt;

    @JvmOverloads
    public PlatformSshPasswordProvider(@NotNull String host, int port, @NotNull String user, @NotNull Function0<String> keyPathGetter, @NotNull Function0<String> keyPassphraseGetter, @NotNull Function0<String> unixPasswordGetter, boolean allowDialogs, @Nullable SshPasswordPrompt passwordPrompt) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(keyPathGetter, (String)"keyPathGetter");
        Intrinsics.checkNotNullParameter(keyPassphraseGetter, (String)"keyPassphraseGetter");
        Intrinsics.checkNotNullParameter(unixPasswordGetter, (String)"unixPasswordGetter");
        this.host = host;
        this.port = port;
        this.user = user;
        this.keyPathGetter = keyPathGetter;
        this.keyPassphraseGetter = keyPassphraseGetter;
        this.unixPasswordGetter = unixPasswordGetter;
        this.allowDialogs = allowDialogs;
        this.passwordPrompt = passwordPrompt;
    }

    public /* synthetic */ PlatformSshPasswordProvider(String string, int n, String string2, Function0 function0, Function0 function02, Function0 function03, boolean bl, SshPasswordPrompt sshPasswordPrompt, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        if ((n2 & 0x80) != 0) {
            sshPasswordPrompt = null;
        }
        this(string, n, string2, (Function0<String>)function0, (Function0<String>)function02, (Function0<String>)function03, bl, sshPasswordPrompt);
    }

    public PlatformSshPasswordProvider(@NotNull RemoteCredentials remoteCredentials, boolean allowDialogs, @Nullable SshPasswordPrompt passwordPrompt) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        String string = remoteCredentials.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        int n = remoteCredentials.getPort();
        String string2 = remoteCredentials.getUserName();
        if (string2 == null) {
            string2 = "";
        }
        this(string, n, string2, (Function0<String>)((Function0)new Function0<String>((Object)remoteCredentials){

            public final String invoke() {
                return ((RemoteCredentials)this.receiver).getPrivateKeyFile();
            }
        }), (Function0<String>)((Function0)new Function0<String>((Object)remoteCredentials){

            public final String invoke() {
                return ((RemoteCredentials)this.receiver).getPassphrase();
            }
        }), (Function0<String>)((Function0)new Function0<String>((Object)remoteCredentials){

            public final String invoke() {
                return ((RemoteCredentials)this.receiver).getPassword();
            }
        }), allowDialogs, passwordPrompt);
    }

    public /* synthetic */ PlatformSshPasswordProvider(RemoteCredentials remoteCredentials, boolean bl, SshPasswordPrompt sshPasswordPrompt, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            sshPasswordPrompt = null;
        }
        this(remoteCredentials, bl, sshPasswordPrompt);
    }

    @Nullable
    public String getKeyPassphrase(@NotNull Path privateKeyPath, @Nullable ProgressIndicator progressIndicator2) {
        boolean showPrompt;
        Path path;
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        String string = StringKt.nullize$default((String)((String)this.keyPathGetter.invoke()), (boolean)false, (int)1, null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        Path rememberedKeyPath = path;
        String passphrase = StringKt.nullize$default((String)((String)this.keyPassphraseGetter.invoke()), (boolean)false, (int)1, null);
        if (Intrinsics.areEqual((Object)rememberedKeyPath, (Object)privateKeyPath) && passphrase != null) {
            return passphrase;
        }
        boolean bl = showPrompt = this.allowDialogs && Registry.Companion.is("ide.show.ssh.auth.prompt");
        if (showPrompt) {
            SshPasswordPrompt.Request.Key request = new SshPasswordPrompt.Request.Key(new SshPasswordPrompt.UserHostPort(this.user, this.host, this.port), progressIndicator2, privateKeyPath);
            SshPasswordPrompt sshPasswordPrompt = this.passwordPrompt;
            if (sshPasswordPrompt == null) {
                sshPasswordPrompt = SshPasswordPrompt.Companion.getInstance();
            }
            SshPasswordPrompt passwordPromptToUse = sshPasswordPrompt;
            return passwordPromptToUse.handleRequest(null, request);
        }
        return passphrase;
    }

    @Nullable
    public String getUnixPassword(@Nullable ProgressIndicator progressIndicator2) {
        boolean showPrompt = this.allowDialogs && Registry.Companion.is("ide.show.ssh.auth.prompt");
        String password = StringKt.nullize$default((String)((String)this.unixPasswordGetter.invoke()), (boolean)false, (int)1, null);
        if (password == null && showPrompt) {
            SshPasswordPrompt.Request.Password request = new SshPasswordPrompt.Request.Password(new SshPasswordPrompt.UserHostPort(this.user, this.host, this.port), progressIndicator2);
            SshPasswordPrompt sshPasswordPrompt = this.passwordPrompt;
            if (sshPasswordPrompt == null) {
                sshPasswordPrompt = SshPasswordPrompt.Companion.getInstance();
            }
            SshPasswordPrompt passwordPromptToUse = sshPasswordPrompt;
            return passwordPromptToUse.handleRequest(null, request);
        }
        return password;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String[] getKeyboardInteractive(@Nls @NotNull String name, @Nls @NotNull String instruction, @NotNull String[] prompt, @NotNull boolean[] echo, @Nullable ProgressIndicator progressIndicator2) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)echo, (String)"echo");
        boolean showPrompt = Registry.Companion.is("ide.show.ssh.auth.prompt");
        String[] stringArray = (String[])SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.map((Sequence)SequencesKt.withIndex((Sequence)ArraysKt.asSequence((Object[])prompt)), arg_0 -> PlatformSshPasswordProvider.getKeyboardInteractive$lambda$0(showPrompt, this, progressIndicator2, name, instruction, echo, arg_0)), PlatformSshPasswordProvider::getKeyboardInteractive$lambda$1)));
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] it = stringArray = thisCollection$iv.toArray(new String[0]);
        boolean bl = false;
        return it.length == prompt.length ? stringArray : null;
    }

    private final String showPasswordDialog(@Nls String name, @Nls String instruction, @Nls String question) {
        Object[] objectArray = new Object[]{this.user, this.host + ":" + this.port};
        return MessagesService.Companion.getInstance().showPasswordDialog(null, this.buildMessage(name, instruction, question), SshBundle.message("ssh.connection.dialog.title.user.host", objectArray), UIUtil.getQuestionIcon(), null);
    }

    @Nls
    private final String buildMessage(@Nls String name, @Nls String instruction, @Nls String question) {
        Object message = "";
        if (((CharSequence)name).length() > 0) {
            message = (String)message + name;
        }
        if (((CharSequence)message).length() > 0) {
            message = (String)message + "\n\n";
        }
        if (((CharSequence)instruction).length() > 0) {
            message = (String)message + instruction;
        }
        if (((CharSequence)message).length() > 0) {
            message = (String)message + "\n\n";
        }
        if (((CharSequence)question).length() > 0) {
            message = (String)message + question;
        }
        return message;
    }

    @JvmOverloads
    public PlatformSshPasswordProvider(@NotNull String host, int port, @NotNull String user, @NotNull Function0<String> keyPathGetter, @NotNull Function0<String> keyPassphraseGetter, @NotNull Function0<String> unixPasswordGetter, boolean allowDialogs) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(keyPathGetter, (String)"keyPathGetter");
        Intrinsics.checkNotNullParameter(keyPassphraseGetter, (String)"keyPassphraseGetter");
        Intrinsics.checkNotNullParameter(unixPasswordGetter, (String)"unixPasswordGetter");
        this(host, port, user, keyPathGetter, keyPassphraseGetter, unixPasswordGetter, allowDialogs, null, 128, null);
    }

    @JvmOverloads
    public PlatformSshPasswordProvider(@NotNull String host, int port, @NotNull String user, @NotNull Function0<String> keyPathGetter, @NotNull Function0<String> keyPassphraseGetter, @NotNull Function0<String> unixPasswordGetter) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(keyPathGetter, (String)"keyPathGetter");
        Intrinsics.checkNotNullParameter(keyPassphraseGetter, (String)"keyPassphraseGetter");
        Intrinsics.checkNotNullParameter(unixPasswordGetter, (String)"unixPasswordGetter");
        this(host, port, user, keyPathGetter, keyPassphraseGetter, unixPasswordGetter, false, null, 192, null);
    }

    private static final String getKeyboardInteractive$lambda$0$0(PlatformSshPasswordProvider this$0, String $name, String $instruction, String $question) {
        return this$0.showPasswordDialog($name, $instruction, $question);
    }

    private static final String getKeyboardInteractive$lambda$0(boolean $showPrompt, PlatformSshPasswordProvider this$0, ProgressIndicator $progressIndicator, String $name, String $instruction, boolean[] $echo, IndexedValue indexedValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int idx = indexedValue.component1();
        String question = (String)indexedValue.component2();
        if ($showPrompt) {
            SshPasswordPrompt sshPasswordPrompt = this$0.passwordPrompt;
            if (sshPasswordPrompt == null) {
                sshPasswordPrompt = SshPasswordPrompt.Companion.getInstance();
            }
            SshPasswordPrompt passwordPromptToUse = sshPasswordPrompt;
            SshPasswordPrompt.Request.KeyboardInteractive request = new SshPasswordPrompt.Request.KeyboardInteractive(new SshPasswordPrompt.UserHostPort(this$0.user, this$0.host, this$0.port), $progressIndicator, this$0.buildMessage($name, $instruction, question), $echo[idx]);
            string = passwordPromptToUse.handleRequest(null, request);
        } else {
            string = (String)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), () -> PlatformSshPasswordProvider.getKeyboardInteractive$lambda$0$0(this$0, $name, $instruction, question));
        }
        return string;
    }

    private static final boolean getKeyboardInteractive$lambda$1(String it) {
        CharSequence charSequence = it;
        return !(charSequence == null || charSequence.length() == 0);
    }
}

