/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.filters.LogEventBucketsFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFalseFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventMetadataFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.model.config.v4.ConfigurationBucketRange;
import com.jetbrains.fus.reporting.model.config.v4.ConfigurationReleaseFilter;
import com.jetbrains.fus.reporting.model.exceptions.StatsResponseException;
import java.net.ConnectException;
import java.net.http.HttpTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\rJ\b\u0010\u0017\u001a\u0004\u0018\u00010\rJ\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\b\u0010\u001a\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001cJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0002J,\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J%\u0010*\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u0002H+0-H\u0002\u00a2\u0006\u0002\u0010.R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogSettingsClient;", "", "<init>", "()V", "configurationClient", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "getConfigurationClient", "()Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "getApplicationInfo", "()Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "recorderId", "", "getRecorderId", "()Ljava/lang/String;", "isConfigurationReachable", "", "isSendEnabled", "provideOptions", "", "provideEndpointValue", "endpoint", "provideServiceUrl", "provideDictionaryServiceUrl", "provideMetadataEndpoint", "provideMetadataProductUrl", "provideEventFilter", "Lcom/intellij/internal/statistic/eventLog/filters/LogEventFilter;", "base", "type", "Lcom/intellij/internal/statistic/config/eventLog/EventLogBuildType;", "provideBaseEventFilter", "provideBucketRanges", "", "Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationBucketRange;", "loadApprovedGroupsRules", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupsFilterRules;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "notNull", "groupFilterConditions", "defaultValue", "logError", "T", "supplier", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/lang/Object;", "intellij.platform.statistics.uploader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogSettingsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogSettingsClient.kt\ncom/intellij/internal/statistic/eventLog/connection/EventLogSettingsClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1915#2,2:221\n*S KotlinDebug\n*F\n+ 1 EventLogSettingsClient.kt\ncom/intellij/internal/statistic/eventLog/connection/EventLogSettingsClient\n*L\n179#1:221,2\n*E\n"})
public abstract class EventLogSettingsClient {
    @NotNull
    public abstract ConfigurationClient getConfigurationClient();

    @NotNull
    public abstract EventLogApplicationInfo getApplicationInfo();

    @NotNull
    public abstract String getRecorderId();

    public final boolean isConfigurationReachable() {
        Boolean result = this.logError(() -> EventLogSettingsClient.isConfigurationReachable$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration url: " + this.getConfigurationClient().getConfigurationUrl());
        this.getApplicationInfo().getLogger().info("Statistics. Configuration is reachable: " + result);
        return result != null && result != false;
    }

    public final boolean isSendEnabled() {
        Boolean result = this.logError(() -> EventLogSettingsClient.isSendEnabled$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Send is enabled: " + result);
        return result != null && result != false;
    }

    @NotNull
    public final Map<String, String> provideOptions() {
        Map result = this.logError(() -> EventLogSettingsClient.provideOptions$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration options: " + result);
        Map map = result;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public final String provideEndpointValue(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String result = this.logError(() -> EventLogSettingsClient.provideEndpointValue$lambda$0(this, endpoint));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration endpoint: " + result);
        return result;
    }

    @Nullable
    public final String provideServiceUrl() {
        String result = this.logError(() -> EventLogSettingsClient.provideServiceUrl$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration service url: " + result);
        return result;
    }

    @Nullable
    public final String provideDictionaryServiceUrl() {
        String result = this.logError(() -> EventLogSettingsClient.provideDictionaryServiceUrl$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration dictionary service url: " + result);
        return result;
    }

    @Nullable
    public final String provideMetadataEndpoint() {
        String result = this.logError(() -> EventLogSettingsClient.provideMetadataEndpoint$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration metadata endpoint: " + result);
        return result;
    }

    @Nullable
    public final String provideMetadataProductUrl() {
        String result = this.logError(() -> EventLogSettingsClient.provideMetadataProductUrl$lambda$0(this));
        this.getApplicationInfo().getLogger().info("Statistics. Configuration metadata product url: " + result);
        return result;
    }

    @NotNull
    public LogEventFilter provideEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<ConfigurationBucketRange> bucketRanges = this.provideBucketRanges(type);
        if (bucketRanges.isEmpty()) {
            DataCollectorDebugLogger dataCollectorDebugLogger = this.getApplicationInfo().getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)dataCollectorDebugLogger, (String)"getLogger(...)");
            DataCollectorDebugLogger logger = dataCollectorDebugLogger;
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot find send bucketRanges for '" + type + "' -> clean up log file");
            }
            return LogEventFalseFilter.INSTANCE;
        }
        LogEventFilter[] logEventFilterArray = new LogEventFilter[]{new LogEventBucketsFilter(bucketRanges), base, LogEventSnapshotBuildFilter.INSTANCE};
        return new LogEventCompositeFilter(logEventFilterArray);
    }

    @NotNull
    public final LogEventFilter provideBaseEventFilter() {
        EventGroupsFilterRules<EventLogBuild> eventGroupsFilterRules = this.loadApprovedGroupsRules();
        EventGroupsFilterRules eventGroupsFilterRules2 = EventGroupsFilterRules.empty();
        Intrinsics.checkNotNullExpressionValue((Object)eventGroupsFilterRules2, (String)"empty(...)");
        return new LogEventMetadataFilter(this.notNull(eventGroupsFilterRules, (EventGroupsFilterRules<EventLogBuild>)eventGroupsFilterRules2));
    }

    @VisibleForTesting
    @NotNull
    public final List<ConfigurationBucketRange> provideBucketRanges(@NotNull EventLogBuildType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List result = this.logError(() -> EventLogSettingsClient.provideBucketRanges$lambda$0(this, type));
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final EventGroupsFilterRules<EventLogBuild> loadApprovedGroupsRules() {
        String productUrl = this.provideMetadataProductUrl();
        if (productUrl == null) {
            return null;
        }
        return EventLogMetadataUtils.loadAndParseGroupsFilterRules(productUrl, this.getApplicationInfo().getConnectionSettings());
    }

    private final EventGroupsFilterRules<EventLogBuild> notNull(EventGroupsFilterRules<EventLogBuild> groupFilterConditions, EventGroupsFilterRules<EventLogBuild> defaultValue) {
        EventGroupsFilterRules<EventLogBuild> eventGroupsFilterRules = groupFilterConditions;
        if (eventGroupsFilterRules == null) {
            eventGroupsFilterRules = defaultValue;
        }
        return eventGroupsFilterRules;
    }

    private final <T> T logError(Supplier<? extends T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            Locale locale = Locale.ENGLISH;
            String string = "%s: %s";
            Object[] objectArray = new Object[]{e.getClass().getName(), Objects.requireNonNullElse(e.getMessage(), "No message provided")};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message = string2;
            if (e instanceof ConnectException || e instanceof HttpTimeoutException || e instanceof SSLHandshakeException || e instanceof StatsResponseException) {
                this.getApplicationInfo().getLogger().info(message);
            } else {
                this.getApplicationInfo().getLogger().warn(message, e);
            }
            this.getApplicationInfo().getEventLogger().logLoadingConfigFailed(this.getRecorderId(), e);
            return null;
        }
    }

    private static final Boolean isConfigurationReachable$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().isConfigurationReachable();
    }

    private static final Boolean isSendEnabled$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().isSendEnabled();
    }

    private static final Map provideOptions$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().provideOptions();
    }

    private static final String provideEndpointValue$lambda$0(EventLogSettingsClient this$0, String $endpoint) {
        return this$0.getConfigurationClient().provideEndpointValue($endpoint);
    }

    private static final String provideServiceUrl$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().provideSendEndpoint();
    }

    private static final String provideDictionaryServiceUrl$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().provideDictionaryEndpoint();
    }

    private static final String provideMetadataEndpoint$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().provideMetadataEndpoint();
    }

    private static final String provideMetadataProductUrl$lambda$0(EventLogSettingsClient this$0) {
        return this$0.getConfigurationClient().provideMetadataProductUrl(this$0.getApplicationInfo().getBaselineVersion());
    }

    /*
     * WARNING - void declaration
     */
    private static final List provideBucketRanges$lambda$0(EventLogSettingsClient this$0, EventLogBuildType $type) {
        void $this$forEach$iv;
        ConfigurationClient configurationClient = this$0.getConfigurationClient();
        String string = $type.text;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        List conditions = configurationClient.provideReleaseFilters(string2);
        if (conditions.isEmpty()) {
            conditions = this$0.getConfigurationClient().provideReleaseFilters("ALL");
        }
        if (conditions.isEmpty()) {
            return null;
        }
        List bucketRanges = new ArrayList();
        Iterable iterable = conditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurationReleaseFilter condition = (ConfigurationReleaseFilter)element$iv;
            boolean bl = false;
            if (condition.provideBucketRange() == null) continue;
            ConfigurationBucketRange configurationBucketRange = condition.provideBucketRange();
            Intrinsics.checkNotNull((Object)configurationBucketRange);
            bucketRanges.add(configurationBucketRange);
        }
        return bucketRanges;
    }
}

