/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.FilesToSendProvider;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.config.EventLogFileListProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EventLogExternalSendConfig
implements EventLogSendConfig {
    @NotNull
    private final String myRecorderId;
    private final String myDeviceId;
    private final int myBucket;
    private final MachineId myMachineId;
    private final FilesToSendProvider myFilesProvider;
    private final boolean myIsSendEnabled;
    private final boolean myIsEscapeEnabled;

    public EventLogExternalSendConfig(@NotNull String recorder, @NotNull String deviceId, int bucket, @NotNull MachineId machineId, @NotNull List<String> logs, boolean isSendEnabled) {
        if (recorder == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(0);
        }
        if (deviceId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(1);
        }
        if (machineId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(2);
        }
        if (logs == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(3);
        }
        this(recorder, deviceId, bucket, machineId, logs, isSendEnabled, true);
    }

    public EventLogExternalSendConfig(@NotNull String recorder, @NotNull String deviceId, int bucket, @NotNull MachineId machineId, @NotNull List<String> logs, boolean isSendEnabled, boolean isEscapeEnabled) {
        if (recorder == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(4);
        }
        if (deviceId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(5);
        }
        if (machineId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(6);
        }
        if (logs == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(7);
        }
        this.myRecorderId = recorder;
        this.myDeviceId = deviceId;
        this.myBucket = bucket;
        this.myMachineId = machineId;
        this.myFilesProvider = new EventLogFileListProvider(logs);
        this.myIsSendEnabled = isSendEnabled;
        this.myIsEscapeEnabled = isEscapeEnabled;
    }

    @Override
    @NotNull
    public String getRecorderId() {
        String string = this.myRecorderId;
        if (string == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDeviceId() {
        String string = this.myDeviceId;
        if (string == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int getBucket() {
        return this.myBucket;
    }

    @Override
    @NotNull
    public MachineId getMachineId() {
        MachineId machineId = this.myMachineId;
        if (machineId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(10);
        }
        return machineId;
    }

    @Override
    public boolean isSendEnabled() {
        return this.myIsSendEnabled;
    }

    @Override
    public boolean isEscapingEnabled() {
        return this.myIsEscapeEnabled;
    }

    @Override
    @NotNull
    public FilesToSendProvider getFilesToSendProvider() {
        FilesToSendProvider filesToSendProvider = this.myFilesProvider;
        if (filesToSendProvider == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(11);
        }
        return filesToSendProvider;
    }

    public static List<EventLogExternalSendConfig> parseSendConfigurations(@NotNull Map<String, String> options, @NotNull ParseConfigurationExceptionHandler errorHandler) {
        String recorder;
        if (options == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(12);
        }
        if (errorHandler == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(13);
        }
        if ((recorder = options.get("--recorders")) == null) {
            return Collections.emptyList();
        }
        String[] recorderIds = recorder.split(";");
        ArrayList<EventLogExternalSendConfig> configurations = new ArrayList<EventLogExternalSendConfig>();
        for (String recorderId : recorderIds) {
            try {
                configurations.add(EventLogExternalSendConfig.parseSendConfiguration(recorderId, options));
            }
            catch (ParseSendConfigurationException e) {
                errorHandler.handle(recorderId, e);
            }
        }
        return configurations;
    }

    private static EventLogExternalSendConfig parseSendConfiguration(@NotNull String recorderId, @NotNull Map<String, String> options) throws ParseSendConfigurationException {
        String recorderLowerCase;
        String deviceOption;
        if (recorderId == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(14);
        }
        if (options == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(15);
        }
        if ((deviceOption = options.get("--device-" + (recorderLowerCase = recorderId.toLowerCase(Locale.ENGLISH)))) == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_DEVICE_ID);
        }
        String machineIdOption = options.get("--machine-" + recorderLowerCase);
        if (machineIdOption == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_MACHINE_ID);
        }
        int bucket = EventLogExternalSendConfig.getIntOption("--bucket-" + recorderLowerCase, options);
        if (bucket < 0 || bucket >= 256) {
            throw new ParseSendConfigurationException(ParseErrorType.INVALID_BUCKET);
        }
        int idRevisionOption = EventLogExternalSendConfig.getIntOption("--id-revision-" + recorderLowerCase, options);
        if (idRevisionOption < 0) {
            throw new ParseSendConfigurationException(ParseErrorType.INVALID_REVISION);
        }
        String logs = options.get("--files-" + recorderLowerCase);
        if (logs == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_LOG_FILES);
        }
        Boolean escape = EventLogExternalSendConfig.getBooleanOption("--escape-" + recorderLowerCase, options);
        if (escape == null) {
            escape = true;
        }
        List files = StatisticsStringUtil.split((String)logs, (char)File.pathSeparatorChar);
        return new EventLogExternalSendConfig(recorderId, deviceOption, bucket, new MachineId(machineIdOption, idRevisionOption), files, true, escape);
    }

    private static int getIntOption(@NotNull String name, @NotNull Map<String, String> options) {
        if (name == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(16);
        }
        if (options == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(17);
        }
        try {
            String option = options.get(name);
            return option != null ? Integer.parseInt(option) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static Boolean getBooleanOption(@NotNull String name, @NotNull Map<String, String> options) {
        String option;
        if (name == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(18);
        }
        if (options == null) {
            EventLogExternalSendConfig.$$$reportNull$$$0(19);
        }
        return (option = options.get(name)) != null ? Boolean.valueOf(Boolean.parseBoolean(option)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineId";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logs";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/EventLogExternalSendConfig";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/EventLogExternalSendConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecorderId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMachineId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToSendProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSendConfigurations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSendConfiguration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIntOption";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class ParseSendConfigurationException
    extends Exception {
        private final ParseErrorType myType;

        public ParseSendConfigurationException(@NotNull ParseErrorType type) {
            if (type == null) {
                ParseSendConfigurationException.$$$reportNull$$$0(0);
            }
            this.myType = type;
        }

        @NotNull
        public ParseErrorType getType() {
            ParseErrorType parseErrorType = this.myType;
            if (parseErrorType == null) {
                ParseSendConfigurationException.$$$reportNull$$$0(1);
            }
            return parseErrorType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/uploader/EventLogExternalSendConfig$ParseSendConfigurationException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/uploader/EventLogExternalSendConfig$ParseSendConfigurationException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ParseConfigurationExceptionHandler {
        public void handle(@NotNull String var1, @NotNull ParseSendConfigurationException var2);
    }

    public static enum ParseErrorType {
        NO_DEVICE_ID,
        NO_MACHINE_ID,
        INVALID_BUCKET,
        INVALID_REVISION,
        NO_LOG_FILES;

    }
}

