/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.dictionary.FixedSizedBlockDictionary;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.SimpleDictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.jetbrains.fus.reporting.model.dictionaries.RemoteDictionaryList;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final String DICTIONARIES_DIR = "dictionaries";
    private static final String DICTIONARIES_LIST_FILE = "dictionaries.json";
    private static final Logger LOG = Logger.getInstance(EventLogMetadataPersistence.class);
    @NotNull
    private final String myRecorderId;
    @Nullable
    private DictionaryStorage dictionaryStorage;

    public EventLogMetadataPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsSchemeFile();
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private Path getEventsSchemeFile() throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            Path path = Path.of(settings.getCustomPath(), new String[0]);
            if (path == null) {
                EventLogMetadataPersistence.$$$reportNull$$$0(1);
            }
            return path;
        }
        Path file = this.getDefaultFile();
        if (this.shouldBeRewrittenByBuiltinGroups(file)) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            this.initBuiltinMetadata(file);
        }
        Path path = file;
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(2);
        }
        return path;
    }

    private boolean shouldBeRewrittenByBuiltinGroups(Path defaultFile) {
        try {
            if (!Files.exists(defaultFile, new LinkOption[0])) {
                return true;
            }
            BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
            String previousBuildNumberStr = EventLogMetadataSettingsPersistence.getInstance().getBuildNumber(this.myRecorderId);
            BuildNumber previousBuildNumber = BuildNumber.fromString((String)previousBuildNumberStr);
            if (previousBuildNumber != null && previousBuildNumber.compareTo(currentBuild) >= 0) {
                return false;
            }
            EventGroupRemoteDescriptors builtinEventGroupRemoteDescriptors = this.getBuildinEventGroupRemoteDescriptors(currentBuild);
            if (builtinEventGroupRemoteDescriptors == null || builtinEventGroupRemoteDescriptors.version == null) {
                return false;
            }
            String defaultEventScheme = EventLogMetadataPersistence.readJsonFileContent(defaultFile);
            EventGroupRemoteDescriptors defaultEventGroupRemoteDescriptors = EventLogMetadataPersistence.getEventGroupRemoteDescriptors(defaultEventScheme);
            if (defaultEventGroupRemoteDescriptors == null || defaultEventGroupRemoteDescriptors.version == null) {
                return true;
            }
            return builtinEventGroupRemoteDescriptors.version.compareTo(defaultEventGroupRemoteDescriptors.version) > 0;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    private EventGroupRemoteDescriptors getBuildinEventGroupRemoteDescriptors(@NotNull BuildNumber currentBuild) throws IOException {
        if (currentBuild == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(3);
        }
        EventLogMetadataSettingsPersistence.getInstance().setBuildNumber(this.myRecorderId, currentBuild.asString());
        Path builtinFile = Files.createTempFile("builtin-events-scheme", ".json", new FileAttribute[0]);
        if (this.initBuiltinMetadata(builtinFile)) {
            String builtinEventsScheme = EventLogMetadataPersistence.readJsonFileContent(builtinFile);
            return EventLogMetadataPersistence.getEventGroupRemoteDescriptors(builtinEventsScheme);
        }
        return null;
    }

    @Nullable
    private static String readJsonFileContent(@NotNull Path file) {
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(4);
        }
        try {
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    private static EventGroupRemoteDescriptors getEventGroupRemoteDescriptors(@Nullable String data) {
        try {
            return EventLogMetadataUtils.parseGroupRemoteDescriptors((String)data);
        }
        catch (EventLogMetadataParseException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static RemoteDictionaryList getRemoteDictionaryList(@Nullable String data) {
        try {
            return EventLogMetadataUtils.parseRemoteDictionaryList((String)data);
        }
        catch (EventLogMetadataParseException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public void cacheEventsScheme(@NotNull String eventsSchemeJson, long lastModified) {
        if (eventsSchemeJson == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(5);
        }
        try {
            Path file = this.getDefaultFile();
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)eventsSchemeJson, new OpenOption[0]);
            EventLogMetadataSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean initBuiltinMetadata(@NotNull Path file) throws IOException {
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(6);
        }
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinEventSchemePath());){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            Files.copy(stream, file, StandardCopyOption.REPLACE_EXISTING);
        }
        return true;
    }

    private RemoteDictionaryList readBuiltinDictionaryList() throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinDictionariesPath() + DICTIONARIES_LIST_FILE);){
            if (stream == null) {
                RemoteDictionaryList remoteDictionaryList = null;
                return remoteDictionaryList;
            }
            String content = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            RemoteDictionaryList remoteDictionaryList = EventLogMetadataPersistence.getRemoteDictionaryList(content);
            return remoteDictionaryList;
        }
    }

    private void initAllBuiltinDictionaries(@NotNull Path file) throws IOException {
        RemoteDictionaryList dictionaryList;
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(7);
        }
        if ((dictionaryList = this.readBuiltinDictionaryList()) == null) {
            LOG.trace("Cannot load builtin dictionaries list");
            return;
        }
        for (String dictionary : dictionaryList.dictionaries) {
            this.initSingleBuiltinDictionary(file, dictionary);
        }
    }

    private void initSingleBuiltinDictionary(@NotNull Path dictionariesDir, @NotNull String dictionaryName) throws IOException {
        if (dictionariesDir == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(8);
        }
        if (dictionaryName == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(9);
        }
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinDictionariesPath() + dictionaryName);){
            if (stream == null) {
                return;
            }
            Files.copy(stream, dictionariesDir.resolve(dictionaryName), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinEventSchemePath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/events-scheme.json";
    }

    private String builtinDictionariesPath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/dictionaries/";
    }

    public long getLastModified() {
        return EventLogMetadataSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    public Map<String, Long> getDictionariesLastModified() {
        return EventLogMetadataSettingsPersistence.getInstance().getDictionariesLastModified(this.myRecorderId);
    }

    public void setDictionaryLastModified(String dictionaryName, long lastModified) {
        EventLogMetadataSettingsPersistence.getInstance().setDictionaryLastModified(this.myRecorderId, dictionaryName, lastModified);
    }

    @NotNull
    public Path getDefaultFile() throws IOException {
        Path path = EventLogMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public Path getDefaultDictionariesDir() throws IOException {
        Path path = this.getDefaultFile().getParent().resolve(DICTIONARIES_DIR);
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(11);
        }
        return path;
    }

    private Path getDictionariesPath(boolean shouldInit) throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            return Path.of(settings.getCustomPath(), new String[0]).getParent().resolve(DICTIONARIES_DIR);
        }
        Path path = this.getDefaultDictionariesDir();
        if (shouldInit) {
            this.initDictionaries(path);
        } else if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    public boolean dictionaryAvailable(String dictionaryName) {
        try {
            Path path = this.getDictionariesPath(false);
            Path dictionaryFile = path.resolve(dictionaryName);
            return Files.exists(dictionaryFile, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public synchronized DictionaryStorage getDictionaryStorage() throws IOException {
        if (this.dictionaryStorage != null) {
            return this.dictionaryStorage;
        }
        Path dictionariesDir = this.getDictionariesPath(true);
        this.dictionaryStorage = new SimpleDictionaryStorage(dictionariesDir.toFile(), Dictionary.AccessMode.RANDOM_FILE_ACCESS);
        return this.dictionaryStorage;
    }

    private void initDictionaries(@NotNull Path dictionariesDir) throws IOException {
        if (dictionariesDir == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(12);
        }
        if (Files.notExists(dictionariesDir, new LinkOption[0])) {
            Files.createDirectories(dictionariesDir, new FileAttribute[0]);
            this.initAllBuiltinDictionaries(dictionariesDir);
            return;
        }
        this.overwriteOutdatedLocalDictionaries(dictionariesDir);
    }

    private void overwriteOutdatedLocalDictionaries(@NotNull Path dictionariesDir) throws IOException {
        if (dictionariesDir == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(13);
        }
        Path tempDictionaryDir = Files.createTempDirectory(DICTIONARIES_DIR, new FileAttribute[0]);
        this.initAllBuiltinDictionaries(tempDictionaryDir);
        SimpleDictionaryStorage builtinDictionaryStorage = new SimpleDictionaryStorage(tempDictionaryDir.toFile(), Dictionary.AccessMode.RANDOM_FILE_ACCESS);
        RemoteDictionaryList builtinRemoteDictionaryList = this.readBuiltinDictionaryList();
        if (builtinRemoteDictionaryList == null) {
            return;
        }
        SimpleDictionaryStorage localDictionaryStorage = new SimpleDictionaryStorage(dictionariesDir.toFile(), Dictionary.AccessMode.RANDOM_FILE_ACCESS);
        for (String dictionary : builtinRemoteDictionaryList.dictionaries) {
            String localVersion;
            String builtinVersion = EventLogMetadataPersistence.getDictionaryVersion((DictionaryStorage)builtinDictionaryStorage, dictionary);
            if (builtinVersion == null || (localVersion = EventLogMetadataPersistence.getDictionaryVersion((DictionaryStorage)localDictionaryStorage, dictionary)) != null && builtinVersion.compareTo(localVersion) <= 0) continue;
            this.initSingleBuiltinDictionary(dictionariesDir, dictionary);
        }
    }

    private static String getDictionaryVersion(DictionaryStorage storage, String dictionaryName) {
        try {
            FixedSizedBlockDictionary dictionary = (FixedSizedBlockDictionary)storage.getDictionaryByName(dictionaryName);
            return dictionary.getVersion();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBuild";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsSchemeJson";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionariesDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionaryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSchemeFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDictionariesDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuildinEventGroupRemoteDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readJsonFileContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cacheEventsScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initBuiltinMetadata";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initAllBuiltinDictionaries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initSingleBuiltinDictionary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initDictionaries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "overwriteOutdatedLocalDictionaries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 10, 11 -> new IllegalStateException(string);
        };
    }
}

