/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.StatisticsServiceScope;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.LocalStatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.RecorderOptionProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.logger.StatisticsEventLogThrottleWriter;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.runtime.product.ProductMode;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 =2\u00020\u0001:\u0001=BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000fJ\b\u00101\u001a\u00020\nH&J\b\u00102\u001a\u00020\nH&J\u0006\u00103\u001a\u00020\nJ\b\u00104\u001a\u00020\nH\u0016J\b\u00105\u001a\u0004\u0018\u000106J\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\"H\u0002J\b\u0010<\u001a\u00020\"H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0017R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u001b\u0010'\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010&\u001a\u0004\b(\u0010$R\u001b\u0010*\u001a\u00020+8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010&\u001a\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010$\u00a8\u0006>"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "", "recorderId", "", "version", "", "sendFrequencyMs", "", "maxFileSizeInBytes", "sendLogsOnIdeClose", "", "isCharsEscapingRequired", "useDefaultRecorderId", "<init>", "(Ljava/lang/String;IJIZZZ)V", "(Ljava/lang/String;IJI)V", "getRecorderId", "()Ljava/lang/String;", "getVersion", "()I", "getSendFrequencyMs", "()J", "getSendLogsOnIdeClose", "()Z", "getUseDefaultRecorderId", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "recorderOptionsProvider", "Lcom/intellij/internal/statistic/eventLog/RecorderOptionProvider;", "getRecorderOptionsProvider", "()Lcom/intellij/internal/statistic/eventLog/RecorderOptionProvider;", "localLogger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLocalLogger", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "localLogger$delegate", "Lkotlin/Lazy;", "actualLogger", "getActualLogger", "actualLogger$delegate", "eventLogSystemLogger", "Lcom/intellij/internal/statistic/eventLog/EventLogSystemCollector;", "getEventLogSystemLogger$intellij_platform_statistics", "()Lcom/intellij/internal/statistic/eventLog/EventLogSystemCollector;", "eventLogSystemLogger$delegate", "logger", "getLogger", "isRecordEnabled", "isSendEnabled", "isLoggingEnabled", "isLoggingAlwaysActive", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "createEventsMergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "createLogger", "createLocalLogger", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogger.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n13#2:312\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogger.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider\n*L\n99#1:312\n*E\n"})
public abstract class StatisticsEventLoggerProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    private final int version;
    private final long sendFrequencyMs;
    private final int maxFileSizeInBytes;
    private final boolean sendLogsOnIdeClose;
    private final boolean isCharsEscapingRequired;
    private final boolean useDefaultRecorderId;
    @NotNull
    private final CoroutineScope coroutineScope;
    @ApiStatus.Internal
    @NotNull
    private final RecorderOptionProvider recorderOptionsProvider;
    @NotNull
    private final Lazy localLogger$delegate;
    @NotNull
    private final Lazy actualLogger$delegate;
    @NotNull
    private final Lazy eventLogSystemLogger$delegate;
    @NotNull
    private static final ExtensionPointName<StatisticsEventLoggerProvider> EP_NAME = new ExtensionPointName("com.intellij.statistic.eventLog.eventLoggerProvider");
    public static final int DEFAULT_MAX_FILE_SIZE_BYTES = 204800;
    private static final long DEFAULT_SEND_FREQUENCY_MS = TimeUnit.HOURS.toMillis(1L);
    @NotNull
    private static final Logger LOG;

    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes, boolean sendLogsOnIdeClose, boolean isCharsEscapingRequired, boolean useDefaultRecorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderId = recorderId;
        this.version = version;
        this.sendFrequencyMs = sendFrequencyMs;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.sendLogsOnIdeClose = sendLogsOnIdeClose;
        this.isCharsEscapingRequired = isCharsEscapingRequired;
        this.useDefaultRecorderId = useDefaultRecorderId;
        this.coroutineScope = StatisticsServiceScope.Companion.getScope();
        LOG.info("Initialize event logger provider for '" + this.recorderId + "'");
        EventLogConfigOptionsService configOptionsService = EventLogConfigOptionsService.getInstance();
        Map map = configOptionsService.getOptions(this.recorderId).getAllOptions();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllOptions(...)");
        this.recorderOptionsProvider = new RecorderOptionProvider(map);
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.getCoroutineScope());
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (arg_0, arg_1) -> StatisticsEventLoggerProvider._init_$lambda$0(this, arg_0, arg_1));
        this.localLogger$delegate = LazyKt.lazy(() -> StatisticsEventLoggerProvider.localLogger_delegate$lambda$0(this));
        this.actualLogger$delegate = LazyKt.lazy(() -> StatisticsEventLoggerProvider.actualLogger_delegate$lambda$0(this));
        this.eventLogSystemLogger$delegate = LazyKt.lazy(() -> StatisticsEventLoggerProvider.eventLogSystemLogger_delegate$lambda$0(this));
    }

    public /* synthetic */ StatisticsEventLoggerProvider(String string, int n, long l, int n2, boolean bl, boolean bl2, boolean bl3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x40) != 0) {
            bl3 = false;
        }
        this(string, n, l, n2, bl, bl2, bl3);
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getSendFrequencyMs() {
        return this.sendFrequencyMs;
    }

    public final boolean getSendLogsOnIdeClose() {
        return this.sendLogsOnIdeClose;
    }

    public final boolean isCharsEscapingRequired() {
        return this.isCharsEscapingRequired;
    }

    public final boolean getUseDefaultRecorderId() {
        return this.useDefaultRecorderId;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final RecorderOptionProvider getRecorderOptionsProvider() {
        return this.recorderOptionsProvider;
    }

    @Deprecated(message="Use primary constructor instead")
    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this(recorderId, version, sendFrequencyMs, maxFileSizeInBytes, false, false, false, 96, null);
    }

    private final StatisticsEventLogger getLocalLogger() {
        Lazy lazy = this.localLogger$delegate;
        return (StatisticsEventLogger)lazy.getValue();
    }

    private final StatisticsEventLogger getActualLogger() {
        Lazy lazy = this.actualLogger$delegate;
        return (StatisticsEventLogger)lazy.getValue();
    }

    @NotNull
    public final EventLogSystemCollector getEventLogSystemLogger$intellij_platform_statistics() {
        Lazy lazy = this.eventLogSystemLogger$delegate;
        return (EventLogSystemCollector)lazy.getValue();
    }

    @NotNull
    public StatisticsEventLogger getLogger() {
        return this.isLoggingEnabled() ? this.getActualLogger() : this.getLocalLogger();
    }

    public abstract boolean isRecordEnabled();

    public abstract boolean isSendEnabled();

    public final boolean isLoggingEnabled() {
        return this.isRecordEnabled() || this.isLoggingAlwaysActive();
    }

    public boolean isLoggingAlwaysActive() {
        return false;
    }

    @Nullable
    public final EventLogFile getActiveLogFile() {
        return this.getLogger().getActiveLogFile();
    }

    @NotNull
    public final EventLogFilesProvider getLogFilesProvider() {
        return this.getLogger().getLogFilesProvider();
    }

    @NotNull
    public StatisticsEventMergeStrategy createEventsMergeStrategy() {
        return new FilteredEventMergeStrategy(SetsKt.emptySet());
    }

    private final StatisticsEventLogger createLogger() {
        Application app = ApplicationManager.getApplication();
        boolean isEap = app != null && app.isEAP();
        boolean isHeadless = app != null && app.isHeadlessEnvironment();
        String ideMode = AppMode.isRemoteDevHost() ? "RDH" : null;
        String currentProductModeId = ProductLoadingStrategy.Companion.getStrategy().getCurrentModeId();
        String productMode = PlatformUtils.isQodana() ? null : (!Intrinsics.areEqual((Object)currentProductModeId, (Object)ProductMode.MONOLITH.getId()) ? currentProductModeId : (StatisticsEventLoggerKt.access$detectClionNova() ? "nova" : null));
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        EventLogRecorderConfiguration config = eventLogConfiguration.getOrCreate(this.recorderId, this.useDefaultRecorderId ? "FUS" : null);
        StatisticsEventLogFileWriter writer = new StatisticsEventLogFileWriter(this.recorderId, this, this.maxFileSizeInBytes, isEap, eventLogConfiguration.getBuild());
        EventLogConfigOptionsService configService = EventLogConfigOptionsService.getInstance();
        Intrinsics.checkNotNull((Object)configService);
        StatisticsEventLogThrottleWriter throttledWriter = new StatisticsEventLogThrottleWriter(configService, this.recorderId, String.valueOf(this.version), writer, this.getCoroutineScope());
        String string = config.getSessionId();
        String string2 = eventLogConfiguration.getBuild();
        String string3 = String.valueOf(config.getBucket());
        String string4 = String.valueOf(this.version);
        StatisticsEventLogWriter statisticsEventLogWriter = throttledWriter;
        UsageStatisticsPersistenceComponent usageStatisticsPersistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)usageStatisticsPersistenceComponent, (String)"getInstance(...)");
        StatisticsFileEventLogger logger = new StatisticsFileEventLogger(this.recorderId, string, isHeadless, string2, string3, string4, statisticsEventLogWriter, usageStatisticsPersistenceComponent, this.createEventsMergeStrategy(), ideMode, productMode);
        JobKt.getJob((CoroutineContext)this.getCoroutineScope().getCoroutineContext()).invokeOnCompletion(arg_0 -> StatisticsEventLoggerProvider.createLogger$lambda$0(logger, arg_0));
        return logger;
    }

    private final StatisticsEventLogger createLocalLogger() {
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        LocalStatisticsFileEventLogger logger = new LocalStatisticsFileEventLogger(this.recorderId, eventLogConfiguration.getBuild(), String.valueOf(this.version), this.createEventsMergeStrategy(), this.getCoroutineScope());
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)logger);
        return logger;
    }

    private static final void _init_$lambda$0(StatisticsEventLoggerProvider this$0, String changedRecorder, Map options) {
        Intrinsics.checkNotNullParameter((Object)changedRecorder, (String)"changedRecorder");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (Intrinsics.areEqual((Object)changedRecorder, (Object)this$0.recorderId)) {
            this$0.recorderOptionsProvider.update(options);
        }
    }

    private static final StatisticsEventLogger localLogger_delegate$lambda$0(StatisticsEventLoggerProvider this$0) {
        return this$0.createLocalLogger();
    }

    private static final StatisticsEventLogger actualLogger_delegate$lambda$0(StatisticsEventLoggerProvider this$0) {
        return this$0.createLogger();
    }

    private static final EventLogSystemCollector eventLogSystemLogger_delegate$lambda$0(StatisticsEventLoggerProvider this$0) {
        return new EventLogSystemCollector(this$0);
    }

    private static final Unit createLogger$lambda$0(StatisticsFileEventLogger $logger, Throwable it) {
        Disposer.dispose((Disposable)$logger);
        return Unit.INSTANCE;
    }

    @NotNull
    public static final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
        return Companion.getEP_NAME();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StatisticsEventLoggerProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "DEFAULT_MAX_FILE_SIZE_BYTES", "", "DEFAULT_SEND_FREQUENCY_MS", "", "getDEFAULT_SEND_FREQUENCY_MS", "()J", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "parseFileSize", "maxFileSize", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        public final long getDEFAULT_SEND_FREQUENCY_MS() {
            return DEFAULT_SEND_FREQUENCY_MS;
        }

        public final int parseFileSize(@NotNull String maxFileSize) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)maxFileSize, (String)"maxFileSize");
            int length = maxFileSize.length();
            if (length < 3) {
                LOG.warn("maxFileSize should contain measurement unit: " + maxFileSize);
                return 204800;
            }
            String string = maxFileSize.substring(0, length - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            try {
                n2 = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Unable to parse maxFileSize for FUS log file: " + maxFileSize);
                return 204800;
            }
            int size = n2;
            String string2 = maxFileSize.substring(length - 2, length);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            switch (string2) {
                case "KB": {
                    n = 1024;
                    break;
                }
                case "MB": {
                    n = 0x100000;
                    break;
                }
                case "GB": {
                    n = 0x40000000;
                    break;
                }
                default: {
                    LOG.warn("Unable to parse measurement unit of maxFileSize for FUS log file: " + maxFileSize);
                    return 204800;
                }
            }
            int multiplier = n;
            return size * multiplier;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

