/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.CustomRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesStorageHolder;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogTestMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.jetbrains.fus.reporting.MetadataStorage;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationTestRulesPersistedStorage
implements IntellijValidationRulesStorage {
    private final ConcurrentMap<String, EventGroupRules> eventsValidators;
    private final ConcurrentMap<String, EventGroupRules> customPathEventsValidators;
    private final Object myLock;
    @NotNull
    private final EventLogTestMetadataPersistence myTestMetadataPersistence;
    @NotNull
    private final EventLogMetadataPersistence myMetadataPersistence;
    @NotNull
    private final String myRecorderId;
    @NotNull
    private final AtomicBoolean myIsInitialized;
    @NotNull
    private final AtomicBoolean hasCustomPathMetadata;

    ValidationTestRulesPersistedStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.customPathEventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myLock = new Object();
        this.myRecorderId = recorderId;
        this.myIsInitialized = new AtomicBoolean(false);
        this.hasCustomPathMetadata = new AtomicBoolean(false);
        this.myTestMetadataPersistence = new EventLogTestMetadataPersistence(recorderId);
        this.myMetadataPersistence = new EventLogMetadataPersistence(recorderId);
        this.updateValidators();
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        EventGroupRules result;
        if (groupId == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(1);
        }
        if ((result = (EventGroupRules)this.eventsValidators.get(groupId)) != null || !this.hasCustomPathMetadata.get()) {
            return result;
        }
        return (EventGroupRules)this.customPathEventsValidators.get(groupId);
    }

    @Override
    public boolean update() {
        this.updateValidators();
        return true;
    }

    @Override
    public void reload() {
        this.updateValidators();
    }

    @Override
    public boolean isUnreachable() {
        return !this.myIsInitialized.get();
    }

    public boolean hasCustomPathMetadata() {
        return this.hasCustomPathMetadata.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValidators() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.customPathEventsValidators.clear();
            this.myIsInitialized.set(false);
            EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
            this.hasCustomPathMetadata.set(settings != null && settings.isUseCustomPath());
            EventGroupRemoteDescriptors productionGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myMetadataPersistence);
            EventGroupRemoteDescriptors testGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myTestMetadataPersistence);
            Map<String, EventGroupRules> result = this.createValidators(testGroups, productionGroups.rules);
            this.eventsValidators.putAll(result);
            if (this.hasCustomPathMetadata.get()) {
                Map<String, EventGroupRules> customMetadata = this.createValidators(productionGroups);
                this.customPathEventsValidators.putAll(customMetadata);
            }
            this.myIsInitialized.set(true);
        }
    }

    @NotNull
    public EventGroupRemoteDescriptors loadProductionGroups() {
        EventGroupRemoteDescriptors eventGroupRemoteDescriptors = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myMetadataPersistence);
        if (eventGroupRemoteDescriptors == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(2);
        }
        return eventGroupRemoteDescriptors;
    }

    @NotNull
    public static Map<String, EventGroupRules> createValidators(@Nullable EventLogBuild build, @NotNull EventGroupRemoteDescriptors groups, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull String recorderId, DictionaryStorage dictionaryStorage) {
        if (groups == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(3);
        }
        if (globalRulesHolder == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(4);
        }
        if (recorderId == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(5);
        }
        ValidationSimpleRuleFactory ruleFactory = new ValidationSimpleRuleFactory((UtilRuleProducer)new CustomRuleProducer(recorderId));
        Map<String, EventGroupRules> map = groups.groups.stream().filter(group -> EventGroupFilterRules.create((EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)group, (EventLogBuildParser)EventLogBuild.EVENT_LOG_BUILD_PRODUCER).accepts((Comparable)build)).collect(Collectors.toMap(group -> group.id, group -> EventGroupRules.create((EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)group, (GlobalRulesHolder)globalRulesHolder, (ValidationSimpleRuleFactory)ruleFactory, FeatureUsageData.Companion.getPlatformDataKeys(), (DictionaryStorage)dictionaryStorage)));
        if (map == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    private Map<String, EventGroupRules> createValidators(@NotNull EventGroupRemoteDescriptors groups, @Nullable EventGroupRemoteDescriptors.GroupRemoteRule productionRules) {
        if (groups == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(7);
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rules = ValidationTestRulesPersistedStorage.merge(groups.rules, productionRules);
        GlobalRulesHolder globalRulesHolder = new GlobalRulesHolder(rules);
        EventLogBuild build = EventLogBuild.fromString((String)EventLogConfiguration.getInstance().getBuild());
        return ValidationTestRulesPersistedStorage.createValidators(build, groups, globalRulesHolder, this.myRecorderId, this.getDictionaryStorage());
    }

    @NotNull
    private Map<String, EventGroupRules> createValidators(@NotNull EventGroupRemoteDescriptors groups) {
        if (groups == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(8);
        }
        GlobalRulesHolder globalRulesHolder = new GlobalRulesHolder(groups.rules);
        EventLogBuild build = EventLogBuild.fromString((String)EventLogConfiguration.getInstance().getBuild());
        return ValidationTestRulesPersistedStorage.createValidators(build, groups, globalRulesHolder, this.myRecorderId, this.getDictionaryStorage());
    }

    public void addTestGroup(@NotNull GroupValidationTestRule group) throws IOException {
        if (group == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(9);
        }
        EventLogTestMetadataPersistence.addTestGroup(this.myRecorderId, group);
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.customPathEventsValidators.clear();
            this.myTestMetadataPersistence.cleanup();
        }
    }

    @NotNull
    public List<GroupValidationTestRule> loadValidationTestRules() throws JsonProcessingException {
        ArrayList testGroupsSchemes = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes((BaseEventLogMetadataPersistence)this.myTestMetadataPersistence).groups;
        ArrayList<GroupValidationTestRule> groups = new ArrayList<GroupValidationTestRule>();
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group : testGroupsSchemes) {
            if (group.id == null || group.rules == null || group.rules.event_id == null) continue;
            Set eventIds = group.rules.event_id;
            if (eventIds.contains("{util#fus_test_mode}")) {
                groups.add(new GroupValidationTestRule(group.id, false));
                continue;
            }
            groups.add(new GroupValidationTestRule(group.id, true, SerializationHelper.INSTANCE.serialize((Object)group.rules)));
        }
        ArrayList<GroupValidationTestRule> arrayList = groups;
        if (arrayList == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public void updateTestGroups(@NotNull List<GroupValidationTestRule> groups) throws IOException {
        if (groups == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(11);
        }
        this.myTestMetadataPersistence.updateTestGroups(groups);
        this.updateValidators();
    }

    @Override
    @Nullable
    public DictionaryStorage getDictionaryStorage() {
        return null;
    }

    @Nullable
    private static EventGroupRemoteDescriptors.GroupRemoteRule merge(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule testRules, @Nullable EventGroupRemoteDescriptors.GroupRemoteRule productionTestRules) {
        if (testRules == null) {
            return productionTestRules;
        }
        if (productionTestRules == null) {
            return testRules;
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rule = new EventGroupRemoteDescriptors.GroupRemoteRule();
        ValidationTestRulesPersistedStorage.copyRules(rule, productionTestRules);
        ValidationTestRulesPersistedStorage.copyRules(rule, testRules);
        return rule;
    }

    private static void copyRules(@NotNull EventGroupRemoteDescriptors.GroupRemoteRule to, @NotNull EventGroupRemoteDescriptors.GroupRemoteRule from) {
        if (to == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(12);
        }
        if (from == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(13);
        }
        if (to.getEnums() == null) {
            to.setEnums(new HashMap());
        }
        if (to.regexps == null) {
            to.regexps = new HashMap();
        }
        if (from.getEnums() != null) {
            to.getEnums().putAll(from.getEnums());
        }
        if (from.regexps != null) {
            to.regexps.putAll(from.regexps);
        }
    }

    public static void cleanupAll() {
        List<String> recorders = StatisticsEventLogProviderUtil.getEventLogProviders().stream().filter(provider -> provider.isRecordEnabled()).map(provider -> provider.getRecorderId()).collect(Collectors.toList());
        ValidationTestRulesPersistedStorage.cleanupAll(recorders);
    }

    public static void cleanupAll(List<String> recorders) {
        for (String recorderId : recorders) {
            ValidationTestRulesPersistedStorage testStorage = ValidationTestRulesPersistedStorage.getTestStorage(recorderId, false);
            if (testStorage == null) continue;
            testStorage.cleanup();
        }
    }

    @Nullable
    public static ValidationTestRulesPersistedStorage getTestStorage(@NotNull String recorderId, boolean initIfNeeded) {
        if (recorderId == null) {
            ValidationTestRulesPersistedStorage.$$$reportNull$$$0(14);
        }
        IntellijSensitiveDataValidator validator = initIfNeeded ? IntellijSensitiveDataValidator.getInstance(recorderId) : IntellijSensitiveDataValidator.getIfInitialized(recorderId);
        MetadataStorage storage = validator != null ? validator.getValidationRulesStorage() : null;
        return storage instanceof ValidationTestRulesStorageHolder ? ((ValidationTestRulesStorageHolder)storage).getTestGroupStorage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.myLock;
        synchronized (object) {
            return this.eventsValidators.size();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRulesHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProductionGroups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadValidationTestRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupRules";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateTestGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyRules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTestStorage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 10 -> new IllegalStateException(string);
        };
    }
}

