/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.logical.impl;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.logical.ExternalElementsProvider;
import com.intellij.ide.structureView.logical.impl.ElementsBuilder;
import com.intellij.ide.structureView.logical.model.ExtendedLogicalObject;
import com.intellij.ide.structureView.logical.model.LogicalPsiDescription;
import com.intellij.psi.PsiElement;
import com.intellij.ui.tree.TreeVisitor;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/structureView/logical/impl/LogicalStructureElementsVisitor;", "", "<init>", "()V", "visitPathForLogicalElementSelection", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "treeElement", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "element", "psiDescriptions", "", "Lcom/intellij/ide/structureView/logical/model/LogicalPsiDescription;", "intellij.platform.structureView.impl"})
@ApiStatus.Internal
public final class LogicalStructureElementsVisitor {
    @NotNull
    public static final LogicalStructureElementsVisitor INSTANCE = new LogicalStructureElementsVisitor();

    private LogicalStructureElementsVisitor() {
    }

    @NotNull
    public final TreeVisitor.Action visitPathForLogicalElementSelection(@NotNull StructureViewTreeElement treeElement, @Nullable Object element, @NotNull Set<? extends LogicalPsiDescription> psiDescriptions) {
        LogicalPsiDescription logicalPsiDescription;
        block11: {
            Intrinsics.checkNotNullParameter((Object)treeElement, (String)"treeElement");
            Intrinsics.checkNotNullParameter(psiDescriptions, (String)"psiDescriptions");
            if (!(element instanceof PsiElement)) {
                return TreeVisitor.Action.SKIP_CHILDREN;
            }
            if (treeElement instanceof ElementsBuilder.LogicalGroupStructureElement) {
                if (((ElementsBuilder.LogicalGroupStructureElement)treeElement).getGrouper() instanceof ExternalElementsProvider) {
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
                return TreeVisitor.Action.CONTINUE;
            }
            if (treeElement instanceof ElementsBuilder.OtherStructureElement) {
                return TreeVisitor.Action.CONTINUE;
            }
            for (LogicalPsiDescription it : (Iterable)psiDescriptions) {
                boolean bl = false;
                if ((it = it.getSuitableElement((PsiElement)element)) == null) continue;
                logicalPsiDescription = it;
                break block11;
            }
            logicalPsiDescription = null;
        }
        if (logicalPsiDescription == null) {
            return TreeVisitor.Action.SKIP_CHILDREN;
        }
        LogicalPsiDescription targetElement = logicalPsiDescription;
        if (treeElement instanceof ElementsBuilder.PsiElementStructureElement) {
            if (Intrinsics.areEqual(((ElementsBuilder.PsiElementStructureElement)treeElement).getElement(), targetElement)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            Object t = ((ElementsBuilder.PsiElementStructureElement)treeElement).getLogicalAssembledModel().getModel();
            ExtendedLogicalObject extendedLogicalObject = t instanceof ExtendedLogicalObject ? (ExtendedLogicalObject)t : null;
            if (extendedLogicalObject != null) {
                ExtendedLogicalObject it = extendedLogicalObject;
                boolean bl = false;
                if (it.canRepresentPsiElement((PsiElement)targetElement)) {
                    return TreeVisitor.Action.INTERRUPT;
                }
            }
            Object t2 = ((ElementsBuilder.PsiElementStructureElement)treeElement).getElement();
            if (!Intrinsics.areEqual((Object)(t2 != null ? t2.getContainingFile() : null), (Object)targetElement.getContainingFile())) {
                return TreeVisitor.Action.SKIP_CHILDREN;
            }
            return TreeVisitor.Action.CONTINUE;
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }
}

