/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance(CachingChildrenTreeNode.class);
    private List<CachingChildrenTreeNode<?>> myChildren;
    private List<CachingChildrenTreeNode<?>> myOldChildren;
    @NotNull
    protected final TreeModel myTreeModel;

    CachingChildrenTreeNode(Project project, @NotNull Value value, @NotNull TreeModel treeModel) {
        if (value == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(1);
        }
        super(project, value instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value).getWrappedElement() : value);
        this.myTreeModel = treeModel;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        this.ensureChildrenAreInitialized();
        return new ArrayList(this.myChildren);
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            try {
                this.myChildren = new ArrayList();
                this.rebuildSubtree();
            }
            catch (ProcessCanceledException | IndexNotReadyException pce) {
                this.myChildren = null;
                throw pce;
            }
        }
    }

    void addSubElement(@NotNull CachingChildrenTreeNode node) {
        JBIterable parents;
        if (node == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(2);
        }
        if ((parents = JBIterable.generate((Object)((Object)this), o -> o.getParent())).map(o -> o.getValue()).contains(node.getValue())) {
            return;
        }
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(@NotNull Collection<? extends AbstractTreeNode<?>> children) {
        if (children == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(3);
        }
        this.clearChildren();
        for (AbstractTreeNode<?> node : children) {
            this.myChildren.add((CachingChildrenTreeNode)node);
            node.setParent((AbstractTreeNode)this);
        }
    }

    protected void sortChildren(Sorter @NotNull [] sorters) {
        if (sorters == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(4);
        }
        if (this.myChildren == null) {
            return;
        }
        this.myChildren.sort(new CompositeComparator(sorters));
        for (CachingChildrenTreeNode<?> child : this.myChildren) {
            if (!(child instanceof GroupWrapper)) continue;
            child.sortChildren(sorters);
        }
    }

    protected void filterChildren(Filter @NotNull [] filters) {
        if (filters == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(5);
        }
        Collection<AbstractTreeNode<?>> children = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode<?>> eachNode = children.iterator();
            while (eachNode.hasNext()) {
                AbstractTreeNode<?> eachChild = eachNode.next();
                Object value = eachChild.getValue();
                if (value instanceof TreeElement && filter.isVisible((TreeElement)value)) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children);
    }

    void groupChildren(Grouper @NotNull [] groupers) {
        if (groupers == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(6);
        }
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode<?>> children = this.getChildren();
        for (AbstractTreeNode<?> child : children) {
            if (!(child instanceof GroupWrapper)) continue;
            ((GroupWrapper)child).groupChildren(groupers);
        }
    }

    private void groupElements(@NotNull Grouper grouper) {
        if (grouper == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(7);
        }
        ArrayList ungrouped = new ArrayList();
        Collection<AbstractTreeNode<?>> children = this.getChildren();
        for (AbstractTreeNode<?> child : children) {
            if (!(child instanceof TreeElementWrapper)) continue;
            ungrouped.add(child);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (AbstractTreeNode<?> child : children) {
            AbstractTreeNode parent = child.getParent();
            if (parent != this) {
                if (result.contains(parent)) continue;
                result.add(parent);
                continue;
            }
            result.add(child);
        }
        this.setChildren(result);
    }

    private void processUngrouped(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped, @NotNull Grouper grouper) {
        if (ungrouped == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(8);
        }
        if (grouper == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(9);
        }
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection groups = grouper.group((AbstractTreeNode)this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups);
        for (Group group : groups) {
            if (group == null) {
                LOG.error(String.valueOf(grouper) + " returned null group: " + String.valueOf(groups));
            }
            GroupWrapper groupWrapper = groupNodes.get(group);
            Collection children = group.getChildren();
            for (TreeElement node : children) {
                if (node == null) {
                    LOG.error(String.valueOf(group) + " returned null child: " + String.valueOf(children));
                }
                TreeElementWrapper child = this.createChildNode(node);
                groupWrapper.addSubElement(child);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent((AbstractTreeNode)groupWrapper);
            }
        }
    }

    @NotNull
    protected TreeElementWrapper createChildNode(@NotNull TreeElement child) {
        if (child == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(10);
        }
        return new TreeElementWrapper(this.getProject(), child, this.myTreeModel);
    }

    @NotNull
    private static Map<TreeElement, AbstractTreeNode> collectValues(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped) {
        if (ungrouped == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(11);
        }
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> abstractTreeNode : ungrouped) {
            objects.put((TreeElement)abstractTreeNode.getValue(), abstractTreeNode);
        }
        LinkedHashMap<TreeElement, AbstractTreeNode> linkedHashMap = objects;
        if (linkedHashMap == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @NotNull
    private Map<Group, GroupWrapper> createGroupNodes(@NotNull Collection<? extends Group> groups) {
        if (groups == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(13);
        }
        Map result = CollectionFactory.createSmallMemoryFootprintMap((int)groups.size());
        for (Group group : groups) {
            result.put(group, this.createGroupWrapper(this.getProject(), group, this.myTreeModel));
        }
        Map map = result;
        if (map == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group, @NotNull TreeModel treeModel) {
        if (group == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(15);
        }
        if (treeModel == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(16);
        }
        return new GroupWrapper(project, group, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    void synchronizeChildren() {
        List<CachingChildrenTreeNode<?>> children = this.myChildren;
        if (this.myOldChildren != null && children != null) {
            HashMap oldValuesToChildrenMap = new HashMap();
            for (CachingChildrenTreeNode<?> oldChild : this.myOldChildren) {
                Object oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put((CachingChildrenTreeNode<?>)((Object)oldValue), oldChild);
            }
            for (int i = 0; i < children.size(); ++i) {
                CachingChildrenTreeNode oldChild;
                Object newValue;
                CachingChildrenTreeNode<?> newChild = children.get(i);
                Object object = newValue = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue == null || (oldChild = (CachingChildrenTreeNode)((Object)oldValuesToChildrenMap.get(newValue))) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                children.set(i, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(@NotNull CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    public boolean isAutoExpandAllowed() {
        Object object = this.myTreeModel;
        if (object instanceof StructureViewModel.ExpandInfoProvider) {
            StructureViewModel.ExpandInfoProvider expandInfoProvider = (StructureViewModel.ExpandInfoProvider)object;
            object = this.getValue();
            if (object instanceof StructureViewTreeElement) {
                StructureViewTreeElement structureViewTreeElement = (StructureViewTreeElement)object;
                return expandInfoProvider.isAutoExpand(structureViewTreeElement);
            }
        }
        return super.isAutoExpandAllowed();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList();
        }
    }

    void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode<?> node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupers";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ungrouped";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSubElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUngrouped";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createChildNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNodes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWrapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14 -> new IllegalStateException(string);
        };
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        CompositeComparator(Sorter @NotNull [] sorters) {
            if (sorters == null) {
                CompositeComparator.$$$reportNull$$$0(0);
            }
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result = sorter.getComparator().compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorters", "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode$CompositeComparator", "<init>"));
        }
    }
}

