/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.util.lexer;

import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.logger.NoopLogger;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.platform.syntax.util.lexer.StringEscapesTokenTypes;
import com.intellij.platform.syntax.util.lexer.StringLiteralLexerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001b\b\u0017\u0018\u0000 62\u00020\u0001:\u00016BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0014J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0015H\u0004J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020\u0015H\u0016J\b\u0010,\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015H\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015H\u0014J\u0018\u00101\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015H\u0014J\u0018\u00102\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015H\u0014J\b\u00103\u001a\u00020\u001cH\u0016J\b\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0014\u0010&\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011\u00a8\u00067"}, d2={"Lcom/intellij/platform/syntax/util/lexer/StringLiteralLexer;", "Lcom/intellij/platform/syntax/util/lexer/LexerBase;", "quoteChar", "", "originalLiteralToken", "Lcom/intellij/platform/syntax/SyntaxElementType;", "canEscapeEolOrFramingSpaces", "", "additionalValidEscapes", "", "allowOctal", "allowHex", "<init>", "(CLcom/intellij/platform/syntax/SyntaxElementType;ZLjava/lang/String;ZZ)V", "getQuoteChar", "()C", "getOriginalLiteralToken", "()Lcom/intellij/platform/syntax/SyntaxElementType;", "buffer", "", "startOffset", "", "endOffset", "bufferEnd", "lastState", "state", "seenEscapedSpacesOnly", "start", "", "initialState", "getState", "getTokenType", "shouldAllowSlashZero", "getShouldAllowSlashZero", "()Z", "handleSingleSlashEscapeSequence", "hexCodedEscapeSeq", "getHexCodedEscapeSeq", "unicodeEscapeSequenceType", "getUnicodeEscapeSequenceType", "getStandardLimitedHexCodedEscapeSeq", "offsetLimit", "isTrailingSpace", "getTokenStart", "getTokenEnd", "locateToken", "locateOctalEscapeSequence", "i", "locateHexEscapeSequence", "locateUnicodeEscapeSequence", "locateAdditionalEscapeSequence", "advance", "getBufferSequence", "getBufferEnd", "Companion", "intellij.platform.syntax.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nStringLiteralLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringLiteralLexer.kt\ncom/intellij/platform/syntax/util/lexer/StringLiteralLexer\n+ 2 StringLiteralLexer.kt\ncom/intellij/platform/syntax/util/lexer/StringLiteralLexerKt\n*L\n1#1,251:1\n231#2,9:252\n231#2,9:261\n*S KotlinDebug\n*F\n+ 1 StringLiteralLexer.kt\ncom/intellij/platform/syntax/util/lexer/StringLiteralLexer\n*L\n133#1:252,9\n150#1:261,9\n*E\n"})
public class StringLiteralLexer
extends LexerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char quoteChar;
    @NotNull
    private final SyntaxElementType originalLiteralToken;
    private final boolean canEscapeEolOrFramingSpaces;
    @Nullable
    private final String additionalValidEscapes;
    private final boolean allowOctal;
    private final boolean allowHex;
    private CharSequence buffer;
    private int startOffset;
    private int endOffset;
    private int bufferEnd;
    private int lastState;
    private int state;
    private boolean seenEscapedSpacesOnly;
    private static final int AFTER_FIRST_QUOTE = 1;
    private static final int AFTER_LAST_QUOTE = 2;
    public static final char NO_QUOTE_CHAR = '\uffff';
    @NotNull
    private static final Logger LOG = NoopLogger.noopLogger();

    public StringLiteralLexer(char quoteChar, @NotNull SyntaxElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, @Nullable String additionalValidEscapes, boolean allowOctal, boolean allowHex) {
        this.quoteChar = quoteChar;
        this.originalLiteralToken = originalLiteralToken;
        this.canEscapeEolOrFramingSpaces = canEscapeEolOrFramingSpaces;
        this.additionalValidEscapes = additionalValidEscapes;
        this.allowOctal = allowOctal;
        this.allowHex = allowHex;
    }

    public /* synthetic */ StringLiteralLexer(char c, SyntaxElementType syntaxElementType, boolean bl, String string, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        this(c, syntaxElementType, bl, string, bl2, bl3);
    }

    protected final char getQuoteChar() {
        return this.quoteChar;
    }

    @NotNull
    protected final SyntaxElementType getOriginalLiteralToken() {
        return this.originalLiteralToken;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.buffer = buffer;
        this.startOffset = startOffset;
        this.state = this.quoteChar == '\uffff' ? 1 : initialState;
        this.lastState = initialState;
        this.bufferEnd = endOffset;
        this.endOffset = this.locateToken(this.startOffset);
        this.seenEscapedSpacesOnly = true;
    }

    public int getState() {
        return this.lastState;
    }

    @Nullable
    public SyntaxElementType getTokenType() {
        if (this.startOffset >= this.endOffset) {
            return null;
        }
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            charSequence = null;
        }
        if (charSequence.charAt(this.startOffset) != '\\') {
            this.seenEscapedSpacesOnly = false;
            return this.originalLiteralToken;
        }
        if (this.startOffset + 1 >= this.endOffset) {
            return this.handleSingleSlashEscapeSequence();
        }
        CharSequence charSequence2 = this.buffer;
        if (charSequence2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            charSequence2 = null;
        }
        char nextChar = charSequence2.charAt(this.startOffset + 1);
        boolean bl = this.seenEscapedSpacesOnly = this.seenEscapedSpacesOnly && nextChar == ' ';
        if (this.canEscapeEolOrFramingSpaces && (nextChar == '\n' || nextChar == ' ' && (this.seenEscapedSpacesOnly || this.isTrailingSpace(this.startOffset + 2)))) {
            return StringEscapesTokenTypes.INSTANCE.getVALID_STRING_ESCAPE_TOKEN();
        }
        if (nextChar == 'u') {
            return this.getUnicodeEscapeSequenceType();
        }
        if (nextChar == 'x' && this.allowHex) {
            return this.getHexCodedEscapeSeq();
        }
        char c = nextChar;
        if (c == '0') {
            if (this.getShouldAllowSlashZero()) {
                return StringEscapesTokenTypes.INSTANCE.getVALID_STRING_ESCAPE_TOKEN();
            }
        } else {
            boolean bl2 = '1' <= c ? c < '8' : false;
            if (bl2) {
                if (!this.allowOctal) {
                    return StringEscapesTokenTypes.INSTANCE.getINVALID_CHARACTER_ESCAPE_TOKEN();
                }
            } else if (c == 'n' || c == 'r' || c == 'b' || c == 't' || c == 'f' || c == '\'' || c == '\"' || c == '\\') {
                return StringEscapesTokenTypes.INSTANCE.getVALID_STRING_ESCAPE_TOKEN();
            }
        }
        if (this.additionalValidEscapes != null && StringsKt.contains((CharSequence)this.additionalValidEscapes, (char)nextChar, (boolean)false)) {
            return StringEscapesTokenTypes.INSTANCE.getVALID_STRING_ESCAPE_TOKEN();
        }
        return StringEscapesTokenTypes.INSTANCE.getINVALID_CHARACTER_ESCAPE_TOKEN();
    }

    protected boolean getShouldAllowSlashZero() {
        return false;
    }

    @NotNull
    protected SyntaxElementType handleSingleSlashEscapeSequence() {
        return StringEscapesTokenTypes.INSTANCE.getINVALID_CHARACTER_ESCAPE_TOKEN();
    }

    @NotNull
    protected SyntaxElementType getHexCodedEscapeSeq() {
        return this.getStandardLimitedHexCodedEscapeSeq(4);
    }

    @NotNull
    protected SyntaxElementType getUnicodeEscapeSequenceType() {
        return this.getStandardLimitedHexCodedEscapeSeq(6);
    }

    @NotNull
    protected final SyntaxElementType getStandardLimitedHexCodedEscapeSeq(int offsetLimit) {
        int n = this.startOffset + offsetLimit;
        for (int i = this.startOffset + 2; i < n; ++i) {
            if (i < this.endOffset) {
                CharSequence charSequence = this.buffer;
                if (charSequence == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    charSequence = null;
                }
                if (StringLiteralLexerKt.isHexDigit(charSequence.charAt(i))) continue;
            }
            return StringEscapesTokenTypes.INSTANCE.getINVALID_UNICODE_ESCAPE_TOKEN();
        }
        return StringEscapesTokenTypes.INSTANCE.getVALID_STRING_ESCAPE_TOKEN();
    }

    private final boolean isTrailingSpace(int start) {
        for (int i = start; i < this.bufferEnd; i += 2) {
            CharSequence charSequence = this.buffer;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                charSequence = null;
            }
            char chr = charSequence.charAt(i);
            if (chr != '\\') {
                return false;
            }
            if (i == this.bufferEnd - 1) {
                return false;
            }
            CharSequence charSequence2 = this.buffer;
            if (charSequence2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                charSequence2 = null;
            }
            if (charSequence2.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public int getTokenStart() {
        return this.startOffset;
    }

    public int getTokenEnd() {
        return this.endOffset;
    }

    /*
     * Unable to fully structure code
     */
    private final int locateToken(int start) {
        block21: {
            block24: {
                block25: {
                    block23: {
                        block22: {
                            if (start == this.bufferEnd) {
                                this.state = 2;
                            }
                            if (this.state == 2) {
                                return start;
                            }
                            i = start;
                            v0 = this.buffer;
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                                v0 = null;
                            }
                            if (v0.charAt(i) != '\\') break block21;
                            var3_3 = StringLiteralLexer.LOG;
                            condition$iv = this.state != 2;
                            $i$f$assertTrue = false;
                            if (!condition$iv) {
                                $this$assertTrue_u24lambda_u240$iv = var6_11 = new StringBuilder();
                                $i$a$-buildString-StringLiteralLexerKt$assertTrue$message$1$iv = false;
                                $this$assertTrue_u24lambda_u240$iv.append("Assertion failed");
                                $this$assertTrue_u24lambda_u240$iv.append(": ");
                                var11_17 = $this$assertTrue_u24lambda_u240$iv;
                                $i$a$-assertTrue-StringLiteralLexer$locateToken$1 = false;
                                var11_17.append(this.toString());
                                message$iv = var6_11.toString();
                                $this$assertTrue$iv.error(message$iv);
                            }
                            if (++i == this.bufferEnd) break block22;
                            v1 = this.buffer;
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                                v1 = null;
                            }
                            if (v1.charAt(i) != '\n' || this.canEscapeEolOrFramingSpaces) break block23;
                        }
                        this.state = 2;
                        v2 = i;
                        break block24;
                    }
                    if (!this.allowOctal) break block25;
                    v3 = this.buffer;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                        v3 = null;
                    }
                    v4 = '0' <= ($this$assertTrue$iv = v3.charAt(i)) ? $this$assertTrue$iv < '8' : false;
                    if (!v4) break block25;
                    v2 = this.locateOctalEscapeSequence(i);
                    break block24;
                }
                if (!this.allowHex) ** GOTO lbl-1000
                v5 = this.buffer;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    v5 = null;
                }
                if (v5.charAt(i) == 'x') {
                    v2 = this.locateHexEscapeSequence(start, i);
                } else lbl-1000:
                // 2 sources

                {
                    if ((v6 = this.buffer) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                        v6 = null;
                    }
                    v2 = v6.charAt(i) == 'u' ? this.locateUnicodeEscapeSequence(start, i) : ((additionalLocation = this.locateAdditionalEscapeSequence(start, i)) != -1 ? additionalLocation : i + 1);
                }
            }
            return v2;
        }
        additionalLocation = StringLiteralLexer.LOG;
        if (this.state == 2) ** GOTO lbl-1000
        v7 = this.buffer;
        if (v7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            v7 = null;
        }
        if (v7.charAt(i) == this.quoteChar) lbl-1000:
        // 2 sources

        {
            v8 = true;
        } else {
            v8 = false;
        }
        condition$iv = v8;
        $i$f$assertTrue = false;
        if (!condition$iv) {
            $this$assertTrue_u24lambda_u240$iv = var6_12 = new StringBuilder();
            $i$a$-buildString-StringLiteralLexerKt$assertTrue$message$1$iv = false;
            $this$assertTrue_u24lambda_u240$iv.append("Assertion failed");
            $this$assertTrue_u24lambda_u240$iv.append(": ");
            var11_18 = $this$assertTrue_u24lambda_u240$iv;
            $i$a$-assertTrue-StringLiteralLexer$locateToken$2 = false;
            var11_18.append(this.toString());
            message$iv = var6_12.toString();
            $this$assertTrue$iv.error(message$iv);
        }
        while (i < this.bufferEnd) {
            v9 = this.buffer;
            if (v9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                v9 = null;
            }
            if (v9.charAt(i) == '\\') {
                return i;
            }
            if (this.state == 2) {
                v10 = this.buffer;
                if (v10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    v10 = null;
                }
                if (v10.charAt(i) == this.quoteChar) {
                    if (i + 1 == this.bufferEnd) {
                        this.state = 2;
                    }
                    return i + 1;
                }
            }
            ++i;
            this.state = 1;
        }
        return i;
    }

    private final int locateOctalEscapeSequence(int i) {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            charSequence = null;
        }
        char first = charSequence.charAt(i);
        int i2 = i + 1;
        if (i2 < this.bufferEnd) {
            char c;
            CharSequence charSequence2 = this.buffer;
            if (charSequence2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                charSequence2 = null;
            }
            boolean bl = '0' <= (c = charSequence2.charAt(i2)) ? c < '8' : false;
            if (bl && ++i2 < this.bufferEnd && Intrinsics.compare((int)first, (int)51) <= 0) {
                CharSequence charSequence3 = this.buffer;
                if (charSequence3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    charSequence3 = null;
                }
                boolean bl2 = '0' <= (c = charSequence3.charAt(i2)) ? c < '8' : false;
                if (bl2) {
                    ++i2;
                }
            }
        }
        return i2;
    }

    protected int locateHexEscapeSequence(int start, int i) {
        int i2;
        for (i2 = i + 1; i2 < start + 4; ++i2) {
            if (i2 != this.bufferEnd) {
                CharSequence charSequence = this.buffer;
                if (charSequence == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    charSequence = null;
                }
                if (charSequence.charAt(i2) != '\n') {
                    CharSequence charSequence2 = this.buffer;
                    if (charSequence2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                        charSequence2 = null;
                    }
                    if (charSequence2.charAt(i2) != this.quoteChar) continue;
                }
            }
            return i2;
        }
        return i2;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        int i2;
        for (i2 = i + 1; i2 < start + 6; ++i2) {
            if (i2 != this.bufferEnd) {
                CharSequence charSequence = this.buffer;
                if (charSequence == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                    charSequence = null;
                }
                if (charSequence.charAt(i2) != '\n') {
                    CharSequence charSequence2 = this.buffer;
                    if (charSequence2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                        charSequence2 = null;
                    }
                    if (charSequence2.charAt(i2) != this.quoteChar) continue;
                }
            }
            return i2;
        }
        return i2;
    }

    protected int locateAdditionalEscapeSequence(int start, int i) {
        return -1;
    }

    public void advance() {
        this.lastState = this.state;
        this.startOffset = this.endOffset;
        this.endOffset = this.locateToken(this.startOffset);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            charSequence = null;
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.bufferEnd;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/syntax/util/lexer/StringLiteralLexer$Companion;", "", "<init>", "()V", "AFTER_FIRST_QUOTE", "", "AFTER_LAST_QUOTE", "NO_QUOTE_CHAR", "", "LOG", "Lcom/intellij/platform/syntax/Logger;", "intellij.platform.syntax.util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

