/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.util.lexer;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.platform.syntax.util.lexer.DelegateLexer;
import com.intellij.util.ThreadLocalKmp;
import com.intellij.util.ThreadLocalKmpKt;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0014\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0014\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0014J(\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010(\u001a\u00020\u0007H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020.*\u00020\u00032\b\u0010/\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\b\u0012\u0004\u0012\u00020\u0003`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0013\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00140\tj\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0014`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020.8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00101\u00a8\u00064"}, d2={"Lcom/intellij/platform/syntax/util/lexer/LayeredLexer;", "Lcom/intellij/platform/syntax/util/lexer/DelegateLexer;", "baseLexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "<init>", "(Lcom/intellij/platform/syntax/lexer/Lexer;)V", "state", "", "startTokenToLayerLexerMap", "Ljava/util/HashMap;", "Lcom/intellij/platform/syntax/SyntaxElementType;", "Lkotlin/collections/HashMap;", "currentLayerLexer", "currentBaseTokenType", "layerLeftPart", "baseTokenEnd", "selfStoppingLexersSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "stopTokensMap", "", "registerSelfStoppingLayer", "", "lexer", "startTokens", "stopTokens", "(Lcom/intellij/platform/syntax/lexer/Lexer;[Lcom/intellij/platform/syntax/SyntaxElementType;[Lcom/intellij/platform/syntax/SyntaxElementType;)V", "registerLayer", "(Lcom/intellij/platform/syntax/lexer/Lexer;[Lcom/intellij/platform/syntax/SyntaxElementType;)V", "activateLayerIfNecessary", "findLayerLexer", "type", "start", "buffer", "", "startOffset", "endOffset", "initialState", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "advance", "getCurrentPosition", "Lcom/intellij/platform/syntax/lexer/LexerPosition;", "isStopToken", "", "tokenType", "isLayerActive", "()Z", "isInLayerEndGap", "Companion", "intellij.platform.syntax.util"})
public class LayeredLexer
extends DelegateLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int state;
    @NotNull
    private final HashMap<SyntaxElementType, Lexer> startTokenToLayerLexerMap = new HashMap();
    @Nullable
    private Lexer currentLayerLexer;
    @Nullable
    private SyntaxElementType currentBaseTokenType;
    private int layerLeftPart = -1;
    private int baseTokenEnd = -1;
    @NotNull
    private final HashSet<Lexer> selfStoppingLexersSet = new HashSet(1);
    @NotNull
    private final HashMap<Lexer, SyntaxElementType[]> stopTokensMap = new HashMap(1);
    public static final int IN_LAYER_STATE = 1024;
    public static final int IN_LAYER_LEXER_FINISHED_STATE = 2048;
    @JvmField
    @NotNull
    public static final ThreadLocalKmp<Boolean> DISABLE_LAYERS_FLAG = ThreadLocalKmpKt.ThreadLocalKmp();

    public LayeredLexer(@NotNull Lexer baseLexer) {
        super(baseLexer);
    }

    public final void registerSelfStoppingLayer(@NotNull Lexer lexer, @NotNull SyntaxElementType[] startTokens, @NotNull SyntaxElementType[] stopTokens) {
        if (Intrinsics.areEqual((Object)DISABLE_LAYERS_FLAG.get(), (Object)true)) {
            return;
        }
        this.registerLayer(lexer, Arrays.copyOf(startTokens, startTokens.length));
        this.selfStoppingLexersSet.add(lexer);
        ((Map)this.stopTokensMap).put(lexer, stopTokens);
    }

    public final void registerLayer(@NotNull Lexer lexer, SyntaxElementType ... startTokens) {
        if (Intrinsics.areEqual((Object)DISABLE_LAYERS_FLAG.get(), (Object)true)) {
            return;
        }
        for (SyntaxElementType startToken : startTokens) {
            ((Map)this.startTokenToLayerLexerMap).put(startToken, lexer);
        }
    }

    private final void activateLayerIfNecessary() {
        SyntaxElementType baseTokenType = super.getTokenType();
        this.currentLayerLexer = this.findLayerLexer(baseTokenType);
        if (this.currentLayerLexer != null) {
            this.currentBaseTokenType = baseTokenType;
            this.baseTokenEnd = super.getTokenEnd();
            Lexer lexer = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer);
            lexer.start(super.getBufferSequence(), super.getTokenStart(), super.getTokenEnd());
            if (CollectionsKt.contains((Iterable)this.selfStoppingLexersSet, (Object)this.currentLayerLexer)) {
                super.advance();
            }
        }
    }

    @Nullable
    protected Lexer findLayerLexer(@Nullable SyntaxElementType type) {
        return (Lexer)((Map)this.startTokenToLayerLexerMap).get(type);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.state = initialState;
        this.currentLayerLexer = null;
        super.start(buffer, startOffset, endOffset, initialState);
        this.activateLayerIfNecessary();
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    @Nullable
    public SyntaxElementType getTokenType() {
        SyntaxElementType syntaxElementType;
        if (this.isInLayerEndGap()) {
            syntaxElementType = this.currentBaseTokenType;
        } else if (this.isLayerActive()) {
            Lexer lexer = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer);
            syntaxElementType = lexer.getTokenType();
        } else {
            syntaxElementType = super.getTokenType();
        }
        return syntaxElementType;
    }

    @Override
    public int getTokenStart() {
        int n;
        if (this.isInLayerEndGap()) {
            n = this.layerLeftPart;
        } else if (this.isLayerActive()) {
            Lexer lexer = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer);
            n = lexer.getTokenStart();
        } else {
            n = super.getTokenStart();
        }
        return n;
    }

    @Override
    public int getTokenEnd() {
        int n;
        if (this.isInLayerEndGap()) {
            n = this.baseTokenEnd;
        } else if (this.isLayerActive()) {
            Lexer lexer = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer);
            n = lexer.getTokenEnd();
        } else {
            n = super.getTokenEnd();
        }
        return n;
    }

    @Override
    public void advance() {
        if (this.isInLayerEndGap()) {
            this.layerLeftPart = -1;
            this.state = super.getState();
            return;
        }
        if (this.isLayerActive()) {
            Lexer activeLayerLexer;
            Lexer lexer = activeLayerLexer = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer);
            SyntaxElementType layerTokenType = lexer.getTokenType();
            Lexer lexer2 = this.currentLayerLexer;
            Intrinsics.checkNotNull((Object)lexer2);
            if (!this.isStopToken(lexer2, layerTokenType)) {
                Lexer lexer3 = this.currentLayerLexer;
                Intrinsics.checkNotNull((Object)lexer3);
                lexer3.advance();
                Lexer lexer4 = this.currentLayerLexer;
                Intrinsics.checkNotNull((Object)lexer4);
                layerTokenType = lexer4.getTokenType();
            } else {
                layerTokenType = null;
            }
            if (layerTokenType == null) {
                Lexer lexer5 = this.currentLayerLexer;
                Intrinsics.checkNotNull((Object)lexer5);
                int tokenEnd = lexer5.getTokenEnd();
                boolean isSelfStopping = this.selfStoppingLexersSet.contains(activeLayerLexer);
                this.currentLayerLexer = null;
                if (!isSelfStopping) {
                    super.advance();
                } else if (tokenEnd != this.baseTokenEnd) {
                    this.state = 2048;
                    this.layerLeftPart = tokenEnd;
                    return;
                }
                this.activateLayerIfNecessary();
            }
        } else {
            super.advance();
            this.activateLayerIfNecessary();
        }
        this.state = this.isLayerActive() ? 1024 : super.getState();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        return new LexerPosition(this){
            private final int offset;
            private final int state;
            {
                this.offset = $receiver.getTokenStart();
                this.state = $receiver.getState();
            }

            public int getOffset() {
                return this.offset;
            }

            public int getState() {
                return this.state;
            }
        };
    }

    private final boolean isStopToken(Lexer $this$isStopToken, SyntaxElementType tokenType) {
        Object[] objectArray = this.stopTokensMap.get($this$isStopToken);
        if (objectArray == null) {
            return false;
        }
        Object[] stopTokens = objectArray;
        return ArraysKt.contains((Object[])stopTokens, (Object)tokenType);
    }

    protected final boolean isLayerActive() {
        return this.currentLayerLexer != null;
    }

    private final boolean isInLayerEndGap() {
        return this.layerLeftPart != -1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/syntax/util/lexer/LayeredLexer$Companion;", "", "<init>", "()V", "IN_LAYER_STATE", "", "IN_LAYER_LEXER_FINISHED_STATE", "DISABLE_LAYERS_FLAG", "Lcom/intellij/util/ThreadLocalKmp;", "", "intellij.platform.syntax.util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

