/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.testFramework.common.bazel.BazelLabel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\u0007\u0010\nR-\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\u00148FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0019\u001a\u00020\u00148FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0012\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/intellij/testFramework/common/BazelTestUtil;", "", "<init>", "()V", "TEST_SRCDIR_ENV_NAME", "", "TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME", "isUnderBazelTest", "", "isUnderBazelTest$annotations", "()Z", "bazelTestRepoMapping", "", "Lcom/intellij/testFramework/common/BazelTestUtil$RepoMappingEntry;", "getBazelTestRepoMapping$annotations", "getBazelTestRepoMapping", "()Ljava/util/Map;", "bazelTestRepoMapping$delegate", "Lkotlin/Lazy;", "bazelTestRunfilesPath", "Ljava/nio/file/Path;", "getBazelTestRunfilesPath$annotations", "getBazelTestRunfilesPath", "()Ljava/nio/file/Path;", "bazelTestRunfilesPath$delegate", "bazelUndeclaredTestOutputsPath", "getBazelUndeclaredTestOutputsPath$annotations", "getBazelUndeclaredTestOutputsPath", "bazelUndeclaredTestOutputsPath$delegate", "getFileFromBazelRuntime", "label", "Lcom/intellij/testFramework/common/bazel/BazelLabel;", "findRunfilesDirectoryUnderCommunityOrUltimate", "relativePath", "parseRepoEntry", "line", "RepoMappingEntry", "intellij.platform.testFramework.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nBazelTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelTestUtil.kt\ncom/intellij/testFramework/common/BazelTestUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,129:1\n1#2:130\n682#3:131\n712#3,4:132\n*S KotlinDebug\n*F\n+ 1 BazelTestUtil.kt\ncom/intellij/testFramework/common/BazelTestUtil\n*L\n35#1:131\n35#1:132,4\n*E\n"})
public final class BazelTestUtil {
    @NotNull
    public static final BazelTestUtil INSTANCE = new BazelTestUtil();
    @NotNull
    private static final String TEST_SRCDIR_ENV_NAME = "TEST_SRCDIR";
    @NotNull
    private static final String TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME = "TEST_UNDECLARED_OUTPUTS_DIR";
    private static final boolean isUnderBazelTest = System.getenv("TEST_SRCDIR") != null && System.getenv("TEST_UNDECLARED_OUTPUTS_DIR") != null;
    @NotNull
    private static final Lazy bazelTestRepoMapping$delegate = LazyKt.lazy(BazelTestUtil::bazelTestRepoMapping_delegate$lambda$0);
    @NotNull
    private static final Lazy bazelTestRunfilesPath$delegate = LazyKt.lazy(BazelTestUtil::bazelTestRunfilesPath_delegate$lambda$0);
    @NotNull
    private static final Lazy bazelUndeclaredTestOutputsPath$delegate = LazyKt.lazy(BazelTestUtil::bazelUndeclaredTestOutputsPath_delegate$lambda$0);

    private BazelTestUtil() {
    }

    public static final boolean isUnderBazelTest() {
        return isUnderBazelTest;
    }

    @JvmStatic
    public static /* synthetic */ void isUnderBazelTest$annotations() {
    }

    @NotNull
    public static final Map<String, RepoMappingEntry> getBazelTestRepoMapping() {
        Lazy lazy = bazelTestRepoMapping$delegate;
        return (Map)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelTestRepoMapping$annotations() {
    }

    @NotNull
    public static final Path getBazelTestRunfilesPath() {
        Lazy lazy = bazelTestRunfilesPath$delegate;
        return (Path)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelTestRunfilesPath$annotations() {
    }

    @NotNull
    public static final Path getBazelUndeclaredTestOutputsPath() {
        Lazy lazy = bazelUndeclaredTestOutputsPath$delegate;
        return (Path)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelUndeclaredTestOutputsPath$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Path getFileFromBazelRuntime(@NotNull BazelLabel label) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Map<String, RepoMappingEntry> map = BazelTestUtil.getBazelTestRepoMapping();
        RepoMappingEntry repoMappingEntry = map.get(label.getRepo());
        if (repoMappingEntry == null) {
            boolean bl = false;
            throw new IllegalStateException(("Unable to determine dependency path '" + label.getAsLabel() + "'").toString());
        }
        RepoMappingEntry repoEntry = repoMappingEntry;
        Path it = BazelTestUtil.getBazelTestRunfilesPath().resolve(repoEntry.getRunfilesRelativePath());
        boolean bl = false;
        Path file = (((CharSequence)label.getPackageName()).length() > 0 ? it.resolve(label.getPackageName()) : var3_3).resolve(label.getTarget());
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            } else {
                throw new IllegalStateException(("Unable to find test dependency '" + label.getAsLabel() + "' at " + file).toString());
            }
        }
        Path path = file.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path findRunfilesDirectoryUnderCommunityOrUltimate(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path root1 = BazelTestUtil.getBazelTestRunfilesPath().resolve("community+").resolve(relativePath);
        Path root2 = BazelTestUtil.getBazelTestRunfilesPath().resolve("_main").resolve(relativePath);
        Intrinsics.checkNotNull((Object)root1);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean root1exists = Files.isDirectory(root1, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNull((Object)root2);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        boolean root2exists = Files.isDirectory(root2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        if (!root1exists && !root2exists) {
            throw new IllegalStateException(("Cannot find runfiles directory " + relativePath + " under community+ or _main. TEST_SRCDIR (runfiles root) = " + BazelTestUtil.getBazelTestRunfilesPath() + ". Tried " + root1 + " and " + root2 + ". Please check that you passed this directory via data attribute of test rule").toString());
        }
        if (root1exists && root2exists) {
            throw new IllegalStateException(("Both " + root1 + " and " + root2 + " exist. Meaning " + relativePath + " is available both under community and ultimate roots. This ambitious setup might cause problems. Please remove " + root1 + " or " + root2 + " or use a different relative path for test rule").toString());
        }
        return root1exists ? root1 : root2;
    }

    private final RepoMappingEntry parseRepoEntry(String line) {
        String[] stringArray = new String[]{","};
        List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
        if (!(parts.size() == 3)) {
            boolean bl = false;
            String string = "_repo_mapping line must have exactly 3 comma-separated values: '" + line + "'";
            throw new IllegalArgumentException(string.toString());
        }
        return new RepoMappingEntry((String)parts.get(1), (String)parts.get(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map bazelTestRepoMapping_delegate$lambda$0() {
        Object object;
        Path path = BazelTestUtil.getBazelTestRunfilesPath().resolve("_repo_mapping");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        Closeable closeable = Files.newBufferedReader(path2, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            object = (BufferedReader)closeable;
            Intrinsics.checkNotNull((Object)object);
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)object);
            boolean bl = false;
            Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)lines, BazelTestUtil::bazelTestRepoMapping_delegate$lambda$0$0$0), BazelTestUtil::bazelTestRepoMapping_delegate$lambda$0$0$1));
            boolean $i$f$associateBy = false;
            void var8_10 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                RepoMappingEntry repoMappingEntry = (RepoMappingEntry)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(it.getRepoName(), element$iv$iv);
            }
            object = destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    private static final boolean bazelTestRepoMapping_delegate$lambda$0$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && ((CharSequence)it).length() > 0;
    }

    private static final RepoMappingEntry bazelTestRepoMapping_delegate$lambda$0$0$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.parseRepoEntry(it);
    }

    private static final Path bazelTestRunfilesPath_delegate$lambda$0() {
        String value2 = System.getenv(TEST_SRCDIR_ENV_NAME);
        if (value2 == null) {
            throw new IllegalStateException("Not running under `bazel test` because TEST_SRCDIR env is not set. Check isUnderBazelTest first.".toString());
        }
        Path path = Path.of(value2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Bazel test env 'TEST_SRCDIR' points to non-directory: " + path3).toString());
        }
        return path3;
    }

    private static final Path bazelUndeclaredTestOutputsPath_delegate$lambda$0() {
        String string = System.getenv(TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME);
        if (string == null) {
            throw new IllegalStateException("Not running under `bazel test` because TEST_UNDECLARED_OUTPUTS_DIR env is not set. Check isUnderBazelTest first.".toString());
        }
        String value2 = string;
        Path path = Path.of(value2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Bazel test env 'TEST_UNDECLARED_OUTPUTS_DIR' points to non-directory: " + path3).toString());
        }
        return path3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/testFramework/common/BazelTestUtil$RepoMappingEntry;", "", "repoName", "", "runfilesRelativePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getRepoName", "()Ljava/lang/String;", "getRunfilesRelativePath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.testFramework.common"})
    public static final class RepoMappingEntry {
        @NotNull
        private final String repoName;
        @NotNull
        private final String runfilesRelativePath;

        public RepoMappingEntry(@NotNull String repoName, @NotNull String runfilesRelativePath) {
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            Intrinsics.checkNotNullParameter((Object)runfilesRelativePath, (String)"runfilesRelativePath");
            this.repoName = repoName;
            this.runfilesRelativePath = runfilesRelativePath;
        }

        @NotNull
        public final String getRepoName() {
            return this.repoName;
        }

        @NotNull
        public final String getRunfilesRelativePath() {
            return this.runfilesRelativePath;
        }

        @NotNull
        public final String component1() {
            return this.repoName;
        }

        @NotNull
        public final String component2() {
            return this.runfilesRelativePath;
        }

        @NotNull
        public final RepoMappingEntry copy(@NotNull String repoName, @NotNull String runfilesRelativePath) {
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            Intrinsics.checkNotNullParameter((Object)runfilesRelativePath, (String)"runfilesRelativePath");
            return new RepoMappingEntry(repoName, runfilesRelativePath);
        }

        public static /* synthetic */ RepoMappingEntry copy$default(RepoMappingEntry repoMappingEntry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = repoMappingEntry.repoName;
            }
            if ((n & 2) != 0) {
                string2 = repoMappingEntry.runfilesRelativePath;
            }
            return repoMappingEntry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "RepoMappingEntry(repoName=" + this.repoName + ", runfilesRelativePath=" + this.runfilesRelativePath + ")";
        }

        public int hashCode() {
            int result = this.repoName.hashCode();
            result = result * 31 + this.runfilesRelativePath.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepoMappingEntry)) {
                return false;
            }
            RepoMappingEntry repoMappingEntry = (RepoMappingEntry)other;
            if (!Intrinsics.areEqual((Object)this.repoName, (Object)repoMappingEntry.repoName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.runfilesRelativePath, (Object)repoMappingEntry.runfilesRelativePath);
        }
    }
}

