/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common.bazel;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.testFramework.common.BazelTestUtil;
import com.intellij.testFramework.common.bazel.BazelDownloadFile;
import com.intellij.util.io.DigestUtil;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.bazelEnvironment.BazelLabel;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u00002\u00020\u0001B;\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010%\u001a\u00020\u0004H\u0004J$\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0005H\u0004R,\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader;", "", "versionsLoader", "Lkotlin/Function1;", "", "", "credentialsProvider", "Lkotlin/Function0;", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader$Credentials;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getVersionsLoader", "()Lkotlin/jvm/functions/Function1;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "getCommunityRoot", "()Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "communityRoot$delegate", "Lkotlin/Lazy;", "dependenciesDescFile", "Ljava/nio/file/Path;", "getDependenciesDescFile", "()Ljava/nio/file/Path;", "getDepsByLabel", "label", "Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel;", "downloadFile", "findDownloadFile", "Lcom/intellij/testFramework/common/bazel/BazelDownloadFile;", "testDependenciesHttpFiles", "", "getTestDependenciesHttpFiles", "()Ljava/util/List;", "testDependenciesHttpFiles$delegate", "findDownloadFileBlocks", "content", "findUrl", "string", "versions", "intellij.platform.testFramework.common"})
@SourceDebugExtension(value={"SMAP\nBazelTestDependencyHttpFileDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelTestDependencyHttpFileDownloader.kt\ncom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n13#2:150\n1#3:151\n1#3:168\n1342#4,2:152\n777#5:154\n873#5,2:155\n1642#5,10:157\n1915#5:167\n1916#5:169\n1652#5:170\n*S KotlinDebug\n*F\n+ 1 BazelTestDependencyHttpFileDownloader.kt\ncom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader\n*L\n23#1:150\n80#1:168\n109#1:152,2\n127#1:154\n127#1:155,2\n80#1:157,10\n80#1:167\n80#1:169\n80#1:170\n*E\n"})
public abstract class BazelTestDependencyHttpFileDownloader {
    @NotNull
    private final Function1<String, Map<String, String>> versionsLoader;
    @Nullable
    private final Function0<BuildDependenciesDownloader.Credentials> credentialsProvider;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Lazy communityRoot$delegate;
    @NotNull
    private final Lazy testDependenciesHttpFiles$delegate;

    public BazelTestDependencyHttpFileDownloader(@NotNull Function1<? super String, ? extends Map<String, String>> versionsLoader, @Nullable Function0<BuildDependenciesDownloader.Credentials> credentialsProvider) {
        Intrinsics.checkNotNullParameter(versionsLoader, (String)"versionsLoader");
        this.versionsLoader = versionsLoader;
        this.credentialsProvider = credentialsProvider;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BazelTestDependencyHttpFileDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.communityRoot$delegate = LazyKt.lazy(BazelTestDependencyHttpFileDownloader::communityRoot_delegate$lambda$0);
        this.testDependenciesHttpFiles$delegate = LazyKt.lazy(() -> BazelTestDependencyHttpFileDownloader.testDependenciesHttpFiles_delegate$lambda$0(this));
    }

    public /* synthetic */ BazelTestDependencyHttpFileDownloader(Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = BazelTestDependencyHttpFileDownloader::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        this((Function1<? super String, ? extends Map<String, String>>)function1, (Function0<BuildDependenciesDownloader.Credentials>)function0);
    }

    @NotNull
    protected final Function1<String, Map<String, String>> getVersionsLoader() {
        return this.versionsLoader;
    }

    private final BuildDependenciesCommunityRoot getCommunityRoot() {
        Lazy lazy = this.communityRoot$delegate;
        return (BuildDependenciesCommunityRoot)lazy.getValue();
    }

    @NotNull
    public abstract Path getDependenciesDescFile();

    @NotNull
    public final Path getDepsByLabel(@NotNull BazelLabel label) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (BazelTestUtil.isUnderBazelTest()) {
            it = var3_2 = BazelTestUtil.getFileFromBazelRuntime(label);
            boolean bl = false;
            this.LOG.info("Found dependency in Bazel runtime " + label.getAsLabel() + " at '" + it + "'");
            path = var3_2;
        } else {
            it = var3_2 = this.downloadFile(label);
            boolean bl = false;
            this.LOG.info("Found dependency download dependency " + label.getAsLabel() + " at '" + it + "'");
            path = var3_2;
        }
        Path dependency = path;
        return dependency;
    }

    private final Path downloadFile(BazelLabel label) {
        BazelDownloadFile downloadFile = this.findDownloadFile(label);
        URI labelUrl = new URI(downloadFile.getUrl());
        Path fileInCache = this.credentialsProvider != null ? BuildDependenciesDownloader.downloadFileToCacheLocation((BuildDependenciesCommunityRoot)this.getCommunityRoot(), (URI)labelUrl, () -> BazelTestDependencyHttpFileDownloader.downloadFile$lambda$0(this)) : BuildDependenciesDownloader.downloadFileToCacheLocation((BuildDependenciesCommunityRoot)this.getCommunityRoot(), (URI)labelUrl);
        byte[] byArray = Files.readAllBytes(fileInCache);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        String onDiskSha256 = DigestUtil.sha256Hex((byte[])byArray);
        if (!Intrinsics.areEqual((Object)onDiskSha256, (Object)downloadFile.getSha256())) {
            throw new IllegalStateException(("SHA-256 checksum mismatch for '" + label.getAsLabel() + "': expected '" + downloadFile.getSha256() + "', got '" + onDiskSha256 + "' at " + fileInCache).toString());
        }
        return fileInCache;
    }

    @NotNull
    public final BazelDownloadFile findDownloadFile(@NotNull BazelLabel label) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Iterable iterable = this.getTestDependenciesHttpFiles();
            for (Object t : iterable) {
                BazelDownloadFile it = (BazelDownloadFile)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)label.getTarget())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        BazelDownloadFile bazelDownloadFile = v0;
        if (bazelDownloadFile == null) {
            throw new IllegalStateException(("Unable to find URL for '" + label.getAsLabel() + "'").toString());
        }
        return bazelDownloadFile;
    }

    @NotNull
    public final List<BazelDownloadFile> getTestDependenciesHttpFiles() {
        Lazy lazy = this.testDependenciesHttpFiles$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<String> findDownloadFileBlocks(@NotNull String content) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        List blocks = new ArrayList();
        Regex regex = new Regex("download_file\\s*\\(");
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)regex, (CharSequence)content, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int pos;
            MatchResult match = (MatchResult)element$iv;
            boolean bl = false;
            int startPos = match.getRange().getLast() + 1;
            int depth = 1;
            block5: for (pos = startPos; pos < content.length() && depth > 0; ++pos) {
                switch (content.charAt(pos)) {
                    case '(': {
                        ++depth;
                        continue block5;
                    }
                    case ')': {
                        --depth;
                    }
                }
            }
            if (depth != 0) continue;
            String string = content.substring(startPos, pos - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            blocks.add(string);
        }
        Iterable $this$filter$iv = blocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"=", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final String findUrl(@NotNull String string, @NotNull Map<String, String> versions) {
        String string2;
        String formattedUrl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Regex urlRegex = new Regex("url\\s*=\\s*[\"'](.+)[\"']");
        Regex formatedUrlRegex = new Regex("url\\s*=\\s*[\"'](.+)[\"']\\.format\\((.+)\\),");
        Object object = Regex.find$default((Regex)urlRegex, (CharSequence)string, (int)0, (int)2, null);
        String url = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        MatchResult matchResult = Regex.find$default((Regex)formatedUrlRegex, (CharSequence)string, (int)0, (int)2, null);
        Object object2 = matchResult;
        String string3 = object2 != null && (object2 = object2.getGroupValues()) != null ? (String)object2.get(1) : (formattedUrl = null);
        if (formattedUrl != null) {
            String version = (String)matchResult.getGroupValues().get(2);
            String string4 = versions.get(version);
            if (string4 == null) {
                throw new IllegalStateException(("cannot find version " + version + " in " + versions).toString());
            }
            string2 = StringsKt.replace$default((String)formattedUrl, (String)"{0}", (String)string4, (boolean)false, (int)4, null);
        } else {
            string2 = url;
            if (string2 == null) {
                throw new IllegalStateException(("cannot find url in '" + string + "'").toString());
            }
        }
        return string2;
    }

    private static final Map _init_$lambda$0(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return MapsKt.emptyMap();
    }

    private static final BuildDependenciesCommunityRoot communityRoot_delegate$lambda$0() {
        Path path = Path.of(PathManager.getCommunityHomePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return new BuildDependenciesCommunityRoot(path);
    }

    private static final BuildDependenciesDownloader.Credentials downloadFile$lambda$0(BazelTestDependencyHttpFileDownloader this$0) {
        return (BuildDependenciesDownloader.Credentials)this$0.credentialsProvider.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private static final List testDependenciesHttpFiles_delegate$lambda$0(BazelTestDependencyHttpFileDownloader this$0) {
        void $this$mapNotNullTo$iv$iv;
        if (!Files.isRegularFile(this$0.getDependenciesDescFile(), new LinkOption[0])) {
            throw new IllegalStateException(("Unable to find test dependency file '" + this$0.getDependenciesDescFile() + "'").toString());
        }
        String content = PathsKt.readText$default((Path)this$0.getDependenciesDescFile(), null, (int)1, null);
        Map versions = (Map)this$0.versionsLoader.invoke((Object)content);
        Regex httpFileRegex = new Regex("(?<!def )download_file\\s*\\((.*?)\\)", RegexOption.DOT_MATCHES_ALL);
        Regex nameRegex = new Regex("name\\s*=\\s*[\"']([^\"']+)[\"']");
        Regex sha256Regex = new Regex("sha256\\s*=\\s*[\"']([^\"']+)[\"']");
        List errors = new ArrayList();
        Iterable $this$mapNotNull$iv = this$0.findDownloadFileBlocks(content);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BazelDownloadFile bazelDownloadFile;
            String sha256;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String block = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = Regex.find$default((Regex)nameRegex, (CharSequence)block, (int)0, (int)2, null);
            String name = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
            String url = this$0.findUrl(block, versions);
            Object object2 = Regex.find$default((Regex)sha256Regex, (CharSequence)block, (int)0, (int)2, null);
            String string = object2 != null && (object2 = object2.getGroupValues()) != null ? (String)object2.get(1) : (sha256 = null);
            if (name != null && sha256 != null) {
                bazelDownloadFile = new BazelDownloadFile(name, url, sha256);
            } else {
                CharSequence charSequence;
                Collection collection = errors;
                StringBuilder $this$testDependenciesHttpFiles_delegate_u24lambda_u240_u240_u240 = charSequence = new StringBuilder();
                boolean bl3 = false;
                $this$testDependenciesHttpFiles_delegate_u24lambda_u240_u240_u240.append("Unable to parse http_file block:\n" + block).append('\n');
                $this$testDependenciesHttpFiles_delegate_u24lambda_u240_u240_u240.append(((Object)StringsKt.trim((CharSequence)block)).toString()).append('\n');
                charSequence = charSequence.toString();
                collection.add(charSequence);
                bazelDownloadFile = null;
            }
            if (bazelDownloadFile == null) continue;
            BazelDownloadFile it$iv$iv = bazelDownloadFile;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List result = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (!((Collection)errors).isEmpty()) {
            throw new IllegalStateException((errors.size() + " download_file blocks were not parsed correctly:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        return result;
    }

    public BazelTestDependencyHttpFileDownloader() {
        this(null, null, 3, null);
    }
}

