/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.common.ThreadLeakTracker;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ref.IgnoredTraverseEntry;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class LeakHunter {
    @TestOnly
    @NotNull
    private static String getCreationPlace(@NotNull Project project) {
        if (project == null) {
            LeakHunter.$$$reportNull$$$0(0);
        }
        String creationTrace = project instanceof ProjectEx ? ((ProjectEx)project).getCreationTrace() : null;
        String string = String.valueOf(project) + " " + (creationTrace == null ? " " : creationTrace);
        if (string == null) {
            LeakHunter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @TestOnly
    public static void checkProjectLeak() throws AssertionError {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project) -> !project.isDefault() && !project.isLight());
    }

    @TestOnly
    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project) -> !project.isDefault());
    }

    @TestOnly
    public static void checkNonDefaultProjectLeakWithIgnoredEntries(@NotNull List<? extends IgnoredTraverseEntry> ignoredTraverseEntries) {
        if (ignoredTraverseEntries == null) {
            LeakHunter.$$$reportNull$$$0(2);
        }
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, ignoredTraverseEntries, project -> !project.isDefault());
    }

    @TestOnly
    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(3);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(4);
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(5);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(6);
        }
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, null, (leaked, backLink) -> {
            String message = LeakHunter.getLeakedObjectDetails(leaked, backLink, true);
            System.out.println(message);
            System.out.println(";-----");
            ThreadUtil.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @NotNull List<? extends IgnoredTraverseEntry> ignoredTraverseEntries, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(7);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(8);
        }
        if (ignoredTraverseEntries == null) {
            LeakHunter.$$$reportNull$$$0(9);
        }
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, backLink -> {
            for (IgnoredTraverseEntry entry : ignoredTraverseEntries) {
                if (!entry.test(backLink)) continue;
                return true;
            }
            return false;
        }, (leaked, backLink) -> {
            String message = LeakHunter.getLeakedObjectDetails(leaked, backLink, true);
            System.out.println(message);
            System.out.println(";-----");
            ThreadUtil.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    @TestOnly
    public static <T> boolean processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak, @Nullable Predicate<? super DebugReflectionUtil.BackLink<?>> leakBackLinkProcessor, @NotNull PairProcessor<? super T, Object> processor) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(10);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            LeakHunter.$$$reportNull$$$0(12);
        }
        LeakHunter.tryClearingNonReachableObjects();
        Computable runnable = () -> {
            Ref leakDetected = new Ref((Object)false);
            try (AccessToken ignored = ProhibitAWTEvents.start((String)"checking for leaks");){
                LeakHunter.runDetectorPass(rootsSupplier, suspectClass, isReallyLeak, leakBackLinkProcessor, (leaked, backLink) -> {
                    leakDetected.set((Object)true);
                    return false;
                });
            }
            if (!((Boolean)leakDetected.get()).booleanValue()) {
                return true;
            }
            LeakHunter.runAdditionalCleanup();
            ignored = ProhibitAWTEvents.start((String)"checking for leaks");
            try {
                Boolean bl = LeakHunter.runDetectorPass(rootsSupplier, suspectClass, isReallyLeak, leakBackLinkProcessor, processor);
                return bl;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        return application == null ? ((Boolean)runnable.compute()).booleanValue() : ((Boolean)application.runReadAction(runnable)).booleanValue();
    }

    private static <T> boolean runDetectorPass(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak, @Nullable Predicate<? super DebugReflectionUtil.BackLink<?>> leakBackLinkProcessor, @NotNull PairProcessor<? super T, Object> processor) {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(13);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            LeakHunter.$$$reportNull$$$0(15);
        }
        return DebugReflectionUtil.walkObjects((int)1000, (int)1000000, rootsSupplier.get(), suspectClass, __ -> true, (leaked, backLink) -> {
            if (leakBackLinkProcessor != null && leakBackLinkProcessor.test((DebugReflectionUtil.BackLink<?>)backLink)) {
                return true;
            }
            if (isReallyLeak == null || isReallyLeak.test(leaked)) {
                return processor.process(leaked, backLink);
            }
            return true;
        });
    }

    private static void runAdditionalCleanup() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LeakHunter.tryClearingNonReachableObjects();
    }

    @TestOnly
    private static void waitForIndicesToUpdate() {
        ProjectManager projectManager = ApplicationManager.getApplication() == null ? null : ProjectManager.getInstance();
        for (Project project : projectManager == null ? new Project[]{} : projectManager.getOpenProjects()) {
            if (EDT.isCurrentThreadEdt()) {
                TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> UIUtil.dispatchAllInvocationEvents());
                while (DumbService.getInstance((Project)project).isDumb()) {
                    DumbService.getInstance((Project)project).waitForSmartMode(100L);
                    TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> UIUtil.dispatchAllInvocationEvents());
                }
            } else {
                DumbService.getInstance((Project)project).waitForSmartMode();
                UIUtil.pump();
            }
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            FileBasedIndex.getInstance().ensureUpToDate(IdIndex.NAME, project, GlobalSearchScope.allScope((Project)project));
            FileBasedIndex.getInstance().ensureUpToDate(TrigramIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
        }
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(16);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(17);
        }
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @TestOnly
    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        Supplier<Map<Object, String>> supplier = () -> {
            IdentityHashMap<Object, String> result = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result.put(application, "ApplicationManager.getApplication()");
            }
            result.put(Disposer.getTree(), "Disposer.getTree()");
            result.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result.put(ThreadLeakTracker.getThreads().values(), "all live threads");
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Collection allLoadedClasses = (Collection)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
            if (allLoadedClasses != null) {
                result.put(allLoadedClasses, "all loaded classes statics");
            }
            return result;
        };
        if (supplier == null) {
            LeakHunter.$$$reportNull$$$0(18);
        }
        return supplier;
    }

    @TestOnly
    private static void tryClearingNonReachableObjects() {
        LeakHunter.waitForIndicesToUpdate();
        if (EDT.isCurrentThreadEdt()) {
            UIUtil.dispatchAllInvocationEvents();
            LaterInvocator.purgeExpiredItems();
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        } else {
            UIUtil.pump();
            try {
                SwingUtilities.invokeAndWait(() -> {
                    LaterInvocator.purgeExpiredItems();
                    NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        NonBlockingReadActionImpl.dropTestTasks();
        PersistentEnumeratorCache.clearCacheForTests();
        LeakHunter.flushTelemetry();
        GCUtil.tryGcSoftlyReachableObjects();
    }

    @TestOnly
    @NotNull
    public static String getLeakedObjectDetails(@NotNull Object leaked, @Nullable Object backLink, boolean detailedErrorDescription) {
        String creationPlace;
        if (leaked == null) {
            LeakHunter.$$$reportNull$$$0(19);
        }
        int hashCode = System.identityHashCode(leaked);
        String result = "Found a leaked instance of " + String.valueOf(leaked.getClass()) + "\nInstance: " + String.valueOf(leaked) + "\nHashcode: " + hashCode;
        if (detailedErrorDescription) {
            result = result + "\n" + LeakHunter.getLeakedObjectErrorDescription(null);
        }
        if (backLink != null) {
            result = result + "\nExisting strong reference path to the instance:\n" + backLink.toString().indent(2);
        }
        String string = creationPlace = leaked instanceof Project ? LeakHunter.getCreationPlace((Project)leaked) : null;
        if (creationPlace != null) {
            result = result + "\nThe instance was created at: " + creationPlace;
        }
        String string2 = result;
        if (string2 == null) {
            LeakHunter.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @TestOnly
    @NotNull
    public static String getLeakedObjectErrorDescription(@Nullable String knownHeapDumpPath) {
        Object result = "Error description:\n  This error means that the object is expected to be collected by the garbage collector by this time, but it was not.\n  Please make sure you dispose your resources properly. See https://plugins.jetbrains.com/docs/intellij/disposers.html";
        if (TeamCityLogger.isUnderTC) {
            String buildUrl = TeamCityLogger.currentBuildUrl != null ? StringUtil.trimEnd((String)TeamCityLogger.currentBuildUrl, (String)"/") : "";
            Object buildArtifactsLink = !buildUrl.isBlank() ? " " + buildUrl + "?buildTab=artifacts" : "";
            result = (String)result + "\n  You can find a memory snapshot `leakedProjects.hprof.zip` in the \"Artifacts\" tab of the build run" + (String)buildArtifactsLink + ".";
            result = (String)result + "\n  See leaks investigation guide https://jb.gg/ijpl-project-leaks.";
            result = (String)result + "\n  If you suspect a particular test, you can reproduce the problem locally calling TestApplicationManager.testProjectLeak() after the test.";
        } else {
            result = knownHeapDumpPath != null ? (String)result + "\n  Please see ``" + knownHeapDumpPath + "` for a memory dump" : (String)result + "\n  Try looking for 'Heap dump is published to ' line in the system output log below. It contains a path to a collected memory snapshot";
        }
        Object object = result;
        if (object == null) {
            LeakHunter.$$$reportNull$$$0(21);
        }
        return object;
    }

    private static void flushTelemetry() {
        TelemetryManager.getInstance().forceFlushMetricsBlocking();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 18, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredTraverseEntries";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsSupplier";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaked";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationPlace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeakedObjectDetails";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeakedObjectErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCreationPlace";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNonDefaultProjectLeakWithIgnoredEntries";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runDetectorPass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLeakedObjectDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 18, 20, 21 -> new IllegalStateException(string);
        };
    }
}

