/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.bazelEnvironment.BazelLabel;
import org.jetbrains.intellij.bazelEnvironment.BazelRunfiles;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\b\u0010\u000bR!\u0010\f\u001a\u00020\r8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\r8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0012\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/testFramework/common/BazelTestUtil;", "", "<init>", "()V", "TEST_SRCDIR_ENV_NAME", "", "TEST_TMPDIR_ENV_NAME", "TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME", "isUnderBazelTest", "", "isUnderBazelTest$annotations", "()Z", "bazelTestTmpDirPath", "Ljava/nio/file/Path;", "getBazelTestTmpDirPath$annotations", "getBazelTestTmpDirPath", "()Ljava/nio/file/Path;", "bazelTestTmpDirPath$delegate", "Lkotlin/Lazy;", "bazelUndeclaredTestOutputsPath", "getBazelUndeclaredTestOutputsPath$annotations", "getBazelUndeclaredTestOutputsPath", "bazelUndeclaredTestOutputsPath$delegate", "getFileFromBazelRuntime", "label", "Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel;", "findRunfilesDirectoryUnderCommunityOrUltimate", "relativePath", "intellij.platform.testFramework.common"})
@ApiStatus.Experimental
public final class BazelTestUtil {
    @NotNull
    public static final BazelTestUtil INSTANCE = new BazelTestUtil();
    @NotNull
    private static final String TEST_SRCDIR_ENV_NAME = "TEST_SRCDIR";
    @NotNull
    private static final String TEST_TMPDIR_ENV_NAME = "TEST_TMPDIR";
    @NotNull
    private static final String TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME = "TEST_UNDECLARED_OUTPUTS_DIR";
    private static final boolean isUnderBazelTest = System.getenv("TEST_SRCDIR") != null && System.getenv("TEST_UNDECLARED_OUTPUTS_DIR") != null;
    @NotNull
    private static final Lazy bazelTestTmpDirPath$delegate = LazyKt.lazy(BazelTestUtil::bazelTestTmpDirPath_delegate$lambda$0);
    @NotNull
    private static final Lazy bazelUndeclaredTestOutputsPath$delegate = LazyKt.lazy(BazelTestUtil::bazelUndeclaredTestOutputsPath_delegate$lambda$0);

    private BazelTestUtil() {
    }

    public static final boolean isUnderBazelTest() {
        return isUnderBazelTest;
    }

    @JvmStatic
    public static /* synthetic */ void isUnderBazelTest$annotations() {
    }

    @NotNull
    public static final Path getBazelTestTmpDirPath() {
        Lazy lazy = bazelTestTmpDirPath$delegate;
        return (Path)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelTestTmpDirPath$annotations() {
    }

    @NotNull
    public static final Path getBazelUndeclaredTestOutputsPath() {
        Lazy lazy = bazelUndeclaredTestOutputsPath$delegate;
        return (Path)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelUndeclaredTestOutputsPath$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final Path getFileFromBazelRuntime(@NotNull BazelLabel label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return BazelRunfiles.getFileByLabel((BazelLabel)label);
    }

    @JvmStatic
    @NotNull
    public static final Path findRunfilesDirectoryUnderCommunityOrUltimate(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return BazelRunfiles.findRunfilesDirectoryUnderCommunityOrUltimate((String)relativePath);
    }

    private static final Path bazelTestTmpDirPath_delegate$lambda$0() {
        String value2 = System.getenv(TEST_TMPDIR_ENV_NAME);
        if (value2 == null) {
            throw new IllegalStateException("Not running under `bazel test` because TEST_TMPDIR env is not set. Check isUnderBazelTest first.".toString());
        }
        Path path = Path.of(value2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Bazel test env 'TEST_TMPDIR' points to non-directory: " + path3).toString());
        }
        return path3;
    }

    private static final Path bazelUndeclaredTestOutputsPath_delegate$lambda$0() {
        String string = System.getenv(TEST_UNDECLARED_OUTPUTS_DIR_ENV_NAME);
        if (string == null) {
            throw new IllegalStateException("Not running under `bazel test` because TEST_UNDECLARED_OUTPUTS_DIR env is not set. Check isUnderBazelTest first.".toString());
        }
        String value2 = string;
        Path path = Path.of(value2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Bazel test env 'TEST_UNDECLARED_OUTPUTS_DIR' points to non-directory: " + path3).toString());
        }
        return path3;
    }
}

