/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.testFramework.TeamCityLogger;
import com.intellij.util.MemoryDumpHelper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u001a*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u001a\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"HEAP_DUMP_IS_PUBLISHED", "", "publishHeapDump", "fileNamePrefix", "publishArtifact", "Ljava/nio/file/Path;", "fileNameSuffix", "block", "Lkotlin/Function1;", "", "fileName", "intellij.platform.testFramework.common"})
public final class DumpKt {
    @NotNull
    public static final String HEAP_DUMP_IS_PUBLISHED = "Heap dump is published to ";

    @TestOnly
    @NotNull
    public static final String publishHeapDump(@NotNull String fileNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
        Path dumpPath = DumpKt.publishArtifact(fileNamePrefix, "hprof.zip", (Function1<? super Path, Unit>)((Function1)DumpKt::publishHeapDump$lambda$0));
        System.out.println((Object)(HEAP_DUMP_IS_PUBLISHED + dumpPath));
        return ((Object)dumpPath.toAbsolutePath()).toString();
    }

    @NotNull
    public static final Path publishArtifact(@NotNull String fileNamePrefix, @NotNull String fileNameSuffix, @NotNull Function1<? super Path, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
        Intrinsics.checkNotNullParameter((Object)fileNameSuffix, (String)"fileNameSuffix");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uuid = StringsKt.substring((String)string, (IntRange)new IntRange(1, 4));
        String fileName = fileNamePrefix + "-" + uuid + "." + fileNameSuffix;
        return DumpKt.publishArtifact(fileName, block);
    }

    @NotNull
    public static final Path publishArtifact(@NotNull String fileName, @NotNull Function1<? super Path, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String[] stringArray = new String[]{fileName};
        Path dumpFile = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), stringArray);
        try {
            Files.deleteIfExists(dumpFile);
            Intrinsics.checkNotNull((Object)dumpFile);
            block.invoke((Object)dumpFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TeamCityLogger.publishArtifact((Path)dumpFile.toAbsolutePath(), null);
        Intrinsics.checkNotNull((Object)dumpFile);
        return dumpFile;
    }

    private static final Unit publishHeapDump$lambda$0(Path dumpFile) {
        Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
        MemoryDumpHelper.captureMemoryDumpZipped((Path)dumpFile);
        return Unit.INSTANCE;
    }
}

