/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common.bazel;

import com.intellij.openapi.application.PathManager;
import com.intellij.testFramework.common.BazelTestUtil;
import com.intellij.testFramework.common.bazel.BazelTestDependencyHttpFileDownloader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.bazelEnvironment.BazelLabel;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesExtractOptions;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/testFramework/common/bazel/BazelLabelArchiveProjectInfo;", "", "bazelLabel", "", "projectHomeRelativePath", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "testDependencyLoader", "Lcom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader;)V", "getBazelLabel", "()Ljava/lang/String;", "getProjectHomeRelativePath", "()Lkotlin/jvm/functions/Function1;", "getTestDependencyLoader", "()Lcom/intellij/testFramework/common/bazel/BazelTestDependencyHttpFileDownloader;", "unpackProject", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.testFramework.common"})
public final class BazelLabelArchiveProjectInfo {
    @NotNull
    private final String bazelLabel;
    @NotNull
    private final Function1<Path, Path> projectHomeRelativePath;
    @NotNull
    private final BazelTestDependencyHttpFileDownloader testDependencyLoader;

    public BazelLabelArchiveProjectInfo(@NotNull String bazelLabel, @NotNull Function1<? super Path, ? extends Path> projectHomeRelativePath, @NotNull BazelTestDependencyHttpFileDownloader testDependencyLoader) {
        Intrinsics.checkNotNullParameter((Object)bazelLabel, (String)"bazelLabel");
        Intrinsics.checkNotNullParameter(projectHomeRelativePath, (String)"projectHomeRelativePath");
        Intrinsics.checkNotNullParameter((Object)testDependencyLoader, (String)"testDependencyLoader");
        this.bazelLabel = bazelLabel;
        this.projectHomeRelativePath = projectHomeRelativePath;
        this.testDependencyLoader = testDependencyLoader;
    }

    public /* synthetic */ BazelLabelArchiveProjectInfo(String string, Function1 function1, BazelTestDependencyHttpFileDownloader bazelTestDependencyHttpFileDownloader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = BazelLabelArchiveProjectInfo::_init_$lambda$0;
        }
        this(string, (Function1<? super Path, ? extends Path>)function1, bazelTestDependencyHttpFileDownloader);
    }

    @NotNull
    public final String getBazelLabel() {
        return this.bazelLabel;
    }

    @NotNull
    public final Function1<Path, Path> getProjectHomeRelativePath() {
        return this.projectHomeRelativePath;
    }

    @NotNull
    public final BazelTestDependencyHttpFileDownloader getTestDependencyLoader() {
        return this.testDependencyLoader;
    }

    @NotNull
    public final Path unpackProject() {
        Path projectsUnpacked;
        Path path;
        BazelLabel label = BazelLabel.Companion.fromString(this.bazelLabel);
        Path projectZipFile = this.testDependencyLoader.getDepsByLabel(label);
        if (BazelTestUtil.isUnderBazelTest()) {
            Path target = BazelTestUtil.getBazelTestTmpDirPath().resolve(label.getTarget());
            Intrinsics.checkNotNull((Object)target);
            BuildDependenciesUtil.INSTANCE.extractZip(projectZipFile, target, false);
            path = target;
        } else {
            Path path2 = Path.of(PathManager.getCommunityHomePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            path = BuildDependenciesDownloader.INSTANCE.extractFileToCacheLocation(new BuildDependenciesCommunityRoot(path2), projectZipFile, new BuildDependenciesExtractOptions[0]);
        }
        Path path3 = projectsUnpacked = path;
        Path projectHome = (Path)this.projectHomeRelativePath.invoke((Object)path3);
        return projectHome;
    }

    @NotNull
    public final String component1() {
        return this.bazelLabel;
    }

    @NotNull
    public final Function1<Path, Path> component2() {
        return this.projectHomeRelativePath;
    }

    @NotNull
    public final BazelTestDependencyHttpFileDownloader component3() {
        return this.testDependencyLoader;
    }

    @NotNull
    public final BazelLabelArchiveProjectInfo copy(@NotNull String bazelLabel, @NotNull Function1<? super Path, ? extends Path> projectHomeRelativePath, @NotNull BazelTestDependencyHttpFileDownloader testDependencyLoader) {
        Intrinsics.checkNotNullParameter((Object)bazelLabel, (String)"bazelLabel");
        Intrinsics.checkNotNullParameter(projectHomeRelativePath, (String)"projectHomeRelativePath");
        Intrinsics.checkNotNullParameter((Object)testDependencyLoader, (String)"testDependencyLoader");
        return new BazelLabelArchiveProjectInfo(bazelLabel, projectHomeRelativePath, testDependencyLoader);
    }

    public static /* synthetic */ BazelLabelArchiveProjectInfo copy$default(BazelLabelArchiveProjectInfo bazelLabelArchiveProjectInfo, String string, Function1 function1, BazelTestDependencyHttpFileDownloader bazelTestDependencyHttpFileDownloader, int n, Object object) {
        if ((n & 1) != 0) {
            string = bazelLabelArchiveProjectInfo.bazelLabel;
        }
        if ((n & 2) != 0) {
            function1 = bazelLabelArchiveProjectInfo.projectHomeRelativePath;
        }
        if ((n & 4) != 0) {
            bazelTestDependencyHttpFileDownloader = bazelLabelArchiveProjectInfo.testDependencyLoader;
        }
        return bazelLabelArchiveProjectInfo.copy(string, function1, bazelTestDependencyHttpFileDownloader);
    }

    @NotNull
    public String toString() {
        return "BazelLabelArchiveProjectInfo(bazelLabel=" + this.bazelLabel + ", projectHomeRelativePath=" + this.projectHomeRelativePath + ", testDependencyLoader=" + this.testDependencyLoader + ")";
    }

    public int hashCode() {
        int result = this.bazelLabel.hashCode();
        result = result * 31 + this.projectHomeRelativePath.hashCode();
        result = result * 31 + this.testDependencyLoader.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BazelLabelArchiveProjectInfo)) {
            return false;
        }
        BazelLabelArchiveProjectInfo bazelLabelArchiveProjectInfo = (BazelLabelArchiveProjectInfo)other;
        if (!Intrinsics.areEqual((Object)this.bazelLabel, (Object)bazelLabelArchiveProjectInfo.bazelLabel)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.projectHomeRelativePath, bazelLabelArchiveProjectInfo.projectHomeRelativePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.testDependencyLoader, (Object)bazelLabelArchiveProjectInfo.testDependencyLoader);
    }

    private static final Path _init_$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

