/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0014J\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/testFramework/common/BazelRunfilesManifest;", "", "<init>", "()V", "bazelRunFilesManifest", "", "", "getBazelRunFilesManifest", "()Ljava/util/Map;", "bazelRunFilesManifest$delegate", "Lkotlin/Lazy;", "calculatedManifestEntries", "", "parseManifestEntry", "Lkotlin/Pair;", "line", "get", "key", "findLongestCommonPrefix", "paths", "", "mapByQuery", "fullKey", "value", "queryKey", "Companion", "intellij.platform.testFramework.common"})
@SourceDebugExtension(value={"SMAP\nBazelTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelTestUtil.kt\ncom/intellij/testFramework/common/BazelRunfilesManifest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,263:1\n1#2:264\n1563#3:265\n1634#3,3:266\n1563#3:269\n1634#3,2:270\n774#3:272\n865#3,2:273\n1636#3:275\n1761#3,3:276\n739#3,9:279\n739#3,9:290\n739#3,9:301\n37#4,2:288\n37#4,2:299\n37#4,2:310\n536#5:312\n521#5,6:313\n*S KotlinDebug\n*F\n+ 1 BazelTestUtil.kt\ncom/intellij/testFramework/common/BazelRunfilesManifest\n*L\n223#1:265\n223#1:266,3\n224#1:269\n224#1:270,2\n224#1:272\n224#1:273,2\n224#1:275\n234#1:276,3\n244#1:279,9\n245#1:290,9\n246#1:301,9\n244#1:288,2\n245#1:299,2\n246#1:310,2\n203#1:312\n203#1:313,6\n*E\n"})
public final class BazelRunfilesManifest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy bazelRunFilesManifest$delegate = LazyKt.lazy(() -> BazelRunfilesManifest.bazelRunFilesManifest_delegate$lambda$0(this));
    @NotNull
    private final Map<String, String> calculatedManifestEntries = new LinkedHashMap();
    @NotNull
    private static final String RUNFILES_MANIFEST_FILE_ENV_NAME = "RUNFILES_MANIFEST_FILE";

    private final Map<String, String> getBazelRunFilesManifest() {
        Lazy lazy = this.bazelRunFilesManifest$delegate;
        return (Map)lazy.getValue();
    }

    private final Pair<String, String> parseManifestEntry(String line) {
        String[] stringArray = new String[]{" "};
        List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        if (!(parts.size() == 2)) {
            boolean bl = false;
            String string = "runfiles_manifest line must have exactly 2 space-separated values: '" + line + "'";
            throw new IllegalArgumentException(string.toString());
        }
        return TuplesKt.to(parts.get(0), parts.get(1));
    }

    @NotNull
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String valueByFullKey = this.getBazelRunFilesManifest().get(key);
        if (valueByFullKey != null) {
            return valueByFullKey;
        }
        String string = this.calculatedManifestEntries.computeIfAbsent(key, arg_0 -> BazelRunfilesManifest.get$lambda$1(arg_0 -> BazelRunfilesManifest.get$lambda$0(this, key, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String findLongestCommonPrefix(@Nullable Set<String> paths) {
        String it;
        char[] cArray;
        Collection collection;
        Object item$iv$iv;
        Iterator $this$mapTo$iv$iv;
        Collection collection2 = paths;
        if (collection2 == null || collection2.isEmpty()) {
            return "";
        }
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            cArray = new char[]{'/'};
            collection.add(StringsKt.trim((String)it, (char[])cArray));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            void p;
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (((CharSequence)p).length() == 0) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$filterTo$iv$iv;
                cArray = new char[]{'/'};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((CharSequence)p), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it2).length() > 0;
                    if (!bl3) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list = (List)destination$iv$iv2;
            }
            collection.add(list);
        }
        List partsList = (List)destination$iv$iv;
        if (partsList.isEmpty()) {
            return "";
        }
        $this$mapTo$iv$iv = ((Iterable)partsList).iterator();
        if (!$this$mapTo$iv$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        List it22 = (List)$this$mapTo$iv$iv.next();
        boolean bl = false;
        int it22 = it22.size();
        while ($this$mapTo$iv$iv.hasNext()) {
            List it32 = (List)$this$mapTo$iv$iv.next();
            $i$a$-minOf-BazelRunfilesManifest$findLongestCommonPrefix$minLength$1 = false;
            int it32 = it32.size();
            if (it22 <= it32) continue;
            it22 = it32;
        }
        int minLength = it22;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < minLength; ++i) {
            boolean bl4;
            String segment;
            block14: {
                segment = (String)((List)partsList.get(0)).get(i);
                Iterable $this$any$iv = partsList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        List it3 = (List)element$iv;
                        boolean bl5 = false;
                        if (!(!Intrinsics.areEqual(it3.get(i), (Object)segment))) continue;
                        bl4 = true;
                        break block14;
                    }
                    bl4 = false;
                }
            }
            if (bl4) break;
            if (((CharSequence)sb).length() > 0) {
                sb.append('/');
            }
            sb.append(segment);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String mapByQuery(@NotNull String fullKey, @NotNull String value2, @NotNull String queryKey) {
        StringBuilder stringBuilder;
        void $this$toTypedArray$iv;
        List list;
        void $this$toTypedArray$iv2;
        List list2;
        void $this$toTypedArray$iv3;
        List list3;
        Intrinsics.checkNotNullParameter((Object)fullKey, (String)"fullKey");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)queryKey, (String)"queryKey");
        if (!(((CharSequence)fullKey).length() > 0 && ((CharSequence)value2).length() > 0 && ((CharSequence)queryKey).length() > 0)) {
            boolean $i$a$-require-BazelRunfilesManifest$mapByQuery$32 = false;
            String $i$a$-require-BazelRunfilesManifest$mapByQuery$32 = "Query cannot be empty";
            throw new IllegalArgumentException($i$a$-require-BazelRunfilesManifest$mapByQuery$32.toString());
        }
        String[] $i$a$-require-BazelRunfilesManifest$mapByQuery$32 = new String[]{"/"};
        Collection $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)fullKey, (String[])$i$a$-require-BazelRunfilesManifest$mapByQuery$32, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list3 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list3;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv3;
        String[] fullKeyParts = thisCollection$iv.toArray(new String[0]);
        String[] $i$f$toTypedArray22 = new String[]{"/"};
        Collection $this$dropLastWhile$iv2 = StringsKt.split$default((CharSequence)value2, (String[])$i$f$toTypedArray22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile2 = false;
        if (!$this$dropLastWhile$iv2.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv2 = list2;
        boolean $i$f$toTypedArray32 = false;
        void thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] valueParts = thisCollection$iv2.toArray(new String[0]);
        String[] $i$f$toTypedArray32 = new String[]{"/"};
        Collection $this$dropLastWhile$iv3 = StringsKt.split$default((CharSequence)queryKey, (String[])$i$f$toTypedArray32, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile3 = false;
        if (!$this$dropLastWhile$iv3.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv3.listIterator($this$dropLastWhile$iv3.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv3, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv3 = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv3 = $this$toTypedArray$iv;
        String[] queryKeyParts = thisCollection$iv3.toArray(new String[0]);
        if (!(fullKeyParts.length >= queryKeyParts.length)) {
            boolean $i$a$-require-BazelRunfilesManifest$mapByQuery$42 = false;
            String $i$a$-require-BazelRunfilesManifest$mapByQuery$42 = "Query key " + queryKey + " is longer than full key " + fullKey;
            throw new IllegalArgumentException($i$a$-require-BazelRunfilesManifest$mapByQuery$42.toString());
        }
        int removeCount = fullKeyParts.length - queryKeyParts.length;
        int endIndex = Math.max(valueParts.length - removeCount, 0);
        StringBuilder $this$mapByQuery_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < endIndex; ++i) {
            if (i > 0) {
                $this$mapByQuery_u24lambda_u245.append('/');
            }
            $this$mapByQuery_u24lambda_u245.append(valueParts[i]);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map bazelRunFilesManifest_delegate$lambda$0(BazelRunfilesManifest this$0) {
        Object object;
        Path file = Path.of(System.getenv(RUNFILES_MANIFEST_FILE_ENV_NAME), new String[0]);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "RUNFILES_MANIFEST_FILE does not exist: " + file;
            throw new IllegalArgumentException(string.toString());
        }
        Path path = file;
        Closeable closeable = Files.newBufferedReader(path, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            object = (BufferedReader)closeable;
            Intrinsics.checkNotNull((Object)object);
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)object);
            boolean bl = false;
            object = MapsKt.toMap((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)lines, BazelRunfilesManifest::bazelRunFilesManifest_delegate$lambda$0$1$0), arg_0 -> BazelRunfilesManifest.bazelRunFilesManifest_delegate$lambda$0$1$1(this$0, arg_0))));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    private static final boolean bazelRunFilesManifest_delegate$lambda$0$1$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && ((CharSequence)it).length() > 0;
    }

    private static final Pair bazelRunFilesManifest_delegate$lambda$0$1$1(BazelRunfilesManifest this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseManifestEntry(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final String get$lambda$0(BazelRunfilesManifest this$0, String $key, String it) {
        String string;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, String> $this$filter$iv = this$0.getBazelRunFilesManifest();
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)((String)it2.getKey()), (String)$key, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map subset = destination$iv$iv;
        if (!subset.isEmpty()) {
            String longestKey = this$0.findLongestCommonPrefix(subset.keySet());
            String longestValue = this$0.findLongestCommonPrefix(CollectionsKt.toSet((Iterable)subset.values()));
            string = this$0.mapByQuery(longestKey, longestValue, $key);
        } else {
            string = $key;
        }
        String calculatedValue = string;
        return calculatedValue;
    }

    private static final String get$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/common/BazelRunfilesManifest$Companion;", "", "<init>", "()V", "RUNFILES_MANIFEST_FILE_ENV_NAME", "", "intellij.platform.testFramework.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

