/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.junit5.eel.impl;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.EelUserWindowsInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.impl.fs.WindowsNioBasedEelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.testFramework.junit5.eel.impl.EelTestWindowsUserInfo;
import com.intellij.platform.testFramework.junit5.eel.impl.nio.EelUnitTestFileSystem;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/testFramework/junit5/eel/impl/EelTestFileSystemWindowsApi;", "Lcom/intellij/platform/eel/impl/fs/WindowsNioBasedEelFileSystemApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "fileSystem", "Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;)V", "getDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "createTemporaryDirectory", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/path/EelPath;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryError;", "options", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryOptions;", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTemporaryFile", "intellij.platform.testFramework.junit5.eel"})
@SourceDebugExtension(value={"SMAP\nEelTestWindowsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelTestWindowsApi.kt\ncom/intellij/platform/testFramework/junit5/eel/impl/EelTestFileSystemWindowsApi\n+ 2 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n*L\n1#1,50:1\n52#2,31:51\n52#2,31:82\n*S KotlinDebug\n*F\n+ 1 EelTestWindowsApi.kt\ncom/intellij/platform/testFramework/junit5/eel/impl/EelTestFileSystemWindowsApi\n*L\n34#1:51,31\n41#1:82,31\n*E\n"})
final class EelTestFileSystemWindowsApi
extends WindowsNioBasedEelFileSystemApi {
    @NotNull
    private final EelDescriptor descriptor;

    public EelTestFileSystemWindowsApi(@NotNull EelDescriptor descriptor, @NotNull EelUnitTestFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        super((FileSystem)fileSystem, (EelUserWindowsInfo)new EelTestWindowsUserInfo(descriptor));
        this.descriptor = descriptor;
    }

    @NotNull
    public EelDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object createTemporaryDirectory(@NotNull EelFileSystemApi.CreateTemporaryEntryOptions options, @NotNull Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = (NioBasedEelFileSystemApi)this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            Path nioTempDir = Files.createTempDirectory(options.getPrefix(), new FileAttribute[0]);
            Path path = Path.of(((Object)nioTempDir).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            EelPath eelPath = EelNioBridgeServiceKt.asEelPath((Path)path);
            EelFsResultImpl.Ok result$iv$iv = new EelFsResultImpl.Ok((Object)eelPath);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath nioTempDir;
            try {
                nioTempDir = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                nioTempDir = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = nioTempDir;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.CreateTemporaryEntryError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.CreateTemporaryEntryError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.CreateTemporaryEntryError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object createTemporaryFile(@NotNull EelFileSystemApi.CreateTemporaryEntryOptions options, @NotNull Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = (NioBasedEelFileSystemApi)this;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            Path nioTempFile = Files.createTempFile(options.getPrefix(), options.getSuffix(), new FileAttribute[0]);
            Path path = Path.of(((Object)nioTempFile).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            EelPath eelPath = EelNioBridgeServiceKt.asEelPath((Path)path);
            EelFsResultImpl.Ok result$iv$iv = new EelFsResultImpl.Ok((Object)eelPath);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath nioTempFile;
            try {
                nioTempFile = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                nioTempFile = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = nioTempFile;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelFileSystemApi.CreateTemporaryEntryError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelFileSystemApi.CreateTemporaryEntryError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelFileSystemApi.CreateTemporaryEntryError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error(eelFsError);
        }
        return eelResult;
    }
}

