/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.junit5.eel.impl.nio;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.testFramework.junit5.eel.impl.nio.EelUnitTestPath;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0016J\u0012\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010!\u0018\u00010\u001fH\u0016J\u0012\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010#H\u0016J)\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\t2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0'\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;", "Ljava/nio/file/FileSystem;", "provider", "Ljava/nio/file/spi/FileSystemProvider;", "os", "Lcom/intellij/platform/eel/EelPlatform;", "rootDirectory", "Ljava/nio/file/Path;", "fakeLocalRoot", "", "<init>", "(Ljava/nio/file/spi/FileSystemProvider;Lcom/intellij/platform/eel/EelPlatform;Ljava/nio/file/Path;Ljava/lang/String;)V", "getProvider", "()Ljava/nio/file/spi/FileSystemProvider;", "getOs", "()Lcom/intellij/platform/eel/EelPlatform;", "getRootDirectory", "()Ljava/nio/file/Path;", "getFakeLocalRoot", "()Ljava/lang/String;", "root", "Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestPath;", "getRoot", "()Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestPath;", "close", "", "isOpen", "", "isReadOnly", "getSeparator", "getRootDirectories", "", "getFileStores", "Ljava/nio/file/FileStore;", "supportedFileAttributeViews", "", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "newWatchService", "Ljava/nio/file/WatchService;", "intellij.platform.testFramework.junit5.eel"})
@SourceDebugExtension(value={"SMAP\nEelUnitTestFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelUnitTestFileSystem.kt\ncom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1849#2,3:90\n*S KotlinDebug\n*F\n+ 1 EelUnitTestFileSystem.kt\ncom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem\n*L\n69#1:90,3\n*E\n"})
public final class EelUnitTestFileSystem
extends FileSystem {
    @NotNull
    private final FileSystemProvider provider;
    @NotNull
    private final EelPlatform os;
    @NotNull
    private final Path rootDirectory;
    @NotNull
    private final String fakeLocalRoot;
    @NotNull
    private final EelUnitTestPath root;

    public EelUnitTestFileSystem(@NotNull FileSystemProvider provider, @NotNull EelPlatform os, @NotNull Path rootDirectory, @NotNull String fakeLocalRoot) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter((Object)fakeLocalRoot, (String)"fakeLocalRoot");
        this.provider = provider;
        this.os = os;
        this.rootDirectory = rootDirectory;
        this.fakeLocalRoot = fakeLocalRoot;
        this.root = new EelUnitTestPath(this, this.rootDirectory);
    }

    @NotNull
    public final FileSystemProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final EelPlatform getOs() {
        return this.os;
    }

    @NotNull
    public final Path getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public final String getFakeLocalRoot() {
        return this.fakeLocalRoot;
    }

    @NotNull
    public final EelUnitTestPath getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @Nullable
    public String getSeparator() {
        return SystemInfo.isWindows ? "\\" : "/";
    }

    @Override
    @NotNull
    public Iterable<Path> getRootDirectories() {
        return CollectionsKt.listOf((Object)this.root);
    }

    @Override
    @Nullable
    public Iterable<FileStore> getFileStores() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public Set<String> supportedFileAttributeViews() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        String remaining;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        String string = StringsKt.startsWith$default((String)first, (String)this.fakeLocalRoot, (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)first, (String)this.fakeLocalRoot, null, (int)2, null) : (StringsKt.startsWith$default((String)first, (String)StringsKt.replace$default((String)this.fakeLocalRoot, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)first, (String)StringsKt.replace$default((String)this.fakeLocalRoot, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), null, (int)2, null) : (remaining = StringsKt.startsWith$default((CharSequence)StringsKt.replace$default((String)first, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (char)'/', (boolean)false, (int)2, null) ? first : null));
        if (remaining != null) {
            void $this$fold$iv;
            if (((CharSequence)remaining).length() == 0) {
                return new EelUnitTestPath(this, this.rootDirectory);
            }
            String[] stringArray = new String[]{"/"};
            List parts = StringsKt.split$default((CharSequence)StringsKt.drop((String)remaining, (int)1), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable iterable = CollectionsKt.plus((Collection)parts, (Object[])more);
            Path initial$iv = this.rootDirectory;
            boolean $i$f$fold = false;
            Path accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p1;
                String string2 = (String)element$iv;
                Path p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.resolve((String)p1);
            }
            Path original = accumulator$iv;
            return new EelUnitTestPath(this, original);
        }
        Path path = this.rootDirectory.getFileSystem().getPath(first, Arrays.copyOf(more, more.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new EelUnitTestPath(this, path);
    }

    @Override
    @Nullable
    public PathMatcher getPathMatcher(@Nullable String syntaxAndPattern) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public WatchService newWatchService() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

