/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.junit5.eel.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelMachineResolver;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProvider;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.testFramework.junit5.eel.fixture.IsolatedFileSystem;
import com.intellij.platform.testFramework.junit5.eel.impl.EelTestDescriptor;
import com.intellij.platform.testFramework.junit5.eel.impl.EelTestPosixApi;
import com.intellij.platform.testFramework.junit5.eel.impl.EelTestWindowsApi;
import com.intellij.platform.testFramework.junit5.eel.impl.IsolatedFileSystemImpl;
import com.intellij.platform.testFramework.junit5.eel.impl.UtilKt;
import com.intellij.platform.testFramework.junit5.eel.impl.nio.EelUnitTestFileSystem;
import com.intellij.platform.testFramework.junit5.eel.impl.nio.EelUnitTestFileSystemProvider;
import com.intellij.testFramework.junit5.fixture.TestContext;
import com.intellij.testFramework.junit5.fixture.TestFixture;
import com.intellij.testFramework.junit5.fixture.TestFixtureInitializer;
import com.intellij.util.io.Ksuid;
import com.intellij.util.io.PathKt;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assumptions;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"FAKE_WINDOWS_ROOT", "", "name", "Lcom/intellij/platform/eel/EelPlatform;", "getName", "(Lcom/intellij/platform/eel/EelPlatform;)Ljava/lang/String;", "currentOs", "getCurrentOs", "()Lcom/intellij/platform/eel/EelPlatform;", "eelApiByOs", "Lcom/intellij/platform/eel/EelApi;", "fileSystem", "Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;", "descriptor", "Lcom/intellij/platform/testFramework/junit5/eel/impl/EelTestDescriptor;", "os", "eelInitializer", "Lcom/intellij/testFramework/junit5/fixture/TestFixtureInitializer;", "Lcom/intellij/platform/testFramework/junit5/eel/fixture/IsolatedFileSystem;", "eelTempDirectoryFixture", "Ljava/nio/file/Path;", "Lcom/intellij/testFramework/junit5/fixture/TestFixture;", "checkMultiRoutingFileSystem", "", "intellij.platform.testFramework.junit5.eel"})
public final class UtilKt {
    @NotNull
    public static final String FAKE_WINDOWS_ROOT = "\\\\dummy-ij-root\\test-eel\\";

    private static final String getName(EelPlatform $this$name) {
        String string;
        EelPlatform eelPlatform = $this$name;
        if (eelPlatform instanceof EelPlatform.Posix) {
            string = "posix";
        } else if (eelPlatform instanceof EelPlatform.Windows) {
            string = "windows";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final EelPlatform getCurrentOs() {
        return SystemInfo.isWindows ? (EelPlatform)new EelPlatform.Windows((EelPlatform.Arch)EelPlatform.Arch.Unknown.INSTANCE) : (EelPlatform)new EelPlatform.Linux((EelPlatform.Arch)EelPlatform.Arch.Unknown.INSTANCE);
    }

    @NotNull
    public static final EelApi eelApiByOs(@NotNull EelUnitTestFileSystem fileSystem, @NotNull EelTestDescriptor descriptor, @NotNull EelPlatform os) {
        EelApi eelApi;
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        EelPlatform eelPlatform = os;
        if (eelPlatform instanceof EelPlatform.Posix) {
            eelApi = (EelApi)new EelTestPosixApi(descriptor, fileSystem, fileSystem.getFakeLocalRoot());
        } else if (eelPlatform instanceof EelPlatform.Windows) {
            eelApi = (EelApi)new EelTestWindowsApi(descriptor, fileSystem, fileSystem.getFakeLocalRoot());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return eelApi;
    }

    @NotNull
    public static final TestFixtureInitializer<IsolatedFileSystem> eelInitializer(@NotNull EelPlatform os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return new TestFixtureInitializer(os){
            final /* synthetic */ EelPlatform $os;
            {
                this.$os = $os;
            }

            public final Object initFixture(TestFixtureInitializer.R<IsolatedFileSystem> $this$TestFixtureInitializer, TestContext initialized, Continuation<? super TestFixtureInitializer.InitializedTestFixture<IsolatedFileSystem>> $completion) {
                String string;
                UtilKt.checkMultiRoutingFileSystem();
                String meaningfulDirName = "eel-fixture-" + UtilKt.access$getName(this.$os);
                Path directory = Files.createTempDirectory(meaningfulDirName, new FileAttribute[0]);
                if (SystemInfo.isUnix) {
                    Intrinsics.checkNotNull((Object)directory);
                    string = "/eel-test-" + PathsKt.getName((Path)directory);
                } else {
                    Intrinsics.checkNotNull((Object)directory);
                    string = "\\\\eel-test\\" + PathsKt.getName((Path)directory);
                }
                String fakeRoot = string;
                FileSystemProvider defaultProvider = FileSystems.getDefault().provider();
                Intrinsics.checkNotNull((Object)defaultProvider);
                EelUnitTestFileSystem fakeLocalFileSystem = new EelUnitTestFileSystem(new EelUnitTestFileSystemProvider(defaultProvider), this.$os, directory, fakeRoot);
                AtomicReference<Object> apiRef = new AtomicReference<Object>(null);
                String string2 = Ksuid.generate();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generate(...)");
                String id = string2;
                Path path = Paths.get(fakeRoot, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                EelTestDescriptor descriptor = new EelTestDescriptor(path, id, this.$os.getOsFamily());
                Disposable disposable = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                MultiRoutingFileSystemBackend.EP_NAME.getPoint().registerExtension((Object)new MultiRoutingFileSystemBackend(fakeRoot, fakeLocalFileSystem){
                    final /* synthetic */ String $fakeRoot;
                    final /* synthetic */ EelUnitTestFileSystem $fakeLocalFileSystem;
                    {
                        this.$fakeRoot = $fakeRoot;
                        this.$fakeLocalFileSystem = $fakeLocalFileSystem;
                    }

                    public FileSystem compute(FileSystem localFS, String sanitizedPath) {
                        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
                        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
                        return StringsKt.startsWith$default((String)sanitizedPath, (String)this.$fakeRoot, (boolean)false, (int)2, null) ? (FileSystem)this.$fakeLocalFileSystem : null;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Collection<String> getCustomRoots() {
                        void $this$mapTo$iv$iv;
                        Iterable<Path> $this$map$iv = this.$fakeLocalFileSystem.getRootDirectories();
                        boolean $i$f$map = false;
                        Iterable<Path> iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Path path = (Path)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.toString());
                        }
                        return (List)destination$iv$iv;
                    }

                    public Collection<FileStore> getCustomFileStores(FileSystem localFS) {
                        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
                        List list = this.$fakeLocalFileSystem.getFileStores();
                        return list != null && (list = CollectionsKt.filterNotNull(list)) != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
                    }
                }, disposable2);
                EelMachine machine2 = new EelMachine(id, apiRef, descriptor){
                    private final String internalName;
                    final /* synthetic */ AtomicReference<EelApi> $apiRef;
                    final /* synthetic */ EelTestDescriptor $descriptor;
                    {
                        this.$apiRef = $apiRef;
                        this.$descriptor = $descriptor;
                        this.internalName = "mock-" + $id;
                    }

                    public String getInternalName() {
                        return this.internalName;
                    }

                    public Object toEelApi(EelDescriptor descriptor, Continuation<? super EelApi> $completion) {
                        EelApi eelApi = this.$apiRef.get();
                        Intrinsics.checkNotNullExpressionValue((Object)eelApi, (String)"get(...)");
                        return eelApi;
                    }

                    public boolean ownsPath(Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        return Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)path), (Object)this.$descriptor);
                    }
                };
                EelMachineResolver.Companion.getEP_NAME().getPoint().registerExtension((Object)new EelMachineResolver(descriptor, machine2){
                    final /* synthetic */ EelTestDescriptor $descriptor;
                    final /* synthetic */ EelMachine $machine;
                    {
                        this.$descriptor = $descriptor;
                        this.$machine = $machine;
                    }

                    public EelMachine getResolvedEelMachine(EelDescriptor eelDescriptor) {
                        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
                        return Intrinsics.areEqual((Object)eelDescriptor, (Object)this.$descriptor) ? this.$machine : null;
                    }

                    public Object resolveEelMachine(EelDescriptor eelDescriptor, Continuation<? super EelMachine> $completion) {
                        return this.getResolvedEelMachine(eelDescriptor);
                    }

                    public Object resolveEelMachineByInternalName(String internalName, Continuation<? super EelMachine> $completion) {
                        return Intrinsics.areEqual((Object)internalName, (Object)this.$machine.getInternalName()) ? this.$machine : null;
                    }
                }, disposable2);
                EelProvider.Companion.getEP_NAME().getPoint().registerExtension((Object)new EelProvider(descriptor, machine2, fakeRoot){
                    final /* synthetic */ EelTestDescriptor $descriptor;
                    final /* synthetic */ EelMachine $machine;
                    final /* synthetic */ String $fakeRoot;
                    {
                        this.$descriptor = $descriptor;
                        this.$machine = $machine;
                        this.$fakeRoot = $fakeRoot;
                    }

                    public Object tryInitialize(String path, Continuation<? super EelMachine> $completion) {
                        Path path2 = Paths.get(path, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                        return Intrinsics.areEqual((Object)this.getEelDescriptor(path2), (Object)this.$descriptor) ? this.$machine : null;
                    }

                    public EelDescriptor getEelDescriptor(Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        return path.startsWith(Path.of(this.$fakeRoot, new String[0])) ? (EelDescriptor)this.$descriptor : null;
                    }

                    public Collection<String> getCustomRoots(EelDescriptor eelDescriptor) {
                        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
                        return Intrinsics.areEqual((Object)eelDescriptor, (Object)this.$descriptor) ? (Collection)CollectionsKt.listOf((Object)this.$fakeRoot) : null;
                    }
                }, disposable2);
                EelApi eelApi = UtilKt.eelApiByOs(fakeLocalFileSystem, descriptor, this.$os);
                apiRef.set(eelApi);
                Path root = Path.of(fakeRoot, new String[0]);
                Intrinsics.checkNotNull((Object)root);
                return $this$TestFixtureInitializer.initialized((Object)new IsolatedFileSystemImpl(root, (EelDescriptor)descriptor, eelApi), (Function1)new Function1<Continuation<? super Unit>, Object>(disposable2, directory, null){
                    int label;
                    final /* synthetic */ Disposable $disposable;
                    final /* synthetic */ Path $directory;
                    {
                        this.$disposable = $disposable;
                        this.$directory = $directory;
                        super(1, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Disposer.dispose((Disposable)this.$disposable);
                                Path path = this.$directory;
                                Intrinsics.checkNotNull((Object)path);
                                PathKt.delete((Path)path, (boolean)true);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        };
    }

    @NotNull
    public static final TestFixtureInitializer<Path> eelTempDirectoryFixture(@NotNull TestFixture<? extends IsolatedFileSystem> fileSystem) {
        Intrinsics.checkNotNullParameter(fileSystem, (String)"fileSystem");
        return new TestFixtureInitializer(fileSystem){
            final /* synthetic */ TestFixture<IsolatedFileSystem> $fileSystem;
            {
                this.$fileSystem = $fileSystem;
            }

            /*
             * Unable to fully structure code
             */
            public final Object initFixture(TestFixtureInitializer.R<Path> $this$TestFixtureInitializer, TestContext initialized, Continuation<? super TestFixtureInitializer.InitializedTestFixture<Path>> $completion) {
                if (!($completion instanceof eelTempDirectoryFixture.initFixture.1)) ** GOTO lbl-1000
                var19_4 = $completion;
                if ((var19_4.label & -2147483648) != 0) {
                    var19_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ eelTempDirectoryFixture.1<T> this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.initFixture(null, null, (Continuation<TestFixtureInitializer.InitializedTestFixture<Path>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = $this$TestFixtureInitializer;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialized);
                        $continuation.label = 1;
                        v0 = $this$TestFixtureInitializer.init(this.$fileSystem, (Continuation)$continuation);
                        if (v0 == var20_6) {
                            return var20_6;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        initialized = (TestContext)$continuation.L$1;
                        $this$TestFixtureInitializer = (TestFixtureInitializer.R)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        fsdata = (IsolatedFileSystem)v0;
                        eelApi = fsdata.getEelApi();
                        $this$getOrThrow_u24default$iv = (OwnedBuilder)EelFileSystemApiHelpersKt.createTemporaryDirectory((EelFileSystemApi)eelApi.getFs());
                        $i$f$getOrThrow = 0;
                        $continuation.L$0 = $this$TestFixtureInitializer;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialized);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fsdata);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$getOrThrow_u24default$iv);
                        $continuation.I$0 = $i$f$getOrThrow;
                        $continuation.label = 2;
                        v1 = $this$getOrThrow_u24default$iv.eelIt((Continuation)$continuation);
                        if (v1 == var20_6) {
                            return var20_6;
                        }
                        ** GOTO lbl48
                    }
                    case 2: {
                        $i$f$getOrThrow = $continuation.I$0;
                        $this$getOrThrow_u24default$iv = (OwnedBuilder)$continuation.L$4;
                        eelApi = (EelApi)$continuation.L$3;
                        fsdata = (IsolatedFileSystem)$continuation.L$2;
                        initialized = (TestContext)$continuation.L$1;
                        $this$TestFixtureInitializer = (TestFixtureInitializer.R)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl48:
                        // 2 sources

                        $this$getOrThrow$iv$iv = (EelResult)v1;
                        $i$f$getOrThrow = false;
                        $this$getOr$iv$iv$iv = $this$getOrThrow$iv$iv;
                        $i$f$getOr = false;
                        var13_18 = $this$getOr$iv$iv$iv;
                        if (!(var13_18 instanceof EelResult.Ok)) {
                            if (var13_18 instanceof EelResult.Error) {
                                it$iv$iv = (EelResult.Error)$this$getOr$iv$iv$iv;
                                $i$a$-getOr-EelResultKt$getOrThrow$2$iv$iv = false;
                                var16_21 = it$iv$iv.getError();
                                $i$a$-getOrThrow-EelResultKt$getOrThrow$4 = false;
                                it = var16_21;
                                throw it instanceof Throwable != false ? (Throwable)it : (Throwable)new RuntimeException(String.valueOf(it));
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        tempDir = (EelPath)((EelResult.Ok)$this$getOr$iv$iv$iv).getValue();
                        nioTempDir = EelNioBridgeServiceKt.asNioPath((EelPath)tempDir);
                        return $this$TestFixtureInitializer.initialized((Object)nioTempDir, (Function1)new Function1<Continuation<? super Unit>, Object>(nioTempDir, null){
                            int label;
                            final /* synthetic */ Path $nioTempDir;
                            {
                                this.$nioTempDir = $nioTempDir;
                                super(1, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        PathKt.delete((Path)this.$nioTempDir, (boolean)true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    public static final void checkMultiRoutingFileSystem() {
        Assumptions.assumeTrue((boolean)(FileSystems.getDefault() instanceof MultiRoutingFileSystem), (String)"Please enable `-Djava.nio.file.spi.DefaultFileSystemProvider=com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider`");
    }

    public static final /* synthetic */ String access$getName(EelPlatform $receiver) {
        return UtilKt.getName($receiver);
    }
}

