/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.junit5.eel.impl.nio;

import com.intellij.platform.testFramework.junit5.eel.impl.nio.EelUnitTestFileSystem;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J!\u0010!\u001a\u00020\u00012\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0016\u00a2\u0006\u0002\u0010%JC\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0014\u0010*\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030+\u0018\u00010#2\u0016\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-0#\"\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010.J\u0012\u0010/\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0082\u0004J\u0014\u00100\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u000101H\u0096\u0082\u0004J\n\u00102\u001a\u000203H\u0096\u0080\u0004J\n\u00104\u001a\u00020\u0012H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00065"}, d2={"Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestPath;", "Ljava/nio/file/Path;", "fileSystem", "Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;", "delegate", "<init>", "(Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;Ljava/nio/file/Path;)V", "getFileSystem", "()Lcom/intellij/platform/testFramework/junit5/eel/impl/nio/EelUnitTestFileSystem;", "getDelegate", "()Ljava/nio/file/Path;", "Ljava/nio/file/FileSystem;", "isAbsolute", "", "getRoot", "getFileName", "getParent", "getNameCount", "", "getName", "index", "subpath", "beginIndex", "endIndex", "startsWith", "other", "endsWith", "normalize", "resolve", "relativize", "toUri", "Ljava/net/URI;", "toAbsolutePath", "toRealPath", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "register", "Ljava/nio/file/WatchKey;", "watcher", "Ljava/nio/file/WatchService;", "events", "Ljava/nio/file/WatchEvent$Kind;", "modifiers", "Ljava/nio/file/WatchEvent$Modifier;", "(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;", "compareTo", "equals", "", "toString", "", "hashCode", "intellij.platform.testFramework.junit5.eel"})
public final class EelUnitTestPath
implements Path {
    @NotNull
    private final EelUnitTestFileSystem fileSystem;
    @NotNull
    private final Path delegate;

    public EelUnitTestPath(@NotNull EelUnitTestFileSystem fileSystem, @NotNull Path delegate) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.fileSystem = fileSystem;
        this.delegate = delegate;
        if (!(!(this.delegate instanceof EelUnitTestPath))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public final EelUnitTestFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    @NotNull
    public EelUnitTestPath getRoot() {
        return this.fileSystem.getRoot();
    }

    @Override
    @Nullable
    public Path getFileName() {
        Path path = this.delegate.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @Nullable
    public Path getParent() {
        Path path = this.delegate.getParent();
        if (path == null) {
            return null;
        }
        Path parent = path;
        return new EelUnitTestPath(this.fileSystem, parent);
    }

    @Override
    public int getNameCount() {
        if (Intrinsics.areEqual((Object)this.delegate, (Object)this.fileSystem.getRoot().delegate)) {
            return 0;
        }
        return this.delegate.getNameCount() - this.getRoot().delegate.getNameCount();
    }

    @Override
    @NotNull
    public Path getName(int index) {
        Path path = this.delegate.getName(index + this.getRoot().delegate.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getName(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public Path subpath(int beginIndex, int endIndex) {
        Path path = this.delegate.subpath(beginIndex + this.getRoot().delegate.getNameCount(), endIndex + this.getRoot().delegate.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"subpath(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof EelUnitTestPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.delegate.startsWith(((EelUnitTestPath)other).delegate);
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof EelUnitTestPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.delegate.endsWith(((EelUnitTestPath)other).delegate);
    }

    @Override
    @NotNull
    public Path normalize() {
        Path path = this.delegate.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public Path resolve(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof EelUnitTestPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = this.delegate.resolve(((EelUnitTestPath)other).delegate);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public Path relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof EelUnitTestPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = this.delegate.relativize(((EelUnitTestPath)other).delegate);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public URI toUri() {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public Path toAbsolutePath() {
        Path path = this.delegate.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public Path toRealPath(LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Path path = this.delegate.toRealPath(Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toRealPath(...)");
        return new EelUnitTestPath(this.fileSystem, path);
    }

    @Override
    @NotNull
    public WatchKey register(@NotNull WatchService watcher, @Nullable WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        WatchKey watchKey = this.delegate.register(watcher, events, Arrays.copyOf(modifiers, modifiers.length));
        Intrinsics.checkNotNullExpressionValue((Object)watchKey, (String)"register(...)");
        return watchKey;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof EelUnitTestPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.delegate.compareTo(((EelUnitTestPath)other).delegate);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof EelUnitTestPath && Intrinsics.areEqual((Object)((EelUnitTestPath)other).fileSystem, (Object)this.fileSystem) && Intrinsics.areEqual((Object)((EelUnitTestPath)other).delegate, (Object)this.delegate);
    }

    @Override
    @NotNull
    public String toString() {
        Object object;
        if (this.isAbsolute()) {
            if (this.delegate.getNameCount() == 0) {
                return this.fileSystem.getFakeLocalRoot();
            }
            String string = this.fileSystem.getFakeLocalRoot();
            String string2 = ((Object)this.delegate).toString().substring(((Object)this.fileSystem.getRootDirectory()).toString().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = string + string2;
        } else {
            object = ((Object)this.delegate).toString();
        }
        return object;
    }

    @Override
    public int hashCode() {
        int result = this.fileSystem.hashCode();
        result = 31 * result + ((Object)this.delegate).hashCode();
        return result;
    }
}

