/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.testFramework.junit5.LogTestName;
import com.intellij.util.containers.UtilKt;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Optional;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.DynamicTestInvocationContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000f\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/junit5/LogTestName;", "Lorg/junit/jupiter/api/extension/InvocationInterceptor;", "<init>", "()V", "interceptTestTemplateMethod", "", "invocation", "Lorg/junit/jupiter/api/extension/InvocationInterceptor$Invocation;", "Ljava/lang/Void;", "invocationContext", "Lorg/junit/jupiter/api/extension/ReflectiveInvocationContext;", "Ljava/lang/reflect/Method;", "extensionContext", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "interceptTestMethod", "interceptDynamicTest", "Lorg/junit/jupiter/api/extension/DynamicTestInvocationContext;", "runTest", "getStackTrace", "", "cause", "", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.testFramework.junit5"})
@SourceDebugExtension(value={"SMAP\nLogTestName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTestName.kt\ncom/intellij/testFramework/junit5/LogTestName\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n2343#2,7:86\n*S KotlinDebug\n*F\n+ 1 LogTestName.kt\ncom/intellij/testFramework/junit5/LogTestName\n*L\n44#1:86,7\n*E\n"})
public final class LogTestName
implements InvocationInterceptor {
    public void interceptTestTemplateMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.runTest(extensionContext, invocation);
    }

    public void interceptTestMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.runTest(extensionContext, invocation);
    }

    public void interceptDynamicTest(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull DynamicTestInvocationContext invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter((Object)invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.runTest(extensionContext, invocation);
    }

    /*
     * WARNING - void declaration
     */
    private final void runTest(ExtensionContext extensionContext, InvocationInterceptor.Invocation<Void> invocation) {
        void $this$reduce$iv;
        Logger logger = this.getLogger(extensionContext);
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)extensionContext, LogTestName::runTest$lambda$0), (Function1)runTest.displayName.2.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void parent;
            String string = (String)iterator$iv.next();
            String child = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = (String)parent + "::" + child;
        }
        String displayName2 = (String)accumulator$iv;
        logger.info(StringsKt.trimIndent((String)("\n        \n        =======================\n        Started a test: " + displayName2 + "\n        =======================\n      ")));
        try {
            invocation.proceed();
            logger.info(StringsKt.trimIndent((String)("\n          \n          =======================\n          The test finished successfully: " + displayName2 + "\n          =======================\n        ")));
        }
        catch (Throwable err) {
            logger.info(StringsKt.trimMargin$default((String)("\n          |\n          |=======================\n          |The test failed: " + displayName2 + "\n          |" + this.getStackTrace(err) + "\n          |=======================\n        "), null, (int)1, null));
            throw err;
        }
    }

    private final String getStackTrace(Throwable cause) {
        StringBuilder stringBuilder;
        StringBuilder $this$getStackTrace_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getStackTrace_u24lambda_u240.append(ExceptionsKt.stackTraceToString((Throwable)cause));
        if (cause instanceof ExceptionWithAttachments) {
            Attachment[] attachmentArray = ((ExceptionWithAttachments)cause).getAttachments();
            Intrinsics.checkNotNullExpressionValue((Object)attachmentArray, (String)"getAttachments(...)");
            for (Attachment attachment : attachmentArray) {
                Intrinsics.checkNotNull((Object)attachment);
                Attachment attachment2 = attachment;
                $this$getStackTrace_u24lambda_u240.append("\n*** Attachment: " + attachment2.getDisplayText() + "\n");
                $this$getStackTrace_u24lambda_u240.append(attachment2.getEncodedBytes());
            }
        }
        return stringBuilder.toString();
    }

    private final Logger getLogger(ExtensionContext extensionContext) {
        Logger logger = Logger.getInstance(extensionContext.getTestClass().orElse(this.getClass()));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final ExtensionContext runTest$lambda$0(ExtensionContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Optional optional = it.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getParent(...)");
        return (ExtensionContext)UtilKt.orNull((Optional)optional);
    }
}

