/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.junit5.TestDisposable;
import com.intellij.testFramework.junit5.impl.TestDisposableExtensionKt;
import com.intellij.testFramework.junit5.impl.TypedStoreKey;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/junit5/impl/TestDisposableExtension;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "<init>", "()V", "beforeEach", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "supportsParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "resolveParameter", "", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class TestDisposableExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object instance = context.getRequiredTestInstance();
        for (Field field : AnnotationUtils.findAnnotatedFields(instance.getClass(), TestDisposable.class, ReflectionUtils::isNotStatic)) {
            ReflectionUtils.makeAccessible((Field)field).set(instance, TestDisposableExtensionKt.access$testDisposable(context));
        }
    }

    public void afterEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CheckedDisposable checkedDisposable = (CheckedDisposable)TypedStoreKey.Companion.get(context, TestDisposableExtensionKt.access$getTestDisposableKey$p());
        if (checkedDisposable == null) {
            return;
        }
        CheckedDisposable disposable = checkedDisposable;
        Assertions.assertFalse((boolean)disposable.isDisposed());
        Disposer.dispose((Disposable)((Disposable)disposable));
    }

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        return parameterContext.getParameter().getType() == Disposable.class && parameterContext.isAnnotated(TestDisposable.class);
    }

    @NotNull
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        return TestDisposableExtensionKt.access$testDisposable(extensionContext);
    }
}

