/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.impl;

import com.intellij.testFramework.TestLoggerFactory;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\u001a\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/junit5/impl/TestLoggerExtension;", "Lorg/junit/jupiter/api/extension/BeforeTestExecutionCallback;", "Lorg/junit/jupiter/api/extension/TestWatcher;", "<init>", "()V", "beforeTestExecution", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "testSuccessful", "testDisabled", "reason", "Ljava/util/Optional;", "", "testAborted", "cause", "", "testFailed", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class TestLoggerExtension
implements BeforeTestExecutionCallback,
TestWatcher {
    public void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TestLoggerFactory.onTestStarted();
    }

    public void testSuccessful(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TestLoggerFactory.onTestFinished((boolean)true, (String)context.getUniqueId());
    }

    public void testDisabled(@NotNull ExtensionContext context, @Nullable Optional<String> reason) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TestLoggerFactory.onTestFinished((boolean)true, (String)context.getUniqueId());
    }

    public void testAborted(@NotNull ExtensionContext context, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.testFailed(context, cause);
    }

    public void testFailed(@NotNull ExtensionContext context, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TestLoggerFactory.logTestFailure((Throwable)cause);
        TestLoggerFactory.onTestFinished((boolean)false, (String)context.getUniqueId());
    }
}

