/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorSplitterState;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.FileEditorManagerTestCaseKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.io.PathKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000eH\u0004R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/FileEditorManagerTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "<init>", "()V", "manager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "setUp", "", "getProjectDescriptor", "Lcom/intellij/testFramework/LightProjectDescriptor;", "tearDown", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "createTempFile", "content", "", "openFiles", "femSerialisedText", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nFileEditorManagerTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileEditorManagerTestCase.kt\ncom/intellij/testFramework/FileEditorManagerTestCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,103:1\n1#2:104\n58#3:105\n*S KotlinDebug\n*F\n+ 1 FileEditorManagerTestCase.kt\ncom/intellij/testFramework/FileEditorManagerTestCase\n*L\n69#1:105\n*E\n"})
public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    @JvmField
    @Nullable
    protected FileEditorManagerImpl manager;

    @Override
    public void setUp() {
        super.setUp();
        Project project = this.getProject();
        project.putUserData(FileEditorManagerKeys.ALLOW_IN_LIGHT_PROJECT, (Object)true);
        Intrinsics.checkNotNull((Object)project);
        this.manager = new FileEditorManagerImpl(project, CoroutineScopeKt.childScope$default((CoroutineScope)((ComponentManagerEx)project).getCoroutineScope(), null, (boolean)false, (int)3, null));
        ComponentManager componentManager = (ComponentManager)project;
        FileEditorManagerImpl fileEditorManagerImpl = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        ServiceContainerUtil.replaceService(componentManager, FileEditorManager.class, fileEditorManagerImpl, disposable);
        FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)fileEditorProviderManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl");
        ((FileEditorProviderManagerImpl)fileEditorProviderManager).clearSelectedProviders();
        if (!(DockManager.getInstance((Project)project).getContainers().size() == 1)) {
            boolean bl = false;
            String string = "The previous test didn't clear the state";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return FileEditorManagerTestCaseKt.access$getCUSTOM_PROJECT_DESCRIPTOR$p();
    }

    @Override
    protected void tearDown() throws Exception {
        Project project = this.getProject();
        Function0[] function0Array = new Function0[]{() -> FileEditorManagerTestCase.tearDown$lambda$0(this), () -> FileEditorManagerTestCase.tearDown$lambda$1(project), FileEditorManagerTestCase::tearDown$lambda$2, () -> FileEditorManagerTestCase.tearDown$lambda$3(this), () -> FileEditorManagerTestCase.tearDown$lambda$4(this, project), () -> FileEditorManagerTestCase.tearDown$lambda$5(this)};
        RunAllKt.runAll((Function0[])function0Array);
    }

    @NotNull
    protected final VirtualFile getFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file);
        VirtualFile virtualFile = file;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @NotNull
    protected final VirtualFile createTempFile(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String[] stringArray = new String[]{path};
        Path io = Path.of(FileUtil.getTempDirectory(), stringArray);
        Intrinsics.checkNotNull((Object)io);
        PathKt.write((Path)io, (byte[])content);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(io);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + io), (Object)file);
        VirtualFile virtualFile = file;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    protected final void openFiles(@NotNull String femSerialisedText) {
        Intrinsics.checkNotNullParameter((Object)femSerialisedText, (String)"femSerialisedText");
        Element element = JDOMUtil.load((CharSequence)femSerialisedText);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element rootElement = element;
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TasksKt.runWithModalProgressBlocking((Project)project, (String)"", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rootElement, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Element $rootElement;
            {
                this.this$0 = $receiver;
                this.$rootElement = $rootElement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.this$0.manager;
                        Intrinsics.checkNotNull((Object)v0);
                        this.label = 1;
                        v1 = EditorsSplitters.restoreEditors$default((EditorsSplitters)v0.getMainSplitters(), (EditorSplitterState)new EditorSplitterState(this.$rootElement), (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        v2 = this.this$0.manager;
                        Intrinsics.checkNotNull((Object)v2);
                        $this$forEach$iv = SequencesKt.flatMap((Sequence)v2.getMainSplitters().windows(), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.fileEditor.impl.EditorWindow ), (Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)Lkotlin/sequences/Sequence;)());
                        $i$f$forEach = 0;
                        var4_5 = $this$forEach$iv.iterator();
lbl20:
                        // 3 sources

                        while (var4_5.hasNext()) {
                            element$iv = var4_5.next();
                            it = (EditorComposite)element$iv;
                            $i$a$-forEach-FileEditorManagerTestCase$openFiles$1$2 = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            this.L$1 = var4_5;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                            this.I$0 = $i$f$forEach;
                            this.I$1 = $i$a$-forEach-FileEditorManagerTestCase$openFiles$1$2;
                            this.label = 2;
                            v3 = it.waitForAvailable((Continuation)this);
                            if (v3 != var8_2) continue;
                            return var8_2;
                        }
                        break;
                    }
                    case 2: {
                        $i$a$-forEach-FileEditorManagerTestCase$openFiles$1$2 = this.I$1;
                        $i$f$forEach = this.I$0;
                        it = (EditorComposite)this.L$3;
                        element$iv = this.L$2;
                        var4_5 = (Iterator)this.L$1;
                        $this$forEach$iv = (Sequence)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl20
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Sequence invokeSuspend$lambda$0(EditorWindow it) {
                return it.composites();
            }
        }));
    }

    private static final Unit tearDown$lambda$0(FileEditorManagerTestCase this$0) {
        block0: {
            FileEditorManagerImpl fileEditorManagerImpl = this$0.manager;
            if (fileEditorManagerImpl == null) break block0;
            fileEditorManagerImpl.closeAllFiles();
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$1(Project $project) {
        if ($project != null) {
            EditorHistoryManager.Companion.getInstance($project).removeAllFiles();
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$2() {
        FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)fileEditorProviderManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl");
        ((FileEditorProviderManagerImpl)fileEditorProviderManager).clearSelectedProviders();
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$3(FileEditorManagerTestCase this$0) {
        block0: {
            FileEditorManagerImpl fileEditorManagerImpl = this$0.manager;
            if (fileEditorManagerImpl == null) break block0;
            FileEditorManagerImpl it = fileEditorManagerImpl;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$4(FileEditorManagerTestCase this$0, Project $project) {
        this$0.manager = null;
        if ($project != null) {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)$project;
            boolean $i$f$serviceIfCreated = false;
            Object object = (DockManager)$this$serviceIfCreated$iv.getServiceIfCreated(DockManager.class);
            if (object == null || (object = object.getContainers()) == null) {
                object = SetsKt.emptySet();
            }
            BasePlatformTestCase.assertSize(1, (Collection)object);
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$5(FileEditorManagerTestCase this$0) {
        super.tearDown();
        return Unit.INSTANCE;
    }
}

