/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.OutOfProcessRetries;
import java.io.IOException;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnit5OutOfProcessRetrySessionListener
implements LauncherSessionListener {
    private long suiteStarted = 0L;
    private OutOfProcessRetries.OutOfProcessRetryListener listener;

    public void launcherSessionOpened(LauncherSession session) {
        if (this.listener == null) {
            this.listener = OutOfProcessRetries.getListenerForOutOfProcessRetry();
        }
        if (this.listener == null) {
            return;
        }
        session.getLauncher().registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

            public void testPlanExecutionStarted(TestPlan testPlan) {
                JUnit5OutOfProcessRetrySessionListener.this.suiteStarted = System.nanoTime();
            }

            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                TestExecutionResult.Status status = testExecutionResult.getStatus();
                Throwable throwable = testExecutionResult.getThrowable().orElse(null);
                if (status != TestExecutionResult.Status.FAILED) {
                    return;
                }
                testIdentifier.getSource().map(testSource -> {
                    String string;
                    if (testSource instanceof MethodSource) {
                        MethodSource ms = (MethodSource)testSource;
                        string = ms.getClassName();
                    } else if (testSource instanceof ClassSource) {
                        ClassSource cs = (ClassSource)testSource;
                        string = cs.getClassName();
                    } else {
                        string = null;
                    }
                    return string;
                }).ifPresent(className -> JUnit5OutOfProcessRetrySessionListener.this.listener.addError(className, throwable));
            }
        }});
    }

    public void launcherSessionClosed(LauncherSession session) {
        if (this.listener == null || this.suiteStarted == 0L) {
            return;
        }
        try {
            this.listener.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

