/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"findReferenceByText", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/PsiFile;", "str", "", "refOffset", "", "findAllReferencesByText", "Lkotlin/sequences/Sequence;", "findInInjected", "psiFile", "pos", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nPsiTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiTestUtil.kt\ncom/intellij/testFramework/PsiTestUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,38:1\n19#2:39\n*S KotlinDebug\n*F\n+ 1 PsiTestUtil.kt\ncom/intellij/testFramework/PsiTestUtilKt\n*L\n34#1:39\n*E\n"})
public final class PsiTestUtilKt {
    @JvmOverloads
    @NotNull
    public static final PsiReference findReferenceByText(@NotNull PsiFile $this$findReferenceByText, @NotNull String str, int refOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$findReferenceByText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        PsiReference psiReference = (PsiReference)SequencesKt.firstOrNull(PsiTestUtilKt.findAllReferencesByText($this$findReferenceByText, str, refOffset));
        if (psiReference == null) {
            throw new AssertionError((Object)("can't find reference for '" + str + "'"));
        }
        return psiReference;
    }

    public static /* synthetic */ PsiReference findReferenceByText$default(PsiFile psiFile, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string.length() / 2;
        }
        return PsiTestUtilKt.findReferenceByText(psiFile, string, n);
    }

    @JvmOverloads
    @NotNull
    public static final Sequence<PsiReference> findAllReferencesByText(@NotNull PsiFile $this$findAllReferencesByText, @NotNull String str, int refOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$findAllReferencesByText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Ref.IntRef offset = new Ref.IntRef();
        offset.element = refOffset;
        if (offset.element < 0) {
            offset.element += str.length();
        }
        String string = $this$findAllReferencesByText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return SequencesKt.map((Sequence)StringKt.allOccurrencesOf((String)string, (String)str), arg_0 -> PsiTestUtilKt.findAllReferencesByText$lambda$0(offset, $this$findAllReferencesByText, str, arg_0));
    }

    public static /* synthetic */ Sequence findAllReferencesByText$default(PsiFile psiFile, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string.length() / 2;
        }
        return PsiTestUtilKt.findAllReferencesByText(psiFile, string, n);
    }

    private static final PsiReference findInInjected(PsiFile psiFile, int pos) {
        PsiElement psiElement = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).findInjectedElementAt(psiFile, pos);
        if (psiElement == null) {
            return null;
        }
        PsiElement injected = psiElement;
        Document $this$asSafely$iv = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(injected.getContainingFile());
        boolean $i$f$asSafely = false;
        Document document = $this$asSafely$iv;
        if (!(document instanceof DocumentWindow)) {
            document = null;
        }
        DocumentWindow documentWindow = (DocumentWindow)document;
        if (documentWindow == null) {
            return null;
        }
        DocumentWindow documentWindow2 = documentWindow;
        int hostToInjected = documentWindow2.hostToInjected(pos);
        return injected.findReferenceAt(hostToInjected - PsiTreeUtilKt.getStartOffset((PsiElement)injected));
    }

    @JvmOverloads
    @NotNull
    public static final PsiReference findReferenceByText(@NotNull PsiFile $this$findReferenceByText, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$findReferenceByText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return PsiTestUtilKt.findReferenceByText$default($this$findReferenceByText, str, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final Sequence<PsiReference> findAllReferencesByText(@NotNull PsiFile $this$findAllReferencesByText, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$findAllReferencesByText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return PsiTestUtilKt.findAllReferencesByText$default($this$findAllReferencesByText, str, 0, 2, null);
    }

    private static final PsiReference findAllReferencesByText$lambda$0(Ref.IntRef $offset, PsiFile $this_findAllReferencesByText, String $str, int index) {
        int pos = index + $offset.element;
        PsiElement psiElement = $this_findAllReferencesByText.findElementAt(pos);
        if (psiElement == null) {
            throw new AssertionError((Object)("can't find element for '" + $str + "' at " + pos));
        }
        PsiElement element = psiElement;
        PsiReference psiReference = element.findReferenceAt(pos - PsiTreeUtilKt.getStartOffset((PsiElement)element));
        if (psiReference == null && (psiReference = PsiTestUtilKt.findInInjected($this_findAllReferencesByText, pos)) == null) {
            throw new AssertionError((Object)("can't find reference for '" + $str + "' at " + pos));
        }
        return psiReference;
    }
}

