/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.SyncViewManager;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.testFramework.assertion.BuildViewAssertions;
import com.intellij.platform.testFramework.assertion.collectionAssertion.CollectionAssertions;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeAssertion;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u000245B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J'\u0010\u0018\u001a\u00020\u00132\u001f\u0010\u0019\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00130\u001a\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u001a\u0010\u001e\u001a\u00020\u00132\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001aJ\u0016\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 J\"\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001aJ\u0016\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 J\"\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001aJ'\u0010(\u001a\u00020\u00132\u001f\u0010\u0019\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00130\u001a\u00a2\u0006\u0002\b\u001dJ\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020 J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010*\u001a\u00020 J\u001c\u0010)\u001a\u00020\u00132\u0014\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020\u00130\u001aJ\u0016\u0010,\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 J\"\u0010,\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001aJ\"\u0010-\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00130\u001aJ\u0016\u00100\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 J\"\u00100\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001aJ\"\u00101\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00130\u001aJ\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u00103\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u00066"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture;", "Lcom/intellij/testFramework/fixtures/IdeaTestFixture;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fixtureDisposable", "Lcom/intellij/openapi/Disposable;", "syncViewManager", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestSyncViewManager;", "buildViewManager", "Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestBuildViewManager;", "syncView", "Lcom/intellij/build/BuildView;", "getSyncView", "()Lcom/intellij/build/BuildView;", "buildView", "getBuildView", "setUp", "", "tearDown", "getSyncViewRerunActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "assertSyncViewTree", "assert", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion$Node;", "", "Lkotlin/ExtensionFunctionType;", "assertSyncViewTreeEquals", "executionTreeText", "", "assertSyncViewTreeSame", "treeTestPresentationChecker", "assertSyncViewNode", "nodeText", "consoleText", "consoleTextChecker", "assertSyncViewSelectedNode", "assertBuildViewTree", "assertBuildViewTreeEquals", "executionTree", "assertBuildViewTreeSame", "assertBuildViewNode", "assertBuildViewNodeConsole", "consoleChecker", "Lcom/intellij/execution/ui/ExecutionConsole;", "assertBuildViewSelectedNode", "assertBuildViewSelectedNodeConsole", "buildTasksNodesAsList", "treeStringPresentation", "TestSyncViewManager", "TestBuildViewManager", "intellij.platform.testFramework"})
public final class BuildViewTestFixture
implements IdeaTestFixture {
    @NotNull
    private final Project project;
    private Disposable fixtureDisposable;
    private TestSyncViewManager syncViewManager;
    private TestBuildViewManager buildViewManager;

    public BuildViewTestFixture(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final BuildView getSyncView() {
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        return testSyncViewManager.getBuildView();
    }

    private final BuildView getBuildView() {
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        return testBuildViewManager.getBuildView();
    }

    @Override
    public void setUp() throws Exception {
        Disposable disposable;
        Disposable disposable2;
        Disposable disposable3 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable(...)");
        this.fixtureDisposable = disposable3;
        ComponentManager componentManager = (ComponentManager)this.project;
        BuildContentManagerImpl buildContentManagerImpl = new BuildContentManagerImpl(this.project);
        Disposable disposable4 = this.fixtureDisposable;
        if (disposable4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
            disposable4 = null;
        }
        ServiceContainerUtil.replaceService((ComponentManager)componentManager, BuildContentManager.class, (Object)buildContentManagerImpl, (Disposable)disposable4);
        this.syncViewManager = new TestSyncViewManager(this.project);
        ComponentManager componentManager2 = (ComponentManager)this.project;
        TestSyncViewManager testSyncViewManager = this.syncViewManager;
        if (testSyncViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
            testSyncViewManager = null;
        }
        if ((disposable2 = this.fixtureDisposable) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
            disposable2 = null;
        }
        ServiceContainerUtil.replaceService((ComponentManager)componentManager2, SyncViewManager.class, (Object)((Object)testSyncViewManager), (Disposable)disposable2);
        this.buildViewManager = new TestBuildViewManager(this.project);
        ComponentManager componentManager3 = (ComponentManager)this.project;
        TestBuildViewManager testBuildViewManager = this.buildViewManager;
        if (testBuildViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
            testBuildViewManager = null;
        }
        if ((disposable = this.fixtureDisposable) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
            disposable = null;
        }
        ServiceContainerUtil.replaceService((ComponentManager)componentManager3, BuildViewManager.class, (Object)((Object)testBuildViewManager), (Disposable)disposable);
    }

    @Override
    public void tearDown() throws Exception {
        Function0[] function0Array = new Function0[]{() -> BuildViewTestFixture.tearDown$lambda$0(this), () -> BuildViewTestFixture.tearDown$lambda$1(this), () -> BuildViewTestFixture.tearDown$lambda$2(this)};
        RunAllKt.runAll((Function0[])function0Array);
    }

    @NotNull
    public final List<AnAction> getSyncViewRerunActions() {
        List list = this.getSyncView().getRestartActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRestartActions(...)");
        return list;
    }

    public final void assertSyncViewTree(@NotNull Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        BuildViewAssertions.INSTANCE.assertBuildViewTree(this.getSyncView(), function1);
    }

    public final void assertSyncViewTreeEquals(@NotNull String executionTreeText) {
        Intrinsics.checkNotNullParameter((Object)executionTreeText, (String)"executionTreeText");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getSyncView(), (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertSyncViewTreeEquals$lambda$0(executionTreeText, arg_0)));
    }

    public final void assertSyncViewTreeSame(@NotNull String executionTreeText) {
        Intrinsics.checkNotNullParameter((Object)executionTreeText, (String)"executionTreeText");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getSyncView(), (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertSyncViewTreeSame$lambda$0(this, executionTreeText, arg_0)));
    }

    public final void assertSyncViewTreeEquals(@NotNull Function1<? super String, Unit> treeTestPresentationChecker) {
        Intrinsics.checkNotNullParameter(treeTestPresentationChecker, (String)"treeTestPresentationChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getSyncView(), treeTestPresentationChecker);
    }

    public final void assertSyncViewNode(@NotNull String nodeText, @NotNull String consoleText) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getSyncView(), nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertSyncViewNode$lambda$0(consoleText, arg_0)));
    }

    public final void assertSyncViewNode(@NotNull String nodeText, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getSyncView(), nodeText, consoleTextChecker);
    }

    public final void assertSyncViewSelectedNode(@NotNull String nodeText, @NotNull String consoleText) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeIsSelected(this.getSyncView(), nodeText);
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getSyncView(), nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertSyncViewSelectedNode$lambda$0(consoleText, arg_0)));
    }

    public final void assertSyncViewSelectedNode(@NotNull String nodeText, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeIsSelected(this.getSyncView(), nodeText);
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getSyncView(), nodeText, consoleTextChecker);
    }

    public final void assertBuildViewTree(@NotNull Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        BuildViewAssertions.INSTANCE.assertBuildViewTree(this.getBuildView(), function1);
    }

    public final void assertBuildViewTreeEquals(@NotNull String executionTree) {
        Intrinsics.checkNotNullParameter((Object)executionTree, (String)"executionTree");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getBuildView(), (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertBuildViewTreeEquals$lambda$0(executionTree, arg_0)));
    }

    public final void assertBuildViewTreeSame(@NotNull String executionTree) {
        Intrinsics.checkNotNullParameter((Object)executionTree, (String)"executionTree");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getBuildView(), (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertBuildViewTreeSame$lambda$0(this, executionTree, arg_0)));
    }

    public final void assertBuildViewTreeEquals(@NotNull Function1<? super String, Unit> treeTestPresentationChecker) {
        Intrinsics.checkNotNullParameter(treeTestPresentationChecker, (String)"treeTestPresentationChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewTreeText(this.getBuildView(), treeTestPresentationChecker);
    }

    public final void assertBuildViewNode(@NotNull String nodeText, @NotNull String consoleText) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getBuildView(), nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertBuildViewNode$lambda$0(consoleText, arg_0)));
    }

    public final void assertBuildViewNode(@NotNull String nodeText, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getBuildView(), nodeText, consoleTextChecker);
    }

    public final void assertBuildViewNodeConsole(@NotNull String nodeText, @NotNull Function1<? super ExecutionConsole, Unit> consoleChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleChecker, (String)"consoleChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsole(this.getBuildView(), nodeText, consoleChecker);
    }

    public final void assertBuildViewSelectedNode(@NotNull String nodeText, @NotNull String consoleText) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter((Object)consoleText, (String)"consoleText");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeIsSelected(this.getBuildView(), nodeText);
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getBuildView(), nodeText, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewTestFixture.assertBuildViewSelectedNode$lambda$0(consoleText, arg_0)));
    }

    public final void assertBuildViewSelectedNode(@NotNull String nodeText, @NotNull Function1<? super String, Unit> consoleTextChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleTextChecker, (String)"consoleTextChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeIsSelected(this.getBuildView(), nodeText);
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsoleText(this.getBuildView(), nodeText, consoleTextChecker);
    }

    public final void assertBuildViewSelectedNodeConsole(@NotNull String nodeText, @NotNull Function1<? super ExecutionConsole, Unit> consoleChecker) {
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(consoleChecker, (String)"consoleChecker");
        BuildViewAssertions.INSTANCE.assertBuildViewNodeIsSelected(this.getBuildView(), nodeText);
        BuildViewAssertions.INSTANCE.assertBuildViewNodeConsole(this.getBuildView(), nodeText, consoleChecker);
    }

    private final List<String> buildTasksNodesAsList(String treeStringPresentation) {
        List list = new ArrayList();
        StringBuilder buffer = new StringBuilder();
        for (String line : StringsKt.lineSequence((CharSequence)treeStringPresentation)) {
            if (StringsKt.startsWith$default((String)line, (String)" -", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"  :", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"  -", (boolean)false, (int)2, null)) {
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                list.add(string);
                StringsKt.clear((StringBuilder)buffer);
            }
            buffer.append(line).append('\n');
        }
        if (((CharSequence)buffer).length() > 0) {
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            list.add(string);
        }
        return list;
    }

    private static final Unit tearDown$lambda$2$0(BuildViewTestFixture this$0) {
        Disposable disposable = this$0.fixtureDisposable;
        if (disposable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
            disposable = null;
        }
        Disposer.dispose((Disposable)disposable);
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$0(BuildViewTestFixture this$0) {
        if (this$0.syncViewManager != null) {
            TestSyncViewManager testSyncViewManager = this$0.syncViewManager;
            if (testSyncViewManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"syncViewManager");
                testSyncViewManager = null;
            }
            testSyncViewManager.waitForPendingBuilds();
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$1(BuildViewTestFixture this$0) {
        if (this$0.buildViewManager != null) {
            TestBuildViewManager testBuildViewManager = this$0.buildViewManager;
            if (testBuildViewManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildViewManager");
                testBuildViewManager = null;
            }
            testBuildViewManager.waitForPendingBuilds();
        }
        return Unit.INSTANCE;
    }

    private static final Unit tearDown$lambda$2(BuildViewTestFixture this$0) {
        EdtTestUtilKt.runInEdtAndWait(() -> BuildViewTestFixture.tearDown$lambda$2$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit assertSyncViewTreeEquals$lambda$0(String $executionTreeText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)((Object)StringsKt.trim((CharSequence)$executionTreeText)).toString(), (Object)((Object)StringsKt.trim((CharSequence)it)).toString());
        return Unit.INSTANCE;
    }

    private static final Unit assertSyncViewTreeSame$lambda$0(BuildViewTestFixture this$0, String $executionTreeText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CollectionAssertions.assertEqualsUnordered$default(this$0.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)it)).toString()), this$0.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)$executionTreeText)).toString()), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertSyncViewNode$lambda$0(String $consoleText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)$consoleText, (Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit assertSyncViewSelectedNode$lambda$0(String $consoleText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)$consoleText, (Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewTreeEquals$lambda$0(String $executionTree, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)((Object)StringsKt.trim((CharSequence)$executionTree)).toString(), (Object)((Object)StringsKt.trim((CharSequence)it)).toString());
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewTreeSame$lambda$0(BuildViewTestFixture this$0, String $executionTree, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CollectionAssertions.assertEqualsUnordered$default(this$0.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)it)).toString()), this$0.buildTasksNodesAsList(((Object)StringsKt.trim((CharSequence)$executionTree)).toString()), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewNode$lambda$0(String $consoleText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)$consoleText, (Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewSelectedNode$lambda$0(String $consoleText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Assertions.assertEquals((Object)$consoleText, (Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0014J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestBuildViewManager;", "Lcom/intellij/build/BuildViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "recentBuild", "Lcom/intellij/build/BuildDescriptor;", "getBuildView", "Lcom/intellij/build/BuildView;", "waitForPendingBuilds", "", "onBuildStart", "buildDescriptor", "onBuildFinish", "intellij.platform.testFramework"})
    private static final class TestBuildViewManager
    extends BuildViewManager {
        @NotNull
        private final Semaphore semaphore;
        private BuildDescriptor recentBuild;

        public TestBuildViewManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.semaphore = new Semaphore();
        }

        @NotNull
        public final BuildView getBuildView() {
            this.waitForPendingBuilds();
            Map map = this.getBuildsMap();
            BuildDescriptor buildDescriptor = this.recentBuild;
            if (buildDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentBuild");
                buildDescriptor = null;
            }
            Object v = map.get(buildDescriptor);
            Intrinsics.checkNotNull(v);
            return (BuildView)v;
        }

        public final void waitForPendingBuilds() {
            TestCase.assertTrue((boolean)this.semaphore.waitFor(2000L));
            EdtTestUtilKt.runInEdtAndWait(TestBuildViewManager::waitForPendingBuilds$lambda$0);
        }

        protected void onBuildStart(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildStart(buildDescriptor);
            this.recentBuild = buildDescriptor;
            this.semaphore.down();
        }

        protected void onBuildFinish(@Nullable BuildDescriptor buildDescriptor) {
            super.onBuildFinish(buildDescriptor);
            this.semaphore.up();
        }

        private static final Unit waitForPendingBuilds$lambda$0() {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/fixtures/BuildViewTestFixture$TestSyncViewManager;", "Lcom/intellij/build/SyncViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "recentBuild", "Lcom/intellij/build/BuildDescriptor;", "getBuildView", "Lcom/intellij/build/BuildView;", "waitForPendingBuilds", "", "onBuildStart", "buildDescriptor", "onBuildFinish", "intellij.platform.testFramework"})
    private static final class TestSyncViewManager
    extends SyncViewManager {
        @NotNull
        private final Semaphore semaphore;
        private BuildDescriptor recentBuild;

        public TestSyncViewManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.semaphore = new Semaphore();
        }

        @NotNull
        public final BuildView getBuildView() {
            this.waitForPendingBuilds();
            Map map = this.getBuildsMap();
            BuildDescriptor buildDescriptor = this.recentBuild;
            if (buildDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentBuild");
                buildDescriptor = null;
            }
            Object v = map.get(buildDescriptor);
            Intrinsics.checkNotNull(v);
            return (BuildView)v;
        }

        public final void waitForPendingBuilds() {
            TestCase.assertTrue((boolean)this.semaphore.waitFor(1000L));
            EdtTestUtilKt.runInEdtAndWait(TestSyncViewManager::waitForPendingBuilds$lambda$0);
        }

        protected void onBuildStart(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildStart(buildDescriptor);
            this.recentBuild = buildDescriptor;
            this.semaphore.down();
        }

        protected void onBuildFinish(@NotNull BuildDescriptor buildDescriptor) {
            Intrinsics.checkNotNullParameter((Object)buildDescriptor, (String)"buildDescriptor");
            super.onBuildFinish(buildDescriptor);
            this.semaphore.up();
        }

        private static final Unit waitForPendingBuilds$lambda$0() {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            return Unit.INSTANCE;
        }
    }
}

