/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

public class RehighlightAllEditors
implements MadTestingAction {
    private static final Logger LOG = Logger.getInstance(RehighlightAllEditors.class);
    private final Project myProject;

    public RehighlightAllEditors(Project project) {
        this.myProject = project;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            RehighlightAllEditors.$$$reportNull$$$0(0);
        }
        env.logMessage(this.toString());
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            RehighlightAllEditors.highlightEditor(((TextEditor)editor).getEditor(), this.myProject);
        }
    }

    public String toString() {
        return "RehighlightAllEditors";
    }

    @NotNull
    public static List<HighlightInfo> highlightEditor(Editor editor, Project project) {
        List list;
        FileDocumentManager.getInstance().saveAllDocuments();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiUtilBase.assertEditorAndProjectConsistent((Project)project, (Editor)editor);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        PsiTestUtil.checkStubsMatchText(file);
        String text = editor.getDocument().getText();
        try {
            Ref infos = Ref.create();
            MadTestingUtil.prohibitDocumentChanges(() -> infos.set(CodeInsightTestFixtureImpl.instantiateAndRun(file, editor, new int[0], true)));
            list = (List)infos.get();
        }
        catch (Throwable e) {
            LOG.debug("Exception occurred during highlighting in " + String.valueOf(editor.getDocument()) + ", text before:\n" + text);
            throw e;
        }
        if (list == null) {
            RehighlightAllEditors.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/RehighlightAllEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/RehighlightAllEditors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

