/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0007\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\u0002H\u0007\u00a8\u0006\n"}, d2={"findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/editor/Document;", "getVirtualFile", "commitToPsi", "", "project", "Lcom/intellij/openapi/project/Project;", "saveToDisk", "reloadFromDisk", "intellij.platform.testFramework"})
public final class DocumentUtilKt {
    @RequiresReadLock
    @Nullable
    public static final VirtualFile findVirtualFile(@NotNull Document $this$findVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$findVirtualFile, (String)"<this>");
        return FileDocumentManager.getInstance().getFile($this$findVirtualFile);
    }

    @RequiresReadLock
    @NotNull
    public static final VirtualFile getVirtualFile(@NotNull Document $this$getVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFile, (String)"<this>");
        VirtualFile virtualFile = DocumentUtilKt.findVirtualFile($this$getVirtualFile);
        if (virtualFile == null) {
            boolean bl = false;
            String string = "Cannot find virtual file for " + $this$getVirtualFile;
            throw new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    @RequiresWriteLock
    public static final void commitToPsi(@NotNull Document $this$commitToPsi, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$commitToPsi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiDocumentManager.getInstance((Project)project).commitDocument($this$commitToPsi);
    }

    @RequiresWriteLock
    public static final void saveToDisk(@NotNull Document $this$saveToDisk) {
        Intrinsics.checkNotNullParameter((Object)$this$saveToDisk, (String)"<this>");
        FileDocumentManager.getInstance().saveDocument($this$saveToDisk);
    }

    @RequiresWriteLock
    public static final void reloadFromDisk(@NotNull Document $this$reloadFromDisk) {
        Intrinsics.checkNotNullParameter((Object)$this$reloadFromDisk, (String)"<this>");
        FileDocumentManager.getInstance().reloadFromDisk($this$reloadFromDisk);
    }
}

