/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0019\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007\u001a\u0019\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007\u001a\u0019\u0010\f\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007\u001a\u0019\u0010\r\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0007\u001a \u0010\u0010\u001a\u00020\u000f*\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u001a\u0019\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007\u001a-\u0010\u0010\u001a\u00020\u000f*\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u001a\n\u0010\u0014\u001a\u00020\u0002*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0002*\u00020\u0015\u00a8\u0006\u0017"}, d2={"getDocument", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getFile", "relativePath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "getDirectory", "createFile", "createDirectory", "deleteRecursively", "", "deleteChildrenRecursively", "predicate", "Lkotlin/Function1;", "", "refreshAndGetVirtualFile", "Ljava/nio/file/Path;", "refreshAndGetVirtualDirectory", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nVirtualFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/testFramework/utils/vfs/VirtualFileUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n3938#2:116\n4474#2,2:117\n1915#3,2:119\n*S KotlinDebug\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/testFramework/utils/vfs/VirtualFileUtilKt\n*L\n87#1:116\n87#1:117,2\n87#1:119,2\n*E\n"})
public final class VirtualFileUtilKt {
    @RequiresReadLock
    @NotNull
    public static final Document getDocument(@NotNull VirtualFile $this$getDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$getDocument, (String)"<this>");
        Document document = VirtualFileUtil.findDocument((VirtualFile)$this$getDocument);
        if (document == null) {
            boolean bl = false;
            String string = "Cannot find document for " + $this$getDocument.getPath();
            throw new IllegalStateException(string.toString());
        }
        return document;
    }

    @RequiresReadLock
    @NotNull
    public static final PsiFile getPsiFile(@NotNull VirtualFile $this$getPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)$this$getPsiFile);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
        return psiFile;
    }

    @RequiresReadLock
    @NotNull
    public static final VirtualFile getFile(@NotNull VirtualFile $this$getFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile file = VirtualFileUtil.findFile((VirtualFile)$this$getFile, (String)relativePath);
        if (file == null) {
            Path path = Path.of($this$getFile.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |File doesn't exists: " + NioPathUtil.getResolvedPath((Path)path, (String)relativePath) + "\n      |  basePath = " + $this$getFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return file;
    }

    @RequiresReadLock
    @NotNull
    public static final VirtualFile getDirectory(@NotNull VirtualFile $this$getDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile directory = VirtualFileUtil.findDirectory((VirtualFile)$this$getDirectory, (String)relativePath);
        if (directory == null) {
            Path path = Path.of($this$getDirectory.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Directory doesn't exists: " + NioPathUtil.getResolvedPath((Path)path, (String)relativePath) + "\n      |  basePath = " + $this$getDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return directory;
    }

    @RequiresWriteLock
    @NotNull
    public static final VirtualFile createFile(@NotNull VirtualFile $this$createFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile file = VirtualFileUtil.findFile((VirtualFile)$this$createFile, (String)relativePath);
        if (file != null) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |File already exists: " + file + "\n      |  basePath = " + $this$createFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return VirtualFileUtil.findOrCreateFile((VirtualFile)$this$createFile, (String)relativePath);
    }

    @RequiresWriteLock
    @NotNull
    public static final VirtualFile createDirectory(@NotNull VirtualFile $this$createDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile directory = VirtualFileUtil.findDirectory((VirtualFile)$this$createDirectory, (String)relativePath);
        if (directory != null) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Directory already exists: " + directory + "\n      |  basePath = " + $this$createDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return VirtualFileUtil.findOrCreateDirectory((VirtualFile)$this$createDirectory, (String)relativePath);
    }

    @RequiresWriteLock
    public static final void deleteRecursively(@NotNull VirtualFile $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        $this$deleteRecursively.delete((Object)$this$deleteRecursively.getFileSystem());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    public static final void deleteChildrenRecursively(@NotNull VirtualFile $this$deleteChildrenRecursively, @NotNull Function1<? super VirtualFile, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        VirtualFile[] virtualFileArray = $this$deleteChildrenRecursively.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            it.delete((Object)$this$deleteChildrenRecursively.getFileSystem());
        }
    }

    @RequiresWriteLock
    public static final void deleteRecursively(@NotNull VirtualFile $this$deleteRecursively, @NotNull String relativePath) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory((VirtualFile)$this$deleteRecursively, (String)relativePath);
            if (virtualFile == null) break block0;
            VirtualFileUtilKt.deleteRecursively(virtualFile);
        }
    }

    @RequiresWriteLock
    public static final void deleteChildrenRecursively(@NotNull VirtualFile $this$deleteChildrenRecursively, @NotNull String relativePath, @NotNull Function1<? super VirtualFile, Boolean> predicate) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory((VirtualFile)$this$deleteChildrenRecursively, (String)relativePath);
            if (virtualFile == null) break block0;
            VirtualFileUtilKt.deleteChildrenRecursively(virtualFile, predicate);
        }
    }

    @NotNull
    public static final VirtualFile refreshAndGetVirtualFile(@NotNull Path $this$refreshAndGetVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndGetVirtualFile, (String)"<this>");
        VirtualFile file = VirtualFileUtil.refreshAndFindVirtualFile((Path)$this$refreshAndGetVirtualFile);
        if (file == null) {
            throw new IOException("File doesn't exist: " + $this$refreshAndGetVirtualFile);
        }
        return file;
    }

    @NotNull
    public static final VirtualFile refreshAndGetVirtualDirectory(@NotNull Path $this$refreshAndGetVirtualDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndGetVirtualDirectory, (String)"<this>");
        VirtualFile directory = VirtualFileUtil.refreshAndFindVirtualDirectory((Path)$this$refreshAndGetVirtualDirectory);
        if (directory == null) {
            throw new IOException("Directory doesn't exist: " + $this$refreshAndGetVirtualDirectory);
        }
        return directory;
    }
}

