/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.listenerAssertion;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ%\u0010\u000b\u001a\u00020\n2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000eH\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\nJ\u001c\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J(\u0010\u0019\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0086\b\u00f8\u0001\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/testFramework/assertion/listenerAssertion/ListenerAssertion;", "", "<init>", "()V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "failures", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "reset", "", "trace", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "touch", "addFailure", "failure", "assertListenerFailures", "assertListenerState", "expectedCount", "", "messageSupplier", "Lkotlin/Function0;", "", "assertCancellation", "ExpectedException", "intellij.platform.testFramework"})
public final class ListenerAssertion {
    @NotNull
    private final AtomicInteger counter = new AtomicInteger(0);
    @NotNull
    private final CopyOnWriteArrayList<Throwable> failures = new CopyOnWriteArrayList();

    public final void reset() {
        this.counter.set(0);
        this.failures.clear();
    }

    public final void trace(@NotNull Function1<? super ListenerAssertion, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$trace = false;
        this.touch();
        try {
            action.invoke((Object)this);
            return;
        }
        catch (ExpectedException exception) {
            throw exception.getOriginal();
        }
        catch (Throwable failure) {
            this.addFailure(failure);
            return;
        }
    }

    public final void touch() {
        this.counter.incrementAndGet();
    }

    public final void addFailure(@NotNull Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.failures.add(failure);
    }

    public final void assertListenerFailures() {
        if (this.failures.size() == 1) {
            throw new AssertionError("", (Throwable)CollectionsKt.single((List)this.failures));
        }
        if (this.failures.size() > 1) {
            throw new MultipleFailuresError("", (List)this.failures);
        }
    }

    public final void assertListenerState(int expectedCount, @NotNull Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(messageSupplier, (String)"messageSupplier");
        Assertions.assertEquals((int)expectedCount, (int)this.counter.get(), () -> ListenerAssertion.assertListenerState$lambda$0(messageSupplier));
    }

    public final void assertCancellation(@NotNull Function0<Unit> action, @NotNull Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(messageSupplier, (String)"messageSupplier");
        boolean $i$f$assertCancellation = false;
        try {
            action.invoke();
        }
        catch (CancellationException e) {
            throw new ExpectedException(e);
        }
        throw new AssertionFailedError((String)messageSupplier.invoke());
    }

    private static final String assertListenerState$lambda$0(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/testFramework/assertion/listenerAssertion/ListenerAssertion$ExpectedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "original", "<init>", "(Ljava/lang/Exception;)V", "getOriginal", "()Ljava/lang/Exception;", "intellij.platform.testFramework"})
    public static final class ExpectedException
    extends Exception {
        @NotNull
        private final Exception original;

        public ExpectedException(@NotNull Exception original) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            super("Expected exception", original);
            this.original = original;
        }

        @NotNull
        public final Exception getOriginal() {
            return this.original;
        }
    }
}

