/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

@TestOnly
public final class EditorListenerTracker {
    private static final Set<String> APP_LEVEL_LISTENERS = Set.of("com.intellij.copyright.CopyrightManagerDocumentListener$", "com.intellij.model.BranchServiceImpl$", "com.jetbrains.liveEdit.highlighting.ElementHighlighterCaretListener", "com.intellij.grazie.ide.inspection.auto.ChangeTracker$");
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> before;

    public EditorListenerTracker() {
        EncodingManager.getInstance();
        this.before = ((EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster()).getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkListenersLeak() throws AssertionError {
        try {
            Class aClass;
            EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
            Map after = multicaster.getListeners();
            LinkedHashMap leaked = new LinkedHashMap();
            for (Map.Entry entry : after.entrySet()) {
                aClass = (Class)entry.getKey();
                List<? extends EventListener> beforeList = this.before.get(aClass);
                ArrayList<EventListener> afterList = new ArrayList<EventListener>((Collection)entry.getValue());
                if (beforeList != null) {
                    afterList.removeAll(beforeList);
                }
                afterList.removeIf(listener -> {
                    if (listener instanceof PsiDocumentManager && ((PsiDocumentManagerEx)listener).isDefaultProject()) {
                        return true;
                    }
                    String name = listener.getClass().getName();
                    return ContainerUtil.exists(APP_LEVEL_LISTENERS, name::startsWith);
                });
                if (afterList.isEmpty()) continue;
                leaked.put(aClass, afterList);
            }
            for (Map.Entry entry : leaked.entrySet()) {
                aClass = (Class)entry.getKey();
                List list = (List)entry.getValue();
                String projectNames = StringUtil.join((Collection)ContainerUtil.map((Object[])ProjectManager.getInstance().getOpenProjects(), project -> project.getName()), (String)", ");
                Assert.fail((String)("Listeners leaked for " + String.valueOf(aClass) + ":\n" + String.valueOf(list) + "\nOpened projects: " + projectNames));
            }
        }
        finally {
            this.before.clear();
        }
    }
}

